/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.mobility.project.J2MEProjectUtils;
import org.netbeans.modules.mobility.project.ui.wizard.MIDPTargetChooserPanel;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class MIDPTargetChooserPanelGUI
extends JPanel
implements ActionListener,
DocumentListener {
    private static final Dimension PREF_DIM = new Dimension(500, 340);
    private static final ListCellRenderer CELL_RENDERER = new NodeCellRenderer();
    public static final String IS_MIDLET_TEMPLATE_ATTRIBUTE = "isMIDletTemplate";
    private Project project;
    protected AntProjectHelper helper;
    private String expectedExtension;
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private boolean updateClassName = true;
    private boolean loadIcons = true;
    private Document packageComboBoxDocument = null;
    private boolean isMIDlet;
    public JComboBox cIcon;
    public JTextField fileTextField;
    public JLabel jLabel2;
    public JLabel jLabel4;
    public JLabel jLabel5;
    public JPanel jPanel1;
    public JPanel jPanel3;
    public JSeparator jSeparator1;
    public JLabel lClassName;
    public JLabel lIcon;
    public JLabel lName;
    public JLabel lNote;
    public JComboBox packageComboBox;
    public JTextField projectTextField;
    public JTextField tClassName;
    public JTextField tName;

    public MIDPTargetChooserPanelGUI() {
        this.initComponents();
        this.initAccessibility();
        this.lNote.setFont(this.lNote.getFont().deriveFont(2));
        Component component = this.packageComboBox.getEditor().getEditorComponent();
        if (component instanceof JTextField) {
            this.packageComboBoxDocument = ((JTextField)component).getDocument();
            this.packageComboBoxDocument.addDocumentListener(this);
        } else {
            this.packageComboBox.addActionListener(this);
        }
        this.packageComboBox.setRenderer(CELL_RENDERER);
        this.packageComboBox.addActionListener(this);
    }

    private void addThisListeners() {
        this.tClassName.getDocument().addDocumentListener(this);
    }

    private void removeThisListeners() {
        this.tClassName.getDocument().removeDocumentListener(this);
    }

    public void initValues(Project project, FileObject fileObject, FileObject fileObject2) {
        Object object;
        Object object2;
        this.project = project;
        this.helper = (AntProjectHelper)project.getLookup().lookup(AntProjectHelper.class);
        Object object3 = fileObject.getAttribute(IS_MIDLET_TEMPLATE_ATTRIBUTE);
        this.isMIDlet = false;
        if (object3 instanceof Boolean) {
            this.isMIDlet = (Boolean)object3;
        }
        this.projectTextField.setText(ProjectUtils.getInformation((Project)project).getDisplayName());
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
        SourceGroup sourceGroup = this.getPreselectedGroup(sourceGroupArray, fileObject2);
        if (sourceGroup != null) {
            object2 = new ModelItem(sourceGroup);
            object = ((ModelItem)object2).getChildren();
            this.packageComboBox.setModel(new DefaultComboBoxModel<ModelItem>((E[])object));
            Object object4 = this.getPreselectedPackage((ModelItem)object2, fileObject2);
            if (object4 != null) {
                this.packageComboBox.setSelectedItem(object4);
            }
        } else {
            this.packageComboBox.setModel(new DefaultComboBoxModel());
        }
        object2 = fileObject == null ? "" : fileObject.getExt();
        this.expectedExtension = ((String)object2).length() == 0 ? "" : "." + (String)object2;
        this.lName.setVisible(this.isMIDlet);
        this.tName.setVisible(this.isMIDlet);
        this.lIcon.setVisible(this.isMIDlet);
        this.cIcon.setVisible(this.isMIDlet);
        this.lNote.setVisible(this.isMIDlet);
        Mnemonics.setLocalizedText((JLabel)this.lClassName, (String)NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)(this.isMIDlet ? "LBL_File_MIDletClassName" : "LBL_File_MIDPClassName")));
        if (this.isMIDlet) {
            this.tName.getDocument().removeDocumentListener(this);
            this.tName.setText(fileObject.getName());
            this.updateClassNameAndIcon();
            if (this.testIfFileNameExists(sourceGroup) && this.updateClassName) {
                object = this.tName.getText();
                int n = 1;
                while (true) {
                    this.tName.setText((String)object + "_" + n);
                    this.updateClassNameAndIcon();
                    if (!this.testIfFileNameExists(sourceGroup) || !this.updateClassName) break;
                    ++n;
                }
            }
            this.tName.getDocument().addDocumentListener(this);
        } else {
            this.tClassName.setText(fileObject.getName());
            if (this.testIfFileNameExists(sourceGroup)) {
                object = this.tClassName.getText();
                int n = 1;
                while (true) {
                    this.tClassName.setText((String)object + "_" + n);
                    if (!this.testIfFileNameExists(sourceGroup)) break;
                    ++n;
                }
            }
            this.tClassName.getDocument().addDocumentListener(this);
        }
        this.updateText();
        if (this.loadIcons) {
            this.loadIcons = false;
            object = new DefaultComboBoxModel();
            this.cIcon.setModel(object);
            this.cIcon.setSelectedItem("");
            RequestProcessor.getDefault().post(new Runnable((DefaultComboBoxModel)object){
                final /* synthetic */ DefaultComboBoxModel val$icons;
                {
                    this.val$icons = defaultComboBoxModel;
                }

                public void run() {
                    ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
                    arrayList.add(MIDPTargetChooserPanelGUI.this.helper.resolveFileObject(MIDPTargetChooserPanelGUI.this.helper.getStandardPropertyEvaluator().getProperty("src.dir")));
                    String string = J2MEProjectUtils.evaluateProperty(MIDPTargetChooserPanelGUI.this.helper, "libs.classpath");
                    if (string != null) {
                        String[] stringArray = PropertyUtils.tokenizePath((String)MIDPTargetChooserPanelGUI.this.helper.resolvePath(string));
                        for (int i = 0; i < stringArray.length; ++i) {
                            try {
                                FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(stringArray[i])));
                                if (fileObject == null) continue;
                                arrayList.add(FileUtil.isArchiveFile((FileObject)fileObject) ? FileUtil.getArchiveRoot((FileObject)fileObject) : fileObject);
                                continue;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    for (FileObject fileObject : arrayList) {
                        if (fileObject == null) continue;
                        int n = fileObject.getPath().length();
                        Enumeration enumeration = fileObject.getChildren(true);
                        while (enumeration.hasMoreElements()) {
                            String string2;
                            FileObject fileObject2 = (FileObject)enumeration.nextElement();
                            if (!fileObject2.isData() || !"png".equals(string2 = fileObject2.getExt().toLowerCase())) continue;
                            String string3 = fileObject2.getPath().substring(n);
                            if (!string3.startsWith("/")) {
                                string3 = "/" + string3;
                            }
                            if (this.val$icons.getIndexOf(string3) >= 0) continue;
                            this.val$icons.addElement(string3);
                        }
                    }
                }
            });
        }
    }

    private boolean testIfFileNameExists(SourceGroup sourceGroup) {
        FileObject fileObject = null;
        if (sourceGroup != null) {
            fileObject = sourceGroup.getRootFolder();
        }
        if (fileObject == null) {
            return false;
        }
        String string = this.getPackageFileName();
        if (string != null && !"".equals(string) && (fileObject = fileObject.getFileObject(string)) == null) {
            return false;
        }
        return fileObject.getFileObject(this.tClassName.getText() + this.expectedExtension) != null;
    }

    public void updateClassNameAndIcon() {
        if (!this.isMIDlet) {
            return;
        }
        this.removeThisListeners();
        String string = this.tName.getText();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!Character.isJavaIdentifierPart(c) || stringBuffer.length() <= 0 && !Character.isJavaIdentifierStart(c)) continue;
            stringBuffer.append(c);
        }
        string = stringBuffer.toString();
        if (this.updateClassName) {
            this.tClassName.setText(string);
        }
        this.addThisListeners();
    }

    public boolean isMIDletTemplate() {
        return this.isMIDlet;
    }

    public String getMIDletName() {
        return MIDPTargetChooserPanelGUI.normalizedString(this.tName.getText());
    }

    public String getClassName() {
        return MIDPTargetChooserPanelGUI.normalizedString(this.tClassName.getText());
    }

    public String getMIDletIcon() {
        return MIDPTargetChooserPanelGUI.normalizedString(this.cIcon.getEditor().getItem().toString());
    }

    public String getTargetName() {
        return MIDPTargetChooserPanelGUI.normalizedString(this.tClassName.getText());
    }

    public String getCreatedFile() {
        return this.fileTextField.getText();
    }

    private static String normalizedString(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() <= 0) {
            return null;
        }
        return string;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    private void fireChange() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.lName = new JLabel();
        this.tName = new JTextField();
        this.lClassName = new JLabel();
        this.tClassName = new JTextField();
        this.lIcon = new JLabel();
        this.cIcon = new JComboBox();
        this.jLabel5 = new JLabel();
        this.projectTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.packageComboBox = new JComboBox();
        this.jLabel4 = new JLabel();
        this.fileTextField = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.jPanel3 = new JPanel();
        this.lNote = new JLabel();
        this.setName(NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"TITLE_File"));
        this.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.lName.setLabelFor(this.tName);
        Mnemonics.setLocalizedText((JLabel)this.lName, (String)NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"LBL_File_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 3, 4);
        this.jPanel1.add((Component)this.lName, gridBagConstraints);
        this.lName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"ACSN_MidletName"));
        this.lName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"ACSD_MidletName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 4, 3, 4);
        this.jPanel1.add((Component)this.tName, gridBagConstraints);
        this.tName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"ACSN_MidletName"));
        this.tName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"ACSD_MidletName"));
        this.lClassName.setLabelFor(this.tClassName);
        Mnemonics.setLocalizedText((JLabel)this.lClassName, (String)NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"LBL_File_MIDletClassName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 3, 4);
        this.jPanel1.add((Component)this.lClassName, gridBagConstraints);
        this.lClassName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"ACSN_MidpClassName"));
        this.lClassName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"ACSD_MidpClassName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 4, 3, 4);
        this.jPanel1.add((Component)this.tClassName, gridBagConstraints);
        this.tClassName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"ACSN_MidpClassName"));
        this.tClassName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"ACSD_MidpClassName"));
        this.lIcon.setLabelFor(this.cIcon);
        Mnemonics.setLocalizedText((JLabel)this.lIcon, (String)NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"LBL_File_Icon"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 3, 4);
        this.jPanel1.add((Component)this.lIcon, gridBagConstraints);
        this.lIcon.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"ACSN_MidletIcon"));
        this.lIcon.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"ACSD_MidletIcon"));
        this.cIcon.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 4, 3, 4);
        this.jPanel1.add((Component)this.cIcon, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 24, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jLabel5.setLabelFor(this.projectTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"LBL_File_Project"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel5.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"ACSN_MidpTargetProject"));
        this.jLabel5.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"ACSD_MidpTargetProject"));
        this.projectTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.projectTextField, gridBagConstraints);
        this.projectTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"ACSN_MidpTargetProject"));
        this.projectTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"ACSD_MidpTargetProject"));
        this.jLabel2.setLabelFor(this.packageComboBox);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"LBL_File_Package"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel2.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"ACSN_MidpTargetPackage"));
        this.jLabel2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"ACSD_MidpTargetPackage"));
        this.packageComboBox.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.packageComboBox, gridBagConstraints);
        this.packageComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"ACSN_MidpTargetPackage"));
        this.packageComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"ACSD_MidpTargetPackage"));
        this.jLabel4.setLabelFor(this.fileTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"LBL_File_Created"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel4.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"ACSN_CreatedFile"));
        this.jLabel4.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"ACSD_CreatedFile"));
        this.fileTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.fileTextField, gridBagConstraints);
        this.fileTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"ACSN_CreatedFile"));
        this.fileTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"ACSD_CreatedFile"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.jSeparator1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel3, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lNote, (String)NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"LBL_MIDPTarget_Note"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.lNote, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"ACSN_File"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MIDPTargetChooserPanelGUI.class, (String)"ACSD_File"));
    }

    public Dimension getPreferredSize() {
        return PREF_DIM;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.packageComboBox == actionEvent.getSource()) {
            this.updateText();
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this.tName.getDocument()) {
            this.updateClassNameAndIcon();
            this.updateText();
            this.fireChange();
        } else if (documentEvent.getDocument() == this.tClassName.getDocument()) {
            this.updateText();
            this.fireChange();
            this.updateClassName = false;
        } else if (this.packageComboBoxDocument != null && documentEvent.getDocument() == this.packageComboBoxDocument) {
            this.updateText();
            this.fireChange();
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    private SourceGroup getPreselectedGroup(SourceGroup[] sourceGroupArray, FileObject fileObject) {
        if (fileObject != null) {
            for (int i = 0; i < sourceGroupArray.length; ++i) {
                if (!sourceGroupArray[i].getRootFolder().equals(fileObject) && !FileUtil.isParentOf((FileObject)sourceGroupArray[i].getRootFolder(), (FileObject)fileObject)) continue;
                return sourceGroupArray[i];
            }
        }
        return sourceGroupArray.length >= 0 ? sourceGroupArray[0] : null;
    }

    private Object getPreselectedPackage(ModelItem modelItem, FileObject fileObject) {
        if (fileObject == null) {
            return null;
        }
        ModelItem[] modelItemArray = modelItem.getChildren();
        FileObject fileObject2 = modelItem.group.getRootFolder();
        String string = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject);
        string = string == null ? "" : string.replace('/', '.');
        for (int i = 0; i < modelItemArray.length; ++i) {
            if (!modelItemArray[i].toString().equals(string)) continue;
            return modelItemArray[i];
        }
        return string;
    }

    public FileObject getRootFolder() {
        return this.helper.resolveFileObject(this.helper.getStandardPropertyEvaluator().getProperty("src.dir"));
    }

    public File getFolder() {
        FileObject fileObject = this.getRootFolder();
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file == null) {
            return null;
        }
        return new File(file, this.getPackageFileName());
    }

    public String getPackageFileName() {
        String string = this.packageComboBox.getEditor().getItem().toString();
        if (ModelItem.DEFAULT_PACKAGE_DISPLAY_NAME.equals(string)) {
            string = "";
        }
        return string.replace('.', '/');
    }

    private void updateText() {
        File file = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
        if (file != null) {
            String string = this.tClassName.getText().trim();
            if (string.length() == 0) {
                this.fileTextField.setText("");
            } else {
                File file2 = this.getFolder();
                if (file2 != null) {
                    File file3 = new File(file2, string + this.expectedExtension);
                    this.fileTextField.setText(file3.getAbsolutePath());
                } else {
                    this.fileTextField.setText("");
                }
            }
        } else {
            this.fileTextField.setText("");
        }
    }

    private static class NodeCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public NodeCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof ModelItem) {
                ModelItem modelItem = (ModelItem)object;
                this.setText(modelItem.getDisplayName());
                this.setIcon(modelItem.getIcon());
            } else {
                this.setText(object.toString());
                this.setIcon(null);
            }
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }
    }

    private static class ModelItem {
        public static final String DEFAULT_PACKAGE_DISPLAY_NAME = NbBundle.getMessage(MIDPTargetChooserPanel.class, (String)"LBL_MIDPTargetChooserPanelGUI_DefaultPackage");
        private final Icon icon;
        private Node node;
        protected SourceGroup group;
        private ModelItem[] children;

        public ModelItem(SourceGroup sourceGroup) {
            this.group = sourceGroup;
            this.icon = sourceGroup.getIcon(false);
        }

        public ModelItem(Node node) {
            this.node = node;
            this.icon = new ImageIcon(node.getIcon(1));
        }

        public String getDisplayName() {
            if (this.group != null) {
                return this.group.getDisplayName();
            }
            String string = this.node.getName();
            return string.length() == 0 ? DEFAULT_PACKAGE_DISPLAY_NAME : string;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public String toString() {
            if (this.group != null) {
                return this.getDisplayName();
            }
            return this.node.getName();
        }

        public ModelItem[] getChildren() {
            if (this.group == null) {
                return null;
            }
            if (this.children == null) {
                Node node = PackageView.createPackageView((SourceGroup)this.group);
                if (node == null) {
                    return null;
                }
                Children children = node.getChildren();
                if (children == null) {
                    return null;
                }
                Node[] nodeArray = children.getNodes(true);
                this.children = new ModelItem[nodeArray.length];
                for (int i = 0; i < nodeArray.length; ++i) {
                    this.children[i] = new ModelItem(nodeArray[i]);
                }
            }
            return this.children;
        }
    }
}

