/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.customizer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.mobility.project.ui.customizer.CustomizerConfigManager;
import org.netbeans.modules.mobility.project.ui.customizer.J2MEProjectProperties;
import org.netbeans.modules.mobility.project.ui.customizer.NewConfigurationPanel;
import org.netbeans.modules.mobility.project.ui.customizer.VisualConfigSupport;
import org.netbeans.spi.mobility.project.ui.customizer.ComposedCustomizerPanel;
import org.netbeans.spi.mobility.project.ui.customizer.CustomizerPanel;
import org.netbeans.spi.mobility.project.ui.customizer.HelpCtxCallback;
import org.netbeans.spi.mobility.project.ui.customizer.VisualPropertyGroup;
import org.netbeans.spi.mobility.project.ui.customizer.support.VisualPropertySupport;
import org.netbeans.spi.project.ProjectConfiguration;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class J2MECustomizer
extends JPanel
implements Runnable,
HelpCtxCallback {
    private static final String REGISTRATION_FOLDER = "Customizer/org.netbeans.modules.kjava.j2meproject";
    private static final ProjectConfiguration ADD_CONFIGURATION = new ProjectConfiguration(){
        private final String name = NbBundle.getMessage(J2MECustomizer.class, (String)"LBL_Customizer_AddConfiguration");

        public String getDisplayName() {
            return this.name;
        }
    };
    public static final String ADD_CONFIG_DIALOG = "AddConfigDialog";
    private J2MEProjectProperties props;
    private CategoryView categoryView;
    private DialogDescriptor descriptor;
    private String startPanel = "";
    private JPanel categoryPanel;
    private JComboBox configurationCombo;
    private JPanel configurationPanel;
    private JPanel customizerPanel;
    private JButton jButtonEdit;
    private JLabel jLabelCategory;
    private JLabel jLabelConfig;
    private JSeparator jSeparator2;

    public J2MECustomizer(J2MEProjectProperties j2MEProjectProperties, String string) {
        this(j2MEProjectProperties);
        this.startPanel = string;
    }

    public J2MECustomizer(J2MEProjectProperties j2MEProjectProperties) {
        this.initComponents();
        this.configurationCombo.setRenderer(new ConfigurationCellRenderer());
        this.props = j2MEProjectProperties;
        this.categoryView = new CategoryView(this.createRootNode());
        this.categoryPanel.add((Component)this.categoryView, "Center");
        this.initAccessibility();
        this.setConfigurationCombo();
    }

    public void setDialogDescriptor(DialogDescriptor dialogDescriptor) {
        this.descriptor = dialogDescriptor;
    }

    public void updateHelpCtx(HelpCtx helpCtx) {
        if (this.descriptor != null) {
            this.descriptor.setHelpCtx(helpCtx);
        }
    }

    public final void setConfigurationCombo() {
        ProjectConfiguration projectConfiguration;
        Vector<ProjectConfiguration> vector = new Vector<ProjectConfiguration>(Arrays.asList(this.props.getConfigurations()));
        if (!vector.contains(projectConfiguration = this.props.getActiveConfiguration())) {
            projectConfiguration = vector.get(0);
            this.props.setActiveConfiguration(projectConfiguration);
        }
        vector.add(ADD_CONFIGURATION);
        this.configurationCombo.setModel(new DefaultComboBoxModel<ProjectConfiguration>(vector));
        this.configurationCombo.setSelectedItem(projectConfiguration);
    }

    private void initComponents() {
        this.configurationPanel = new JPanel();
        this.jLabelConfig = new JLabel();
        this.configurationCombo = new JComboBox();
        this.jButtonEdit = new JButton();
        this.jSeparator2 = new JSeparator();
        this.jLabelCategory = new JLabel();
        this.categoryPanel = new JPanel();
        this.customizerPanel = new JPanel();
        this.setMinimumSize(new Dimension(760, 500));
        this.setPreferredSize(new Dimension(760, 530));
        this.setLayout(new GridBagLayout());
        this.configurationPanel.setLayout(new GridBagLayout());
        this.jLabelConfig.setLabelFor(this.configurationCombo);
        Mnemonics.setLocalizedText((JLabel)this.jLabelConfig, (String)NbBundle.getMessage(J2MECustomizer.class, (String)"LBL_Customizer_Configuration"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.configurationPanel.add((Component)this.jLabelConfig, gridBagConstraints);
        this.configurationCombo.setMinimumSize(new Dimension(220, 24));
        this.configurationCombo.setPreferredSize(new Dimension(220, 24));
        this.configurationCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                J2MECustomizer.this.configurationComboActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 6, 0, 0);
        this.configurationPanel.add((Component)this.configurationCombo, gridBagConstraints);
        this.configurationCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2MECustomizer.class, (String)"ACSD_Customizer_Configuration"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonEdit, (String)NbBundle.getMessage(J2MECustomizer.class, (String)"LBL_Customizer_Edit"));
        this.jButtonEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                J2MECustomizer.this.jButtonEditActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 5, 0, 8);
        this.configurationPanel.add((Component)this.jButtonEdit, gridBagConstraints);
        this.jButtonEdit.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2MECustomizer.class, (String)"ACSD_Customizer_ManageCfgButton"));
        this.jSeparator2.setMinimumSize(new Dimension(0, 5));
        this.jSeparator2.setPreferredSize(new Dimension(0, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(11, 8, 0, 8);
        this.configurationPanel.add((Component)this.jSeparator2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.configurationPanel, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabelCategory, (String)NbBundle.getMessage(J2MECustomizer.class, (String)"LBL_Customizer_Category"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 8, 0, 8);
        this.add((Component)this.jLabelCategory, gridBagConstraints);
        this.jLabelCategory.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2MECustomizer.class, (String)"ACSD_Customizer_Category"));
        this.categoryPanel.setBorder(BorderFactory.createEtchedBorder());
        this.categoryPanel.setMinimumSize(new Dimension(220, 24));
        this.categoryPanel.setPreferredSize(new Dimension(220, 24));
        this.categoryPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 8, 8, 8);
        this.add((Component)this.categoryPanel, gridBagConstraints);
        this.customizerPanel.setMinimumSize(new Dimension(530, 10));
        this.customizerPanel.setPreferredSize(new Dimension(530, 10));
        this.customizerPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.customizerPanel, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(J2MECustomizer.class, (String)"ACSN_Customizer"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2MECustomizer.class, (String)"ACSD_Customizer"));
        this.jLabelCategory.setLabelFor((Component)this.categoryView.getBeanTreeView());
    }

    private void jButtonEditActionPerformed(ActionEvent actionEvent) {
        CustomizerConfigManager customizerConfigManager = new CustomizerConfigManager(this.props, null);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new DialogDescriptor((Object)customizerConfigManager, NbBundle.getMessage(J2MECustomizer.class, (String)"Title_ProjectConfigurationManager"), true, new Object[]{NotifyDescriptor.CLOSED_OPTION}, NotifyDescriptor.CLOSED_OPTION, 0, new HelpCtx(CustomizerConfigManager.class), null));
        this.setConfigurationCombo();
    }

    private void configurationComboActionPerformed(ActionEvent actionEvent) {
        if (ADD_CONFIGURATION.equals(this.configurationCombo.getSelectedItem())) {
            RequestProcessor.getDefault().post((Runnable)this);
        } else {
            this.props.setActiveConfiguration((ProjectConfiguration)this.configurationCombo.getSelectedItem());
            this.categoryView.updateCustomizerPanel();
        }
    }

    public void run() {
        if (!this.isShowing()) {
            SwingUtilities.invokeLater(this);
            return;
        }
        final NewConfigurationPanel newConfigurationPanel = new NewConfigurationPanel(this.props.getAllIdentifiers());
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)newConfigurationPanel, NbBundle.getMessage(J2MECustomizer.class, (String)"Title_Customizer_AddConfiguration"), true, 2, NotifyDescriptor.OK_OPTION, null);
        newConfigurationPanel.setDialogDescriptor(dialogDescriptor);
        if (NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor))) {
            ProjectConfiguration projectConfiguration = new ProjectConfiguration(){
                private final String name;
                {
                    this.name = newConfigurationPanel.getName();
                }

                public String getDisplayName() {
                    return this.name;
                }
            };
            ProjectConfiguration[] projectConfigurationArray = this.props.getConfigurations();
            ProjectConfiguration[] projectConfigurationArray2 = new ProjectConfiguration[projectConfigurationArray.length + 1];
            System.arraycopy(projectConfigurationArray, 0, projectConfigurationArray2, 0, projectConfigurationArray.length);
            projectConfigurationArray2[projectConfigurationArray2.length - 1] = projectConfiguration;
            this.props.setConfigurations(projectConfigurationArray2);
            VisualConfigSupport.createFromTemplate(this.props, newConfigurationPanel.getName(), newConfigurationPanel.getTemplate());
            this.props.setActiveConfiguration(projectConfiguration);
            this.setConfigurationCombo();
        } else {
            if (this.props.getActiveConfiguration() == null) {
                this.configurationCombo.setSelectedIndex(0);
            } else {
                this.configurationCombo.setSelectedItem(this.props.getActiveConfiguration());
            }
            this.categoryView.updateCustomizerPanel();
        }
    }

    public void addNotify() {
        super.addNotify();
        if (ADD_CONFIG_DIALOG.equals(this.startPanel)) {
            SwingUtilities.invokeLater(this);
        }
    }

    private Node createRootNode() {
        DataFolder dataFolder = DataFolder.findFolder((FileObject)FileUtil.getConfigFile((String)REGISTRATION_FOLDER));
        return new FNode(dataFolder.getNodeDelegate(), Children.create((ChildFactory)new ConfigurationChildFactory(dataFolder), (boolean)true));
    }

    private static class ConfigurationCellRenderer
    extends DefaultListCellRenderer {
        private ConfigurationCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object instanceof ProjectConfiguration) {
                this.setText(((ProjectConfiguration)object).getDisplayName());
            }
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ConfigurationChildFactory
    extends ChildFactory<DataFolder> {
        private final DataFolder parent;

        private ConfigurationChildFactory(DataFolder dataFolder) {
            this.parent = dataFolder;
        }

        protected boolean createKeys(List<DataFolder> list) {
            for (DataObject dataObject : this.parent.getChildren()) {
                if (!(dataObject instanceof DataFolder)) continue;
                list.add((DataFolder)dataObject);
            }
            return true;
        }

        protected Node createNodeForKey(DataFolder dataFolder) {
            return new FNode(dataFolder.getNodeDelegate(), Children.create((ChildFactory)new ConfigurationChildFactory(dataFolder), (boolean)true));
        }
    }

    private static class FNode
    extends FilterNode {
        public FNode(Node node, Children children) {
            super(node, children);
        }

        public boolean canCopy() {
            return false;
        }

        public boolean canDestroy() {
            return false;
        }

        public boolean canCut() {
            return false;
        }

        public boolean canRename() {
            return false;
        }
    }

    private class CategoryView
    extends JPanel
    implements ExplorerManager.Provider,
    ChangeListener {
        protected final ExplorerManager manager;
        private final BeanTreeView btv;
        private HashMap<Node, Integer> tabSelections = new HashMap();

        CategoryView(Node node) {
            Object object;
            this.manager = new ExplorerManager();
            this.setLayout(new BorderLayout());
            Dimension dimension = new Dimension(220, 4);
            this.btv = new BeanTreeView();
            try {
                object = BeanTreeView.class.getDeclaredField("tree");
                ((Field)object).setAccessible(true);
                J2MECustomizer.this.jLabelCategory.setLabelFor((Component)((Field)object).get(this.btv));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.btv.setSelectionMode(1);
            this.btv.setPopupAllowed(false);
            this.btv.setRootVisible(false);
            this.btv.setDefaultActionAllowed(false);
            this.btv.setMinimumSize(dimension);
            this.btv.setPreferredSize(dimension);
            this.btv.setMaximumSize(dimension);
            this.add((Component)this.btv, "Center");
            node.addNodeListener((NodeListener)new NL(node));
            this.manager.setRootContext(node);
            this.selectFirstNode();
            this.btv.expandAll();
            this.manager.addPropertyChangeListener((PropertyChangeListener)new ManagerChangeListener());
            object = new JLabel(NbBundle.getMessage(CategoryView.class, (String)"MSG_LOADING"));
            ((JLabel)object).setHorizontalTextPosition(0);
            ((JLabel)object).setVerticalTextPosition(0);
            J2MECustomizer.this.customizerPanel.add((Component)object, "Center");
        }

        public ExplorerManager getExplorerManager() {
            return this.manager;
        }

        public BeanTreeView getBeanTreeView() {
            return this.btv;
        }

        public void addNotify() {
            super.addNotify();
            this.btv.expandAll();
        }

        private void selectFirstNode() {
            Node[] nodeArray;
            Children children = this.manager.getRootContext().getChildren();
            if (children != null && (nodeArray = children.getNodes()) != null && nodeArray.length > 1) {
                try {
                    this.manager.setSelectedNodes(new Node[]{nodeArray[1]});
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        public void updateCustomizerPanel() {
            Object object = J2MECustomizer.this.configurationCombo.getSelectedItem();
            String string = J2MECustomizer.this.configurationCombo.getSelectedIndex() == 0 || object == null || !(object instanceof ProjectConfiguration) ? null : ((ProjectConfiguration)object).getDisplayName();
            Node[] nodeArray = this.manager.getSelectedNodes();
            if (nodeArray == null || nodeArray.length <= 0) {
                return;
            }
            Node node = nodeArray[0];
            J2MECustomizer.this.customizerPanel.removeAll();
            DataFolder dataFolder = (DataFolder)node.getCookie(DataFolder.class);
            JComponent jComponent = (JComponent)dataFolder.getPrimaryFile().getAttribute("customizerPanelClass");
            if (jComponent != null) {
                J2MECustomizer.this.updateHelpCtx(new HelpCtx(jComponent.getClass()));
                jComponent.setBorder(BorderFactory.createEmptyBorder(5, 8, 8, 8));
                J2MECustomizer.this.customizerPanel.add((Component)jComponent, "Center");
                J2MECustomizer.this.configurationCombo.setEnabled(jComponent instanceof VisualPropertyGroup);
                if (jComponent instanceof CustomizerPanel) {
                    ((CustomizerPanel)((Object)jComponent)).initValues(J2MECustomizer.this.props, string);
                }
                if (jComponent instanceof ComposedCustomizerPanel) {
                    ((ComposedCustomizerPanel)((Object)jComponent)).setHelpContextCallback(J2MECustomizer.this);
                }
            } else {
                DataObject[] dataObjectArray = dataFolder.getChildren();
                JTabbedPane jTabbedPane = new JTabbedPane();
                jTabbedPane.setBorder(BorderFactory.createEmptyBorder(5, 8, 8, 8));
                boolean bl = false;
                for (int i = 0; i < dataObjectArray.length; ++i) {
                    String string2;
                    FileObject fileObject = dataObjectArray[i].getPrimaryFile();
                    String string3 = (String)fileObject.getAttribute("triggerPropertyName");
                    String string4 = string3 == null ? null : (String)fileObject.getAttribute("triggerPropertyValue");
                    bl |= string4 != null;
                    String string5 = string2 = string4 == null ? null : this.evaluatePropertyRaw(string, string3);
                    if (string4 != null && !string4.equalsIgnoreCase(string2) || (jComponent = (JComponent)fileObject.getAttribute("customizerPanelClass")) == null) continue;
                    jComponent.setBorder(BorderFactory.createEmptyBorder(5, 8, 8, 8));
                    jTabbedPane.add(dataObjectArray[i].getNodeDelegate().getDisplayName(), jComponent);
                    bl |= jComponent instanceof VisualPropertyGroup;
                    if (!(jComponent instanceof CustomizerPanel)) continue;
                    ((CustomizerPanel)((Object)jComponent)).initValues(J2MECustomizer.this.props, string);
                }
                J2MECustomizer.this.configurationCombo.setEnabled(bl);
                if (jTabbedPane.getComponentCount() > 0) {
                    J2MECustomizer.this.updateHelpCtx(new HelpCtx(jTabbedPane.getComponent(0).getClass()));
                    J2MECustomizer.this.customizerPanel.add(jTabbedPane.getComponentCount() == 1 ? jTabbedPane.getComponent(0) : jTabbedPane, "Center");
                    jTabbedPane.addChangeListener(this);
                    Integer n = this.tabSelections.get(node);
                    if (n != null && n < jTabbedPane.getTabCount()) {
                        jTabbedPane.setSelectedIndex(n);
                    }
                } else {
                    J2MECustomizer.this.updateHelpCtx(null);
                }
            }
            J2MECustomizer.this.customizerPanel.validate();
            J2MECustomizer.this.customizerPanel.repaint();
        }

        private String evaluatePropertyRaw(String string, String string2) {
            String string3;
            if (string != null && (string3 = J2MECustomizer.this.props.getPropertyRawValue(VisualPropertySupport.prefixPropertyName(string, string2))) != null) {
                return string3;
            }
            return J2MECustomizer.this.props.getPropertyRawValue(string2);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
            Node[] nodeArray = this.manager.getSelectedNodes();
            if (nodeArray != null && nodeArray.length == 1) {
                this.tabSelections.put(nodeArray[0], jTabbedPane.getSelectedIndex());
            }
            J2MECustomizer.this.updateHelpCtx(new HelpCtx(jTabbedPane.getSelectedComponent().getClass()));
        }

        private class ManagerChangeListener
        implements PropertyChangeListener {
            private ManagerChangeListener() {
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getSource() != CategoryView.this.manager) {
                    return;
                }
                if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
                    CategoryView.this.updateCustomizerPanel();
                }
            }
        }

        private final class NL
        extends NodeAdapter
        implements Runnable {
            private final Node listenedTo;
            private boolean done;

            NL(Node node) {
                this.listenedTo = node;
            }

            private void post() {
                this.done = false;
                RequestProcessor.getDefault().post((Runnable)this, 150);
            }

            private void change() {
                this.done = true;
                this.listenedTo.removeNodeListener((NodeListener)this);
                CategoryView.this.selectFirstNode();
            }

            public void childrenAdded(NodeMemberEvent nodeMemberEvent) {
                this.change();
            }

            public void run() {
                if (!this.done) {
                    if (!J2MECustomizer.this.isShowing()) {
                        return;
                    }
                    if (CategoryView.this.manager.getRootContext().getChildren().getNodesCount() > 1) {
                        this.change();
                    } else if (J2MECustomizer.this.isShowing()) {
                        this.post();
                    }
                }
            }
        }
    }
}

