/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components.table;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import org.netbeans.lib.profiler.ui.components.table.CustomBarCellRenderer;

public class DiffBarCellRenderer
extends CustomBarCellRenderer {
    public static final Color BAR_FOREGROUND2_COLOR = new Color(41, 195, 41);

    public DiffBarCellRenderer(long l, long l2) {
        super(l, l2);
    }

    public void paintComponent(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        Insets insets = this.getInsets();
        int n = this.getWidth() - insets.right - insets.left;
        int n2 = insets.left + n / 2;
        int n3 = (int)Math.ceil(Math.abs(this.relValue) * (double)n / 2.0);
        if (this.relValue > 0.0) {
            graphics.setColor(BAR_FOREGROUND_COLOR);
            graphics.fillRect(n2, insets.top, n3, this.getHeight() - insets.bottom - insets.top);
        } else if (this.relValue < 0.0) {
            graphics.setColor(BAR_FOREGROUND2_COLOR);
            graphics.fillRect(n2 - n3, insets.top, n3, this.getHeight() - insets.bottom - insets.top);
        }
    }

    protected double calculateViewValue(long l) {
        long l2 = Math.max(Math.abs(this.min), this.max);
        return (double)l / (double)l2;
    }

    protected double calculateViewValue(double d) {
        long l = Math.max(Math.abs(this.min), this.max);
        return d / (double)l;
    }
}

