/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.debugger.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.Properties;
import org.netbeans.modules.ruby.debugger.breakpoints.RubyBreakpoint;
import org.netbeans.modules.ruby.debugger.breakpoints.RubyBreakpointManager;

public final class PersistenceManager
extends DebuggerManagerAdapter {
    private static final Logger LOGGER = Logger.getLogger(PersistenceManager.class.getName());
    private static final String RUBY_PROPERTY = "ruby";
    private static final String DEBUGGER_PROPERTY = "debugger";

    public Breakpoint[] initBreakpoints() {
        Properties properties = this.loadBreakpointProperties();
        Breakpoint[] breakpointArray = (Breakpoint[])properties.getArray(RUBY_PROPERTY, (Object[])new Breakpoint[0]);
        ArrayList<Breakpoint> arrayList = new ArrayList<Breakpoint>();
        for (Breakpoint breakpoint : breakpointArray) {
            if (breakpoint != null) {
                breakpoint.addPropertyChangeListener((PropertyChangeListener)((Object)this));
                arrayList.add(breakpoint);
                continue;
            }
            LOGGER.warning("null stored in the array obtained from \"ruby\" property");
        }
        return arrayList.toArray(new Breakpoint[arrayList.size()]);
    }

    public String[] getProperties() {
        return new String[]{"breakpointsInit", "breakpoints"};
    }

    public void breakpointAdded(Breakpoint breakpoint) {
        if (breakpoint instanceof RubyBreakpoint) {
            this.storeBreakpoints();
            breakpoint.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        }
    }

    public void breakpointRemoved(Breakpoint breakpoint) {
        if (breakpoint instanceof RubyBreakpoint) {
            RubyBreakpointManager.removeBreakpoint((RubyBreakpoint)breakpoint);
            this.storeBreakpoints();
            breakpoint.removePropertyChangeListener((PropertyChangeListener)((Object)this));
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() instanceof RubyBreakpoint) {
            this.storeBreakpoints();
        }
    }

    private void storeBreakpoints() {
        this.loadBreakpointProperties().setArray(RUBY_PROPERTY, (Object[])RubyBreakpointManager.getBreakpoints());
    }

    private Properties loadBreakpointProperties() {
        return Properties.getDefault().getProperties(DEBUGGER_PROPERTY).getProperties("breakpoints");
    }
}

