/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.freeform;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.ant.freeform.FreeformProject;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.queries.SharabilityQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FreeformSharabilityQuery
implements SharabilityQueryImplementation,
AntProjectListener {
    private String nbproject;
    private String nbprojectPrivate;
    private volatile Set<File> exported;
    private final FreeformProject project;

    public FreeformSharabilityQuery(FreeformProject freeformProject) {
        assert (freeformProject != null);
        this.project = freeformProject;
        AntProjectHelper antProjectHelper = freeformProject.helper();
        this.nbproject = antProjectHelper.resolveFile("nbproject").getAbsolutePath();
        this.nbprojectPrivate = antProjectHelper.resolveFile("nbproject/private").getAbsolutePath();
        antProjectHelper.addAntProjectListener((AntProjectListener)this);
    }

    public int getSharability(File file) {
        String string = file.getAbsolutePath();
        if (string.equals(this.nbproject)) {
            return 3;
        }
        if (string.startsWith(this.nbproject)) {
            return string.startsWith(this.nbprojectPrivate) ? 2 : 1;
        }
        if (this.isExported(file)) {
            return 2;
        }
        return 0;
    }

    public void configurationXmlChanged(AntProjectEvent antProjectEvent) {
        this.exported = null;
    }

    public void propertiesChanged(AntProjectEvent antProjectEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isExported(File file) {
        Set<File> set = this.exported;
        if (set == null) {
            set = new HashSet<File>();
            final HashSet<File> hashSet = set;
            ProjectManager.mutex().readAccess(new Runnable(){

                public void run() {
                    Element element = FreeformSharabilityQuery.this.project.getPrimaryConfigurationData();
                    NodeList nodeList = element.getElementsByTagNameNS("http://www.netbeans.org/ns/freeform-project/2", "export");
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        File file;
                        String string;
                        Element element2 = (Element)nodeList.item(i);
                        Element element3 = Util.findElement(element2, "location", "http://www.netbeans.org/ns/freeform-project/2");
                        if (element3 == null || (string = Util.findText(element3)) == null || (file = Util.resolveFile(FreeformSharabilityQuery.this.project.evaluator(), FileUtil.toFile((FileObject)FreeformSharabilityQuery.this.project.getProjectDirectory()), string)) == null) continue;
                        hashSet.add(file);
                    }
                }
            });
            FreeformSharabilityQuery freeformSharabilityQuery = this;
            synchronized (freeformSharabilityQuery) {
                if (this.exported == null) {
                    this.exported = set;
                }
            }
        }
        return set.contains(file);
    }
}

