/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.freeform;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ProjectGenerator;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreeformProjectGenerator {
    private static final String[] rootElementsOrder = new String[]{"name", "properties", "folders", "ide-actions", "export", "view", "subprojects"};
    private static final String[] viewElementsOrder = new String[]{"items", "context-menu"};
    private static final String[] viewItemElementsOrder = new String[]{"source-folder", "source-file"};
    private static final String[] contextMenuElementsOrder = new String[]{"ide-action", "separator", "action"};

    private FreeformProjectGenerator() {
    }

    public static AntProjectHelper createProject(File file, File file2, String string, File file3) throws IOException {
        FileObject fileObject = FreeformProjectGenerator.createProjectDir(file2);
        FileObject fileObject2 = FileUtil.toFileObject((File)file);
        AntProjectHelper antProjectHelper = FreeformProjectGenerator.createProject(fileObject2, fileObject, string, file3);
        Project project = ProjectManager.getDefault().findProject(fileObject);
        ProjectManager.getDefault().saveProject(project);
        return antProjectHelper;
    }

    private static AntProjectHelper createProject(final FileObject fileObject, final FileObject fileObject2, final String string, final File file) throws IOException {
        final AntProjectHelper[] antProjectHelperArray = new AntProjectHelper[1];
        final IOException[] iOExceptionArray = new IOException[1];
        ProjectManager.mutex().writeAccess(new Runnable(){

            public void run() {
                Object object;
                Object object2;
                Project project;
                try {
                    antProjectHelperArray[0] = ProjectGenerator.createProject((FileObject)fileObject2, (String)"org.netbeans.modules.ant.freeform");
                    project = ProjectManager.getDefault().findProject(fileObject2);
                }
                catch (IOException iOException) {
                    iOExceptionArray[0] = iOException;
                    return;
                }
                AuxiliaryConfiguration auxiliaryConfiguration = (AuxiliaryConfiguration)project.getLookup().lookup(AuxiliaryConfiguration.class);
                assert (auxiliaryConfiguration != null);
                Element element = Util.getPrimaryConfigurationData(antProjectHelperArray[0]);
                Document document = element.getOwnerDocument();
                Comment comment = document.createComment(" " + NbBundle.getMessage(FreeformProjectGenerator.class, (String)"LBL_Manual_Editing_Warning") + " ");
                element.appendChild(comment);
                Element element2 = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "name");
                element2.appendChild(document.createTextNode(string));
                element.appendChild(element2);
                Element element3 = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "properties");
                File file3 = FileUtil.toFile((FileObject)fileObject);
                File file2 = FileUtil.toFile((FileObject)fileObject2);
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                if (!fileObject.equals(fileObject2)) {
                    object2 = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "property");
                    object2.setAttribute("name", "project.dir");
                    object = CollocationQuery.areCollocated((File)file2, (File)file3) ? PropertyUtils.relativizeFile((File)file2, (File)file3) : file3.getAbsolutePath();
                    object2.appendChild(document.createTextNode((String)object));
                    element3.appendChild((Node)object2);
                    hashMap.put("project.dir", object);
                }
                object2 = "build.xml";
                if (file != null) {
                    object = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "property");
                    object.setAttribute("name", "ant.script");
                    object2 = Util.relativizeLocation(file3, file2, file);
                    object.appendChild(document.createTextNode((String)object2));
                    hashMap.put("ant.script", object2);
                    object2 = "${ant.script}";
                    element3.appendChild((Node)object);
                }
                element.appendChild(element3);
                Util.putPrimaryConfigurationData(antProjectHelperArray[0], element);
                FreeformProjectGenerator.putBuildXMLSourceFile(antProjectHelperArray[0], (String)object2);
            }
        });
        if (iOExceptionArray[0] != null) {
            throw iOExceptionArray[0];
        }
        return antProjectHelperArray[0];
    }

    private static FileObject createProjectDir(File file) throws IOException {
        if (!file.exists()) {
            FreeformProjectGenerator.refreshFileSystem(file);
            file.mkdirs();
            FreeformProjectGenerator.refreshFileSystem(file);
        }
        FileObject fileObject = FileUtil.toFileObject((File)file);
        assert (fileObject != null) : "No such dir on disk: " + file;
        assert (fileObject.isFolder()) : "Not really a dir: " + file;
        return fileObject;
    }

    private static void refreshFileSystem(File file) throws FileStateInvalidException {
        File file2 = file;
        while (file2.getParentFile() != null) {
            file2 = file2.getParentFile();
        }
        FileObject fileObject = FileUtil.toFileObject((File)file2);
        assert (fileObject != null) : "At least disk roots must be mounted! " + file2;
        fileObject.getFileSystem().refresh(false);
    }

    public static List<TargetMapping> getTargetMappings(AntProjectHelper antProjectHelper) {
        ArrayList<TargetMapping> arrayList = new ArrayList<TargetMapping>();
        Element element = Util.getPrimaryConfigurationData(antProjectHelper);
        Element element2 = Util.findElement(element, "ide-actions", "http://www.netbeans.org/ns/freeform-project/2");
        if (element2 == null) {
            return arrayList;
        }
        for (Element element3 : Util.findSubElements(element2)) {
            TargetMapping targetMapping = new TargetMapping();
            targetMapping.name = element3.getAttribute("name");
            ArrayList<String> arrayList2 = new ArrayList<String>();
            EditableProperties editableProperties = new EditableProperties(false);
            for (Element element4 : Util.findSubElements(element3)) {
                if (element4.getLocalName().equals("target")) {
                    arrayList2.add(Util.findText(element4));
                    continue;
                }
                if (element4.getLocalName().equals("script")) {
                    targetMapping.script = Util.findText(element4);
                    continue;
                }
                if (element4.getLocalName().equals("context")) {
                    TargetMapping.Context context = new TargetMapping.Context();
                    for (Element element5 : Util.findSubElements(element4)) {
                        Element element6;
                        if (element5.getLocalName().equals("property")) {
                            context.property = Util.findText(element5);
                            continue;
                        }
                        if (element5.getLocalName().equals("format")) {
                            context.format = Util.findText(element5);
                            continue;
                        }
                        if (element5.getLocalName().equals("folder")) {
                            context.folder = Util.findText(element5);
                            continue;
                        }
                        if (element5.getLocalName().equals("pattern")) {
                            context.pattern = Util.findText(element5);
                            continue;
                        }
                        if (!element5.getLocalName().equals("arity") || (element6 = Util.findElement(element5, "separated-files", "http://www.netbeans.org/ns/freeform-project/2")) == null) continue;
                        context.separator = Util.findText(element6);
                    }
                    targetMapping.context = context;
                }
                if (!element4.getLocalName().equals("property")) continue;
                FreeformProjectGenerator.readProperty(element4, editableProperties);
            }
            targetMapping.targets = arrayList2;
            if (editableProperties.keySet().size() > 0) {
                targetMapping.properties = editableProperties;
            }
            arrayList.add(targetMapping);
        }
        return arrayList;
    }

    private static void readProperty(Element element, EditableProperties editableProperties) {
        String string = element.getAttribute("name");
        String string2 = Util.findText(element);
        editableProperties.setProperty(string, string2);
    }

    public static void putTargetMappings(AntProjectHelper antProjectHelper, List<TargetMapping> list) {
        Element element = Util.getPrimaryConfigurationData(antProjectHelper);
        Document document = element.getOwnerDocument();
        Element element2 = Util.findElement(element, "ide-actions", "http://www.netbeans.org/ns/freeform-project/2");
        if (element2 != null) {
            element.removeChild(element2);
        }
        element2 = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "ide-actions");
        for (TargetMapping targetMapping : list) {
            Element element3;
            Object object;
            Element element4 = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "action");
            assert (targetMapping.name != null && targetMapping.name.length() > 0);
            element4.setAttribute("name", targetMapping.name);
            if (targetMapping.script != null) {
                object = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "script");
                object.appendChild(document.createTextNode(targetMapping.script));
                element4.appendChild((Node)object);
            }
            if (targetMapping.targets != null) {
                for (String string : targetMapping.targets) {
                    element3 = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "target");
                    element3.appendChild(document.createTextNode(string));
                    element4.appendChild(element3);
                }
            }
            if (targetMapping.properties != null) {
                FreeformProjectGenerator.writeProperties(targetMapping.properties, document, element4);
            }
            if (targetMapping.context != null) {
                Element element5;
                object = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "context");
                TargetMapping.Context context = targetMapping.context;
                assert (context.property != null);
                element3 = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "property");
                element3.appendChild(document.createTextNode(context.property));
                object.appendChild(element3);
                assert (context.folder != null);
                Element element6 = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "folder");
                element6.appendChild(document.createTextNode(context.folder));
                object.appendChild(element6);
                if (context.pattern != null) {
                    element5 = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "pattern");
                    element5.appendChild(document.createTextNode(context.pattern));
                    object.appendChild(element5);
                }
                assert (context.format != null);
                element5 = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "format");
                element5.appendChild(document.createTextNode(context.format));
                object.appendChild(element5);
                Element element7 = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "arity");
                if (context.separator != null) {
                    Element element8 = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "separated-files");
                    element8.appendChild(document.createTextNode(context.separator));
                    element7.appendChild(element8);
                } else {
                    element7.appendChild(document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "one-file-only"));
                }
                object.appendChild(element7);
                element4.appendChild((Node)object);
            }
            element2.appendChild(element4);
        }
        Util.appendChildElement(element, element2, rootElementsOrder);
        Util.putPrimaryConfigurationData(antProjectHelper, element);
    }

    private static void writeProperties(EditableProperties editableProperties, Document document, Element element) {
        for (Map.Entry entry : editableProperties.entrySet()) {
            Element element2 = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "property");
            element2.setAttribute("name", (String)entry.getKey());
            element2.appendChild(document.createTextNode((String)entry.getValue()));
            element.appendChild(element2);
        }
    }

    public static void putContextMenuAction(AntProjectHelper antProjectHelper, List<TargetMapping> list) {
        Element element;
        Element element2 = Util.getPrimaryConfigurationData(antProjectHelper);
        Document document = element2.getOwnerDocument();
        Element element3 = Util.findElement(element2, "view", "http://www.netbeans.org/ns/freeform-project/2");
        if (element3 == null) {
            element3 = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "view");
            Util.appendChildElement(element2, element3, rootElementsOrder);
        }
        if ((element = Util.findElement(element3, "context-menu", "http://www.netbeans.org/ns/freeform-project/2")) == null) {
            element = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "context-menu");
            Util.appendChildElement(element3, element, viewElementsOrder);
        }
        for (Element object : Util.findSubElements(element)) {
            if (!object.getLocalName().equals("ide-action")) continue;
            element.removeChild(object);
        }
        for (TargetMapping targetMapping : FreeformProjectGenerator.sortMappings(list)) {
            if (targetMapping.context != null) continue;
            Element element4 = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "ide-action");
            element4.setAttribute("name", targetMapping.name);
            Util.appendChildElement(element, element4, contextMenuElementsOrder);
        }
        Util.putPrimaryConfigurationData(antProjectHelper, element2);
    }

    public static List<CustomTarget> getCustomContextMenuActions(AntProjectHelper antProjectHelper) {
        ArrayList<CustomTarget> arrayList = new ArrayList<CustomTarget>();
        Element element = Util.getPrimaryConfigurationData(antProjectHelper);
        Element element2 = Util.findElement(element, "view", "http://www.netbeans.org/ns/freeform-project/2");
        if (element2 == null) {
            return arrayList;
        }
        Element element3 = Util.findElement(element2, "context-menu", "http://www.netbeans.org/ns/freeform-project/2");
        if (element3 == null) {
            return arrayList;
        }
        for (Element element4 : Util.findSubElements(element3)) {
            if (!element4.getLocalName().equals("action")) continue;
            CustomTarget customTarget = new CustomTarget();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            EditableProperties editableProperties = new EditableProperties(false);
            for (Element element5 : Util.findSubElements(element4)) {
                if (element5.getLocalName().equals("target")) {
                    arrayList2.add(Util.findText(element5));
                    continue;
                }
                if (element5.getLocalName().equals("script")) {
                    customTarget.script = Util.findText(element5);
                    continue;
                }
                if (element5.getLocalName().equals("label")) {
                    customTarget.label = Util.findText(element5);
                    continue;
                }
                if (!element5.getLocalName().equals("property")) continue;
                FreeformProjectGenerator.readProperty(element5, editableProperties);
            }
            customTarget.targets = arrayList2;
            if (editableProperties.keySet().size() > 0) {
                customTarget.properties = editableProperties;
            }
            arrayList.add(customTarget);
        }
        return arrayList;
    }

    public static void putCustomContextMenuActions(AntProjectHelper antProjectHelper, List<CustomTarget> list) {
        Element element;
        Element element2 = Util.getPrimaryConfigurationData(antProjectHelper);
        Document document = element2.getOwnerDocument();
        Element element3 = Util.findElement(element2, "view", "http://www.netbeans.org/ns/freeform-project/2");
        if (element3 == null) {
            element3 = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "view");
            Util.appendChildElement(element2, element3, rootElementsOrder);
        }
        if ((element = Util.findElement(element3, "context-menu", "http://www.netbeans.org/ns/freeform-project/2")) == null) {
            element = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "context-menu");
            Util.appendChildElement(element3, element, viewElementsOrder);
        }
        for (Element object : Util.findSubElements(element)) {
            if (!object.getLocalName().equals("action")) continue;
            element.removeChild(object);
        }
        for (CustomTarget customTarget : list) {
            Element element4;
            Element element5 = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "action");
            if (customTarget.script != null) {
                element4 = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "script");
                element4.appendChild(document.createTextNode(customTarget.script));
                element5.appendChild(element4);
            }
            element4 = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "label");
            element4.appendChild(document.createTextNode(customTarget.label));
            element5.appendChild(element4);
            if (customTarget.targets != null) {
                for (String string : customTarget.targets) {
                    Element element6 = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "target");
                    element6.appendChild(document.createTextNode(string));
                    element5.appendChild(element6);
                }
            }
            if (customTarget.properties != null) {
                FreeformProjectGenerator.writeProperties(customTarget.properties, document, element5);
            }
            Util.appendChildElement(element, element5, contextMenuElementsOrder);
        }
        Util.putPrimaryConfigurationData(antProjectHelper, element2);
    }

    private static void putBuildXMLSourceFile(AntProjectHelper antProjectHelper, String string) {
        Element element;
        Element element2 = Util.getPrimaryConfigurationData(antProjectHelper);
        Document document = element2.getOwnerDocument();
        Element element3 = Util.findElement(element2, "view", "http://www.netbeans.org/ns/freeform-project/2");
        if (element3 == null) {
            element3 = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "view");
            Util.appendChildElement(element2, element3, rootElementsOrder);
        }
        if ((element = Util.findElement(element3, "items", "http://www.netbeans.org/ns/freeform-project/2")) == null) {
            element = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "items");
            Util.appendChildElement(element3, element, viewElementsOrder);
        }
        Element element4 = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "source-file");
        Element element5 = document.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "location");
        element5.appendChild(document.createTextNode(string));
        element4.appendChild(element5);
        Util.appendChildElement(element, element4, viewItemElementsOrder);
        Util.putPrimaryConfigurationData(antProjectHelper, element2);
    }

    public static FileObject getAntScript(AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator) {
        String string = propertyEvaluator.getProperty("ant.script");
        if (string != null) {
            File file = antProjectHelper.resolveFile(string);
            if (!file.exists()) {
                return null;
            }
            FileObject fileObject = FileUtil.toFileObject((File)file);
            return fileObject;
        }
        FileObject fileObject = antProjectHelper.getProjectDirectory().getFileObject("build.xml");
        return fileObject;
    }

    private static List<TargetMapping> sortMappings(List<TargetMapping> list) {
        ArrayList<TargetMapping> arrayList = new ArrayList<TargetMapping>(list);
        String[] stringArray = new String[]{"build", "rebuild", "clean", "javadoc", "run", "deploy", "redeploy", "test"};
        ArrayList<TargetMapping> arrayList2 = new ArrayList<TargetMapping>(arrayList.size());
        block0: for (String string : stringArray) {
            for (TargetMapping targetMapping : arrayList) {
                if (!string.equals(targetMapping.name)) continue;
                arrayList2.add(targetMapping);
                arrayList.remove(targetMapping);
                continue block0;
            }
        }
        for (TargetMapping targetMapping : arrayList) {
            arrayList2.add(targetMapping);
        }
        return arrayList2;
    }

    public static final class TargetMapping {
        public String script;
        public List<String> targets;
        public String name;
        public EditableProperties properties;
        public Context context;

        public static final class Context {
            public String property;
            public String format;
            public String folder;
            public String pattern;
            public String separator;
        }
    }

    public static final class CustomTarget {
        public List<String> targets;
        public String label;
        public String script;
        public EditableProperties properties;
    }
}

