/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer.api;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.modules.maven.indexer.api.NBArtifactInfo;
import org.netbeans.modules.maven.indexer.api.NBGroupInfo;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.QueryField;
import org.netbeans.modules.maven.indexer.api.RepositoryIndexer;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.indexer.api.RepositoryUtil;
import org.netbeans.modules.maven.indexer.spi.ArchetypeQueries;
import org.netbeans.modules.maven.indexer.spi.BaseQueries;
import org.netbeans.modules.maven.indexer.spi.ChecksumQueries;
import org.netbeans.modules.maven.indexer.spi.ClassesQuery;
import org.netbeans.modules.maven.indexer.spi.ContextLoadedQuery;
import org.netbeans.modules.maven.indexer.spi.DependencyInfoQueries;
import org.netbeans.modules.maven.indexer.spi.GenericFindQuery;
import org.netbeans.modules.maven.indexer.spi.RepositoryIndexerImplementation;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RepositoryQueries {
    public static Set<String> getGroups(RepositoryInfo ... repositoryInfoArray) {
        Collection<List<RepositoryInfo>> collection = RepositoryQueries.splitReposByType(repositoryInfoArray);
        TreeSet<String> treeSet = new TreeSet<String>();
        for (List<RepositoryInfo> list : collection) {
            RepositoryIndexerImplementation repositoryIndexerImplementation = RepositoryIndexer.findImplementation(list.get(0));
            if (repositoryIndexerImplementation == null) continue;
            BaseQueries baseQueries = (BaseQueries)repositoryIndexerImplementation.getCapabilityLookup().lookup(BaseQueries.class);
            assert (baseQueries != null) : "All RepositoryIndexerImplementation need to define BaseQueries:" + repositoryIndexerImplementation.getType() + " : " + repositoryIndexerImplementation.getClass();
            treeSet.addAll(baseQueries.getGroups(list));
        }
        return treeSet;
    }

    public static Set<String> filterGroupIds(String string, RepositoryInfo ... repositoryInfoArray) {
        Collection<List<RepositoryInfo>> collection = RepositoryQueries.splitReposByType(repositoryInfoArray);
        TreeSet<String> treeSet = new TreeSet<String>();
        for (List<RepositoryInfo> list : collection) {
            RepositoryIndexerImplementation repositoryIndexerImplementation = RepositoryIndexer.findImplementation(list.get(0));
            if (repositoryIndexerImplementation == null) continue;
            BaseQueries baseQueries = (BaseQueries)repositoryIndexerImplementation.getCapabilityLookup().lookup(BaseQueries.class);
            assert (baseQueries != null) : "All RepositoryIndexerImplementation need to define BaseQueries:" + repositoryIndexerImplementation.getType() + " : " + repositoryIndexerImplementation.getClass();
            treeSet.addAll(baseQueries.filterGroupIds(string, list));
        }
        return treeSet;
    }

    public static List<NBVersionInfo> getRecords(String string, String string2, String string3, RepositoryInfo ... repositoryInfoArray) {
        Collection<List<RepositoryInfo>> collection = RepositoryQueries.splitReposByType(repositoryInfoArray);
        ArrayList<NBVersionInfo> arrayList = new ArrayList<NBVersionInfo>();
        for (List<RepositoryInfo> list : collection) {
            RepositoryIndexerImplementation repositoryIndexerImplementation = RepositoryIndexer.findImplementation(list.get(0));
            if (repositoryIndexerImplementation == null) continue;
            BaseQueries baseQueries = (BaseQueries)repositoryIndexerImplementation.getCapabilityLookup().lookup(BaseQueries.class);
            assert (baseQueries != null) : "All RepositoryIndexerImplementation need to define BaseQueries:" + repositoryIndexerImplementation.getType() + " : " + repositoryIndexerImplementation.getClass();
            arrayList.addAll(baseQueries.getRecords(string, string2, string3, list));
        }
        return arrayList;
    }

    public static Set<String> getArtifacts(String string, RepositoryInfo ... repositoryInfoArray) {
        Collection<List<RepositoryInfo>> collection = RepositoryQueries.splitReposByType(repositoryInfoArray);
        TreeSet<String> treeSet = new TreeSet<String>();
        for (List<RepositoryInfo> list : collection) {
            RepositoryIndexerImplementation repositoryIndexerImplementation = RepositoryIndexer.findImplementation(list.get(0));
            if (repositoryIndexerImplementation == null) continue;
            BaseQueries baseQueries = (BaseQueries)repositoryIndexerImplementation.getCapabilityLookup().lookup(BaseQueries.class);
            assert (baseQueries != null) : "All RepositoryIndexerImplementation need to define BaseQueries:" + repositoryIndexerImplementation.getType() + " : " + repositoryIndexerImplementation.getClass();
            treeSet.addAll(baseQueries.getArtifacts(string, list));
        }
        return treeSet;
    }

    public static List<NBVersionInfo> getVersions(String string, String string2, RepositoryInfo ... repositoryInfoArray) {
        Collection<List<RepositoryInfo>> collection = RepositoryQueries.splitReposByType(repositoryInfoArray);
        ArrayList<NBVersionInfo> arrayList = new ArrayList<NBVersionInfo>();
        for (List<RepositoryInfo> list : collection) {
            RepositoryIndexerImplementation repositoryIndexerImplementation = RepositoryIndexer.findImplementation(list.get(0));
            if (repositoryIndexerImplementation == null) continue;
            BaseQueries baseQueries = (BaseQueries)repositoryIndexerImplementation.getCapabilityLookup().lookup(BaseQueries.class);
            assert (baseQueries != null) : "All RepositoryIndexerImplementation need to define BaseQueries:" + repositoryIndexerImplementation.getType() + " : " + repositoryIndexerImplementation.getClass();
            arrayList.addAll(baseQueries.getVersions(string, string2, list));
        }
        return arrayList;
    }

    public static List<NBGroupInfo> findDependencyUsage(String string, String string2, String string3, RepositoryInfo ... repositoryInfoArray) {
        HashMap<String, NBGroupInfo> hashMap = new HashMap<String, NBGroupInfo>();
        HashMap<String, NBArtifactInfo> hashMap2 = new HashMap<String, NBArtifactInfo>();
        ArrayList<NBGroupInfo> arrayList = new ArrayList<NBGroupInfo>();
        Collection<List<RepositoryInfo>> collection = RepositoryQueries.splitReposByType(repositoryInfoArray);
        for (List<RepositoryInfo> list : collection) {
            DependencyInfoQueries dependencyInfoQueries;
            RepositoryIndexerImplementation repositoryIndexerImplementation = RepositoryIndexer.findImplementation(list.get(0));
            if (repositoryIndexerImplementation == null || (dependencyInfoQueries = (DependencyInfoQueries)repositoryIndexerImplementation.getCapabilityLookup().lookup(DependencyInfoQueries.class)) == null) continue;
            RepositoryQueries.convertToNBGroupInfo(dependencyInfoQueries.findDependencyUsage(string, string2, string3, list), hashMap, hashMap2, arrayList);
        }
        return arrayList;
    }

    private static void convertToNBGroupInfo(Collection<NBVersionInfo> collection, Map<String, NBGroupInfo> map, Map<String, NBArtifactInfo> map2, List<NBGroupInfo> list) {
        for (NBVersionInfo nBVersionInfo : collection) {
            NBArtifactInfo nBArtifactInfo;
            String string = nBVersionInfo.getGroupId();
            String string2 = nBVersionInfo.getArtifactId();
            NBGroupInfo nBGroupInfo = map.get(string);
            if (nBGroupInfo == null) {
                nBGroupInfo = new NBGroupInfo(string);
                list.add(nBGroupInfo);
                map.put(string, nBGroupInfo);
            }
            if ((nBArtifactInfo = map2.get(string2)) == null) {
                nBArtifactInfo = new NBArtifactInfo(string2);
                nBGroupInfo.addArtifactInfo(nBArtifactInfo);
                map2.put(string2, nBArtifactInfo);
            }
            nBArtifactInfo.addVersionInfo(nBVersionInfo);
        }
    }

    public static List<NBVersionInfo> findByMD5(File file, RepositoryInfo ... repositoryInfoArray) {
        ArrayList<NBVersionInfo> arrayList = new ArrayList<NBVersionInfo>();
        try {
            String string = RepositoryUtil.calculateMD5Checksum(file);
            return RepositoryQueries.findByMD5(string, repositoryInfoArray);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return arrayList;
        }
    }

    public static List<NBVersionInfo> findByMD5(String string, RepositoryInfo ... repositoryInfoArray) {
        Collection<List<RepositoryInfo>> collection = RepositoryQueries.splitReposByType(repositoryInfoArray);
        ArrayList<NBVersionInfo> arrayList = new ArrayList<NBVersionInfo>();
        for (List<RepositoryInfo> list : collection) {
            ChecksumQueries checksumQueries;
            RepositoryIndexerImplementation repositoryIndexerImplementation = RepositoryIndexer.findImplementation(list.get(0));
            if (repositoryIndexerImplementation == null || (checksumQueries = (ChecksumQueries)repositoryIndexerImplementation.getCapabilityLookup().lookup(ChecksumQueries.class)) == null) continue;
            arrayList.addAll(checksumQueries.findByMD5(string, list));
        }
        return arrayList;
    }

    public static List<NBVersionInfo> findBySHA1(File file, RepositoryInfo ... repositoryInfoArray) {
        ArrayList<NBVersionInfo> arrayList = new ArrayList<NBVersionInfo>();
        try {
            String string = RepositoryUtil.calculateSHA1Checksum(file);
            return RepositoryQueries.findBySHA1(string, repositoryInfoArray);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return arrayList;
        }
    }

    public static List<NBVersionInfo> findBySHA1(String string, RepositoryInfo ... repositoryInfoArray) {
        Collection<List<RepositoryInfo>> collection = RepositoryQueries.splitReposByType(repositoryInfoArray);
        ArrayList<NBVersionInfo> arrayList = new ArrayList<NBVersionInfo>();
        for (List<RepositoryInfo> list : collection) {
            ChecksumQueries checksumQueries;
            RepositoryIndexerImplementation repositoryIndexerImplementation = RepositoryIndexer.findImplementation(list.get(0));
            if (repositoryIndexerImplementation == null || (checksumQueries = (ChecksumQueries)repositoryIndexerImplementation.getCapabilityLookup().lookup(ChecksumQueries.class)) == null) continue;
            arrayList.addAll(checksumQueries.findBySHA1(string, list));
        }
        return arrayList;
    }

    public static List<NBVersionInfo> findVersionsByClass(String string, RepositoryInfo ... repositoryInfoArray) {
        Collection<List<RepositoryInfo>> collection = RepositoryQueries.splitReposByType(repositoryInfoArray);
        ArrayList<NBVersionInfo> arrayList = new ArrayList<NBVersionInfo>();
        for (List<RepositoryInfo> list : collection) {
            ClassesQuery classesQuery;
            RepositoryIndexerImplementation repositoryIndexerImplementation = RepositoryIndexer.findImplementation(list.get(0));
            if (repositoryIndexerImplementation == null || (classesQuery = (ClassesQuery)repositoryIndexerImplementation.getCapabilityLookup().lookup(ClassesQuery.class)) == null) continue;
            arrayList.addAll(classesQuery.findVersionsByClass(string, list));
        }
        return arrayList;
    }

    public static List<NBVersionInfo> findArchetypes(RepositoryInfo ... repositoryInfoArray) {
        Collection<List<RepositoryInfo>> collection = RepositoryQueries.splitReposByType(repositoryInfoArray);
        ArrayList<NBVersionInfo> arrayList = new ArrayList<NBVersionInfo>();
        for (List<RepositoryInfo> list : collection) {
            ArchetypeQueries archetypeQueries;
            RepositoryIndexerImplementation repositoryIndexerImplementation = RepositoryIndexer.findImplementation(list.get(0));
            if (repositoryIndexerImplementation == null || (archetypeQueries = (ArchetypeQueries)repositoryIndexerImplementation.getCapabilityLookup().lookup(ArchetypeQueries.class)) == null) continue;
            arrayList.addAll(archetypeQueries.findArchetypes(list));
        }
        return arrayList;
    }

    public static Set<String> filterPluginArtifactIds(String string, String string2, RepositoryInfo ... repositoryInfoArray) {
        Collection<List<RepositoryInfo>> collection = RepositoryQueries.splitReposByType(repositoryInfoArray);
        TreeSet<String> treeSet = new TreeSet<String>();
        for (List<RepositoryInfo> list : collection) {
            RepositoryIndexerImplementation repositoryIndexerImplementation = RepositoryIndexer.findImplementation(list.get(0));
            if (repositoryIndexerImplementation == null) continue;
            BaseQueries baseQueries = (BaseQueries)repositoryIndexerImplementation.getCapabilityLookup().lookup(BaseQueries.class);
            assert (baseQueries != null) : "All RepositoryIndexerImplementation need to define BaseQueries:" + repositoryIndexerImplementation.getType() + " : " + repositoryIndexerImplementation.getClass();
            treeSet.addAll(baseQueries.filterPluginArtifactIds(string, string2, list));
        }
        return treeSet;
    }

    public static Set<String> filterPluginGroupIds(String string, RepositoryInfo ... repositoryInfoArray) {
        Collection<List<RepositoryInfo>> collection = RepositoryQueries.splitReposByType(repositoryInfoArray);
        TreeSet<String> treeSet = new TreeSet<String>();
        for (List<RepositoryInfo> list : collection) {
            RepositoryIndexerImplementation repositoryIndexerImplementation = RepositoryIndexer.findImplementation(list.get(0));
            if (repositoryIndexerImplementation == null) continue;
            BaseQueries baseQueries = (BaseQueries)repositoryIndexerImplementation.getCapabilityLookup().lookup(BaseQueries.class);
            assert (baseQueries != null) : "All RepositoryIndexerImplementation need to define BaseQueries:" + repositoryIndexerImplementation.getType() + " : " + repositoryIndexerImplementation.getClass();
            treeSet.addAll(baseQueries.filterPluginGroupIds(string, list));
        }
        return treeSet;
    }

    public static List<NBVersionInfo> find(List<QueryField> list, RepositoryInfo ... repositoryInfoArray) {
        Collection<List<RepositoryInfo>> collection = RepositoryQueries.splitReposByType(repositoryInfoArray);
        ArrayList<NBVersionInfo> arrayList = new ArrayList<NBVersionInfo>();
        for (List<RepositoryInfo> list2 : collection) {
            GenericFindQuery genericFindQuery;
            RepositoryIndexerImplementation repositoryIndexerImplementation = RepositoryIndexer.findImplementation(list2.get(0));
            if (repositoryIndexerImplementation == null || (genericFindQuery = (GenericFindQuery)repositoryIndexerImplementation.getCapabilityLookup().lookup(GenericFindQuery.class)) == null) continue;
            arrayList.addAll(genericFindQuery.find(list, list2));
        }
        return arrayList;
    }

    public static List<RepositoryInfo> getLoadedContexts() {
        Collection<List<RepositoryInfo>> collection = RepositoryQueries.splitReposByType(null);
        ArrayList<RepositoryInfo> arrayList = new ArrayList<RepositoryInfo>();
        for (List<RepositoryInfo> list : collection) {
            ContextLoadedQuery contextLoadedQuery;
            RepositoryIndexerImplementation repositoryIndexerImplementation = RepositoryIndexer.findImplementation(list.get(0));
            if (repositoryIndexerImplementation == null || (contextLoadedQuery = (ContextLoadedQuery)repositoryIndexerImplementation.getCapabilityLookup().lookup(ContextLoadedQuery.class)) == null) continue;
            arrayList.addAll(contextLoadedQuery.getLoaded(list));
        }
        return arrayList;
    }

    public static Set<String> filterArtifactIdForGroupId(String string, String string2, RepositoryInfo ... repositoryInfoArray) {
        Collection<List<RepositoryInfo>> collection = RepositoryQueries.splitReposByType(repositoryInfoArray);
        TreeSet<String> treeSet = new TreeSet<String>();
        for (List<RepositoryInfo> list : collection) {
            RepositoryIndexerImplementation repositoryIndexerImplementation = RepositoryIndexer.findImplementation(list.get(0));
            if (repositoryIndexerImplementation == null) continue;
            BaseQueries baseQueries = (BaseQueries)repositoryIndexerImplementation.getCapabilityLookup().lookup(BaseQueries.class);
            assert (baseQueries != null) : "All RepositoryIndexerImplementation need to define BaseQueries:" + repositoryIndexerImplementation.getType() + " : " + repositoryIndexerImplementation.getClass();
            treeSet.addAll(baseQueries.filterArtifactIdForGroupId(string, string2, list));
        }
        return treeSet;
    }

    private static Collection<List<RepositoryInfo>> splitReposByType(RepositoryInfo[] repositoryInfoArray) {
        if (repositoryInfoArray == null || repositoryInfoArray.length == 0) {
            repositoryInfoArray = RepositoryPreferences.getInstance().getRepositoryInfos().toArray(new RepositoryInfo[0]);
        }
        HashMap<String, ArrayList<RepositoryInfo>> hashMap = new HashMap<String, ArrayList<RepositoryInfo>>();
        for (RepositoryInfo repositoryInfo : repositoryInfoArray) {
            String string = repositoryInfo.getType();
            ArrayList<RepositoryInfo> arrayList = (ArrayList<RepositoryInfo>)hashMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<RepositoryInfo>();
                hashMap.put(string, arrayList);
            }
            arrayList.add(repositoryInfo);
        }
        return hashMap.values();
    }
}

