/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.screen.display.property;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import org.netbeans.modules.vmd.api.io.PopupUtil;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyDescriptor;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyEditor;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.openide.util.NbBundle;

public class ScreenTextAreaPropertyEditor
implements ScreenPropertyEditor {
    private String propertyName;

    public ScreenTextAreaPropertyEditor(String string) {
        assert (string != null);
        this.propertyName = string;
    }

    public JComponent createEditorComponent(ScreenPropertyDescriptor screenPropertyDescriptor) {
        StringTextArea stringTextArea = new StringTextArea(screenPropertyDescriptor);
        stringTextArea.setMinimumSize(new Dimension(128, 21));
        PropertyValue propertyValue = screenPropertyDescriptor.getRelatedComponent().readProperty(this.propertyName);
        String string = MidpTypes.getString(propertyValue);
        stringTextArea.setText(string != null ? string : "");
        stringTextArea.setCaretPosition(stringTextArea.getDocument().getLength());
        return stringTextArea;
    }

    public Insets getEditorComponentInsets(JComponent jComponent) {
        return jComponent.getBorder().getBorderInsets(jComponent);
    }

    private class StringTextArea
    extends JTextArea
    implements KeyListener,
    FocusListener {
        private ScreenPropertyDescriptor property;

        public StringTextArea(ScreenPropertyDescriptor screenPropertyDescriptor) {
            this.property = screenPropertyDescriptor;
            this.setToolTipText(NbBundle.getMessage(ScreenTextAreaPropertyEditor.class, (String)"TTIP_ScreenTextAreaPE"));
            this.addKeyListener(this);
            this.addFocusListener(this);
        }

        public void keyTyped(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() != '\n' || (keyEvent.getModifiersEx() & 0x80) == 0) {
                return;
            }
            this.property.getRelatedComponent().getDocument().getTransactionManager().writeAccess(new Runnable(){

                public void run() {
                    PropertyValue propertyValue = MidpTypes.createStringValue(StringTextArea.this.getText());
                    StringTextArea.this.property.getRelatedComponent().writeProperty(ScreenTextAreaPropertyEditor.this.propertyName, propertyValue);
                }
            });
            PopupUtil.hidePopup();
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            this.property.getRelatedComponent().getDocument().getTransactionManager().writeAccess(new Runnable(){

                public void run() {
                    PropertyValue propertyValue = MidpTypes.createStringValue(StringTextArea.this.getText());
                    StringTextArea.this.property.getRelatedComponent().writeProperty(ScreenTextAreaPropertyEditor.this.propertyName, propertyValue);
                }
            });
            PopupUtil.hidePopup();
        }
    }
}

