/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.screen.display;

import java.awt.Dimension;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.screen.display.ScreenDeviceInfo;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyDescriptor;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyEditor;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.screen.display.GaugeDisplayPresenterElement;
import org.netbeans.modules.vmd.midp.screen.display.ItemDisplayPresenter;
import org.netbeans.modules.vmd.midp.screen.display.property.ResourcePropertyEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GaugeDisplayPresenter
extends ItemDisplayPresenter {
    private JPanel panel;
    private GaugeDisplayPresenterElement gauge = new GaugeDisplayPresenterElement();

    public GaugeDisplayPresenter() {
        this.panel = new JPanel(){

            public void paint(Graphics graphics) {
                super.paint(graphics);
                GaugeDisplayPresenter.this.gauge.setPanel(this);
                GaugeDisplayPresenter.this.gauge.paintGauge(graphics);
            }
        };
        this.panel.setOpaque(false);
        this.panel.setPreferredSize(new Dimension(200, 40));
        this.setContentComponent(this.panel);
        this.panel.repaint();
        this.panel.revalidate();
    }

    @Override
    public void reload(ScreenDeviceInfo screenDeviceInfo) {
        super.reload(screenDeviceInfo);
        this.gauge.setSize(this.panel.getSize());
        PropertyValue propertyValue = this.getComponent().readProperty("interactive");
        if (PropertyValue.Kind.VALUE.equals((Object)propertyValue.getKind())) {
            this.gauge.setInteractive(MidpTypes.getBoolean(propertyValue));
        }
        propertyValue = this.getComponent().readProperty("maxValue");
        int n = 1;
        if (PropertyValue.Kind.VALUE.equals((Object)propertyValue.getKind())) {
            n = MidpTypes.getInteger(propertyValue);
        }
        if (n < 0) {
            n = 1;
        }
        this.gauge.setMaxValue(n);
        propertyValue = this.getComponent().readProperty("value");
        int n2 = 0;
        if (PropertyValue.Kind.VALUE.equals((Object)propertyValue.getKind())) {
            n2 = MidpTypes.getInteger(propertyValue);
        }
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > n) {
            n2 = n;
        }
        this.gauge.setValue(n2);
        this.panel.repaint();
    }

    @Override
    public Collection<ScreenPropertyDescriptor> getPropertyDescriptors() {
        ResourcePropertyEditor resourcePropertyEditor = new ResourcePropertyEditor("value", this.getComponent());
        ArrayList<ScreenPropertyDescriptor> arrayList = new ArrayList<ScreenPropertyDescriptor>();
        arrayList.addAll(super.getPropertyDescriptors());
        arrayList.add(new ScreenPropertyDescriptor(this.getComponent(), (JComponent)this.panel, (ScreenPropertyEditor)resourcePropertyEditor));
        return arrayList;
    }
}

