/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors.resource.elements;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.vmd.api.io.ProjectUtils;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.midp.components.MidpProjectSupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.resources.ImageCD;
import org.netbeans.modules.vmd.midp.propertyeditors.CleanUp;
import org.netbeans.modules.vmd.midp.propertyeditors.api.resource.element.PropertyEditorResourceElement;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageEditorElement
extends PropertyEditorResourceElement
implements Runnable,
CleanUp {
    private static final String[] EXTENSIONS = new String[]{"png", "gif", "jpg", "jpeg"};
    private long componentID;
    private boolean doNotFireEvent;
    private String lastDir;
    private ImagePreview imagePreview;
    private Image image;
    private DefaultComboBoxModel comboBoxModel;
    private Map<String, FileObject> paths;
    private final AtomicBoolean requiresModelUpdate = new AtomicBoolean(false);
    private PropertyEditorResourceElement.DesignComponentWrapper wrapper;
    private WeakReference<DesignDocument> documentReferences;
    private JButton chooserButton;
    private JLabel heightLabel;
    private JTextField heightTextField;
    private JLabel pathLabel;
    private JComboBox pathTextComboBox;
    private JLabel previewLabel;
    private JPanel previewPanel;
    private JProgressBar progressBar;
    private JLabel sizeLabel;
    private JTextField sizeTextField;
    private JLabel widthLabel;
    private JTextField widthTextField;

    public ImageEditorElement() {
        this.paths = new HashMap<String, FileObject>();
        this.comboBoxModel = new DefaultComboBoxModel();
        this.initComponents();
        this.progressBar.setVisible(false);
        this.imagePreview = new ImagePreview();
        this.previewPanel.add((Component)this.imagePreview, "Center");
    }

    @Override
    public void clean(DesignComponent designComponent) {
        this.imagePreview = null;
        this.image = null;
        this.comboBoxModel = null;
        if (this.paths != null) {
            this.paths.clear();
            this.paths = null;
        }
        this.wrapper = null;
        this.documentReferences = null;
        this.removeAll();
    }

    @Override
    public JComponent getJComponent() {
        return this;
    }

    @Override
    public TypeID getTypeID() {
        return ImageCD.TYPEID;
    }

    @Override
    public List<String> getPropertyValueNames() {
        return Arrays.asList("resourcePath");
    }

    @Override
    public void setDesignComponent(DesignComponent designComponent) {
        this.init(designComponent.getDocument());
        super.setDesignComponent(designComponent);
    }

    @Override
    public void setDesignComponentWrapper(PropertyEditorResourceElement.DesignComponentWrapper designComponentWrapper) {
        this.wrapper = designComponentWrapper;
        if (this.documentReferences == null || this.documentReferences.get() == null) {
            return;
        }
        if (designComponentWrapper == null) {
            this.setText(null);
            this.setAllEnabled(false);
            return;
        }
        this.componentID = designComponentWrapper.getComponentID();
        final String[] stringArray = new String[1];
        final DesignComponent designComponent = designComponentWrapper.getComponent();
        if (designComponent != null) {
            if (!designComponent.getType().equals((Object)this.getTypeID())) {
                throw new IllegalArgumentException("Passed component must have typeID " + this.getTypeID() + " instead passed " + designComponent.getType());
            }
            this.componentID = designComponent.getComponentID();
            designComponent.getDocument().getTransactionManager().readAccess(new Runnable(){

                public void run() {
                    PropertyValue propertyValue = designComponent.readProperty("resourcePath");
                    if (!PropertyEditorResourceElement.isPropertyValueAUserCodeType(propertyValue)) {
                        stringArray[0] = MidpTypes.getString(propertyValue);
                    }
                }
            });
        }
        if (designComponentWrapper.hasChanges()) {
            Map<String, PropertyValue> map = designComponentWrapper.getChanges();
            for (String string : map.keySet()) {
                PropertyValue propertyValue = map.get(string);
                if (!"resourcePath".equals(string)) continue;
                stringArray[0] = MidpTypes.getString(propertyValue);
            }
        }
        this.setAllEnabled(true);
        this.setText(stringArray[0]);
    }

    private void setText(String string) {
        if (string == null) {
            string = "";
        }
        this.addImage(string);
    }

    private void addImage(String string) {
        this.doNotFireEvent = true;
        if (this.comboBoxModel.getIndexOf(string) == -1) {
            this.comboBoxModel.addElement(string);
            this.sortComboBoxContent();
        }
        this.pathTextComboBox.setSelectedItem(string);
        this.doNotFireEvent = false;
        this.updatePreview();
    }

    private void sortComboBoxContent() {
        int n = this.pathTextComboBox.getItemCount();
        ArrayList arrayList = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.pathTextComboBox.getItemAt(i));
        }
        Collections.sort(arrayList, PropertyEditorResourceElement.StringComparator.instance);
        this.pathTextComboBox.removeAllItems();
        for (Object e : arrayList) {
            this.pathTextComboBox.addItem(e);
        }
    }

    public void setAllEnabled(boolean bl) {
        this.pathLabel.setEnabled(bl);
        this.pathTextComboBox.setEnabled(bl);
        this.previewLabel.setEnabled(bl);
        this.previewPanel.setEnabled(bl);
        this.widthLabel.setEnabled(bl);
        this.widthTextField.setEnabled(bl);
        this.heightLabel.setEnabled(bl);
        this.heightTextField.setEnabled(bl);
        this.sizeLabel.setEnabled(bl);
        this.sizeTextField.setEnabled(bl);
        this.chooserButton.setEnabled(bl);
    }

    public void updateModel(DesignDocument designDocument) {
        boolean bl = this.pathTextComboBox.isEnabled();
        this.pathTextComboBox.setEnabled(false);
        this.doNotFireEvent = true;
        this.comboBoxModel.removeAllElements();
        this.doNotFireEvent = false;
        this.paths.clear();
        Map<FileObject, String> map = MidpProjectSupport.getImagesForProject(designDocument, false);
        for (Map.Entry<FileObject, String> entry : map.entrySet()) {
            this.checkFile(entry.getKey(), entry.getValue());
        }
        if (bl) {
            this.pathTextComboBox.setEnabled(true);
        }
    }

    private void checkFile(FileObject fileObject, String string) {
        for (String string2 : EXTENSIONS) {
            if (!string2.equals(fileObject.getExt().toLowerCase())) continue;
            String string3 = this.convertFile(fileObject, string, false);
            if (string3 == null) break;
            this.addImage(string3);
            break;
        }
    }

    private void updatePreview() {
        String string = (String)this.pathTextComboBox.getSelectedItem();
        FileObject fileObject = this.paths.get(string);
        BufferedImage bufferedImage = null;
        try {
            if (fileObject != null) {
                bufferedImage = ImageIO.read(fileObject.getInputStream());
            }
        }
        catch (IOException iOException) {
            System.out.print(iOException.getMessage());
        }
        if (bufferedImage != null) {
            int n = bufferedImage.getWidth();
            int n2 = bufferedImage.getHeight();
            this.widthTextField.setText(String.valueOf(n));
            this.heightTextField.setText(String.valueOf(n2));
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(fileObject.getSize());
            stringBuffer.append(' ');
            stringBuffer.append(NbBundle.getMessage(ImageEditorElement.class, (String)"LBL_Size_Bytes"));
            this.sizeTextField.setText(stringBuffer.toString());
            this.image = bufferedImage;
        } else {
            this.image = null;
            this.widthTextField.setText(null);
            this.heightTextField.setText(null);
            this.sizeTextField.setText(null);
        }
        this.previewPanel.invalidate();
        this.previewPanel.validate();
        this.previewPanel.repaint();
    }

    private FileObject getSourceFolder() {
        if (this.documentReferences != null && this.documentReferences.get() == null) {
            return null;
        }
        Project project = ProjectUtils.getProject((DesignDocument)((DesignDocument)this.documentReferences.get()));
        if (project == null) {
            if (this.documentReferences != null && this.documentReferences.get() != null) {
                project = ProjectUtils.getProject((DesignDocument)((DesignDocument)this.documentReferences.get()));
            }
            if (project == null) {
                throw Debug.illegalState((Object[])new Object[]{"Current project is null"});
            }
        }
        String string = ProjectUtils.getProjectID((Project)project);
        return ((SourceGroup)ProjectUtils.getSourceGroups((String)string).iterator().next()).getRootFolder();
    }

    private String convertFile(FileObject fileObject, String string, boolean bl) {
        String string2;
        FileObject fileObject2 = this.getSourceFolder();
        String string3 = FileUtil.toFile((FileObject)fileObject2).getAbsolutePath();
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file == null) {
            string2 = !fileObject.getPath().startsWith("/", 0) ? "/" + fileObject.getPath() : fileObject.getPath();
        } else {
            String string4 = file.getAbsolutePath();
            if (string4.contains(string3)) {
                int n;
                string4 = fileObject.getPath();
                string2 = !string4.substring(n = string4.indexOf(string3) + string3.length() + 1).startsWith("/") ? "/" + string4.substring(n) : string4.substring(n);
            } else if (bl) {
                File file2 = new File(string3 + File.separator + fileObject.getNameExt());
                if (file2.exists()) {
                    return null;
                }
                try {
                    fileObject = fileObject.copy(fileObject2, fileObject.getName(), fileObject.getExt());
                }
                catch (IOException iOException) {
                    Debug.warning((Object[])new Object[]{"SVGImageEditorElement.convertFile()", "can't copy file", string4, iOException});
                }
                string2 = "/" + fileObject.getNameExt();
            } else {
                string2 = string;
            }
        }
        this.paths.put(string2, fileObject);
        return string2;
    }

    public void init(DesignDocument designDocument) {
        this.documentReferences = new WeakReference<DesignDocument>(designDocument);
    }

    @Override
    public void run() {
        if (this.documentReferences == null || this.documentReferences.get() == null) {
            return;
        }
        DesignDocument designDocument = (DesignDocument)this.documentReferences.get();
        if (designDocument != null) {
            this.updateModel(designDocument);
        }
        this.showProgressBar(false);
        this.setDesignComponentWrapper(this.wrapper);
        this.requiresModelUpdate.set(false);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.requiresModelUpdate.getAndSet(true)) {
            return;
        }
        this.showProgressBar(true);
        new Thread(this).start();
    }

    private void showProgressBar(final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ImageEditorElement.this.progressBar.setVisible(bl);
            }
        });
    }

    @Override
    public void removeNotify() {
        this.paths.clear();
        this.wrapper = null;
        super.removeNotify();
    }

    private void initComponents() {
        this.pathLabel = new JLabel();
        this.previewLabel = new JLabel();
        this.previewPanel = new JPanel();
        this.widthLabel = new JLabel();
        this.widthTextField = new JTextField();
        this.heightLabel = new JLabel();
        this.heightTextField = new JTextField();
        this.chooserButton = new JButton();
        this.pathTextComboBox = new JComboBox();
        this.sizeLabel = new JLabel();
        this.sizeTextField = new JTextField();
        this.progressBar = new JProgressBar();
        this.pathLabel.setLabelFor(this.pathTextComboBox);
        Mnemonics.setLocalizedText((JLabel)this.pathLabel, (String)NbBundle.getMessage(ImageEditorElement.class, (String)"ImageEditorElement.pathLabel.text"));
        this.pathLabel.setEnabled(false);
        this.previewLabel.setText(NbBundle.getMessage(ImageEditorElement.class, (String)"ImageEditorElement.previewLabel.text"));
        this.previewLabel.setEnabled(false);
        this.previewPanel.setEnabled(false);
        this.previewPanel.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                ImageEditorElement.this.previewPanelComponentResized(componentEvent);
            }
        });
        this.previewPanel.setLayout(new BorderLayout());
        this.widthLabel.setLabelFor(this.widthTextField);
        Mnemonics.setLocalizedText((JLabel)this.widthLabel, (String)NbBundle.getMessage(ImageEditorElement.class, (String)"ImageEditorElement.widthLabel.text"));
        this.widthLabel.setEnabled(false);
        this.widthTextField.setEditable(false);
        this.widthTextField.setEnabled(false);
        this.heightLabel.setLabelFor(this.heightTextField);
        Mnemonics.setLocalizedText((JLabel)this.heightLabel, (String)NbBundle.getMessage(ImageEditorElement.class, (String)"ImageEditorElement.heightLabel.text"));
        this.heightLabel.setEnabled(false);
        this.heightTextField.setEditable(false);
        this.heightTextField.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.chooserButton, (String)NbBundle.getMessage(ImageEditorElement.class, (String)"ImageEditorElement.chooserButton.text"));
        this.chooserButton.setEnabled(false);
        this.chooserButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImageEditorElement.this.chooserButtonActionPerformed(actionEvent);
            }
        });
        this.pathTextComboBox.setEditable(true);
        this.pathTextComboBox.setModel(this.comboBoxModel);
        this.pathTextComboBox.setEnabled(false);
        this.pathTextComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImageEditorElement.this.pathTextComboBoxActionPerformed(actionEvent);
            }
        });
        this.sizeLabel.setLabelFor(this.sizeTextField);
        Mnemonics.setLocalizedText((JLabel)this.sizeLabel, (String)NbBundle.getMessage(ImageEditorElement.class, (String)"ImageEditorElement.sizeLabel.text"));
        this.sizeLabel.setEnabled(false);
        this.sizeTextField.setEditable(false);
        this.sizeTextField.setEnabled(false);
        this.progressBar.setIndeterminate(true);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.pathLabel).addContainerGap(287, Short.MAX_VALUE)).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.previewLabel).addPreferredGap(0).add((Component)this.previewPanel, -1, 0, Short.MAX_VALUE).add(18, 18, 18).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.heightLabel).add((Component)this.widthLabel).add((Component)this.sizeLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((Component)this.widthTextField, -1, 107, Short.MAX_VALUE).add((Component)this.heightTextField, -1, 107, Short.MAX_VALUE).add((Component)this.sizeTextField))).add((Component)this.progressBar, -2, -1, -2))).add((Component)this.pathTextComboBox, 0, 261, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.chooserButton)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.pathLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.pathTextComboBox, -2, -1, -2).add((Component)this.chooserButton)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.widthLabel).add((Component)this.widthTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.heightLabel).add((Component)this.heightTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.sizeTextField, -2, -1, -2).add((Component)this.sizeLabel)).addPreferredGap(0).add((Component)this.progressBar, -2, -1, -2).add(3, 3, 3)).add((Component)this.previewLabel).add((Component)this.previewPanel, -1, 100, Short.MAX_VALUE))));
        this.widthTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ImageEditorElement.class, (String)"ACSN_Width"));
        this.widthTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImageEditorElement.class, (String)"ACSD_Width"));
        this.heightTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ImageEditorElement.class, (String)"ACSN_Height"));
        this.heightTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImageEditorElement.class, (String)"ACSD_Height"));
        this.chooserButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ImageEditorElement.class, (String)"ACSN_Browse"));
        this.chooserButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImageEditorElement.class, (String)"ACSD_Browse"));
        this.pathTextComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ImageEditorElement.class, (String)"ASCN_ImagePath"));
        this.pathTextComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImageEditorElement.class, (String)"ASCD_ImagePath"));
        this.sizeTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ImageEditorElement.class, (String)"ACSN_Size"));
        this.sizeTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImageEditorElement.class, (String)"ACSD_Size"));
    }

    private void chooserButtonActionPerformed(ActionEvent actionEvent) {
        Project project = ProjectUtils.getProject((DesignDocument)((DesignDocument)this.documentReferences.get()));
        JFileChooser jFileChooser = new JFileChooser(this.lastDir != null ? this.lastDir : project.getProjectDirectory().getPath());
        jFileChooser.setFileFilter(new ImageFilter());
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)jFileChooser.getSelectedFile()));
            this.lastDir = jFileChooser.getSelectedFile().getParentFile().getPath();
            String string = this.convertFile(fileObject, null, true);
            if (string != null) {
                this.setText(string);
                this.pathTextComboBoxActionPerformed(null);
            } else {
                String string2 = NbBundle.getMessage(ImageEditorElement.class, (String)"MSG_FILE_EXIST");
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string2));
            }
        }
    }

    private void pathTextComboBoxActionPerformed(ActionEvent actionEvent) {
        if (!this.doNotFireEvent) {
            String string = (String)this.pathTextComboBox.getSelectedItem();
            this.fireElementChanged(this.componentID, "resourcePath", MidpTypes.createStringValue(string != null ? string : ""));
            this.updatePreview();
        }
        this.repaint();
    }

    private void previewPanelComponentResized(ComponentEvent componentEvent) {
        this.updatePreview();
    }

    private class ImagePreview
    extends JPanel {
        private static final int BORDER_EDGE_LENGTH = 10;
        private static final int IMAGE_GAP = 10;

        private ImagePreview() {
        }

        public void paint(Graphics graphics) {
            int n;
            int n2;
            if (ImageEditorElement.this.image != null) {
                n2 = ImageEditorElement.this.image.getWidth(null);
                n = ImageEditorElement.this.image.getHeight(null);
                int n3 = ImageEditorElement.this.imagePreview.getWidth() - 10;
                int n4 = ImageEditorElement.this.imagePreview.getHeight() - 10;
                if (n2 > n3 || n > n4) {
                    graphics.drawImage(ImageEditorElement.this.image, 10, 10, n3, n4, 0, 0, n2, n, null);
                } else {
                    int n5 = (n3 - n2 + 10) / 2;
                    int n6 = (n4 - n + 10) / 2;
                    graphics.drawImage(ImageEditorElement.this.image, n5, n6, null);
                }
            }
            graphics.setColor(Color.BLACK);
            n2 = this.getWidth() - 1;
            n = this.getHeight() - 1;
            graphics.drawLine(0, 0, 0, 10);
            graphics.drawLine(0, 0, 10, 0);
            graphics.drawLine(n2, 0, n2, 10);
            graphics.drawLine(n2, 0, n2 - 10, 0);
            graphics.drawLine(0, n, 0, n - 10);
            graphics.drawLine(0, n, 10, n);
            graphics.drawLine(n2, n, n2, n - 10);
            graphics.drawLine(n2, n, n2 - 10, n);
        }
    }

    private static class ImageFilter
    extends FileFilter {
        private String description = NbBundle.getMessage(ImageEditorElement.class, (String)"DISP_Image_Files");

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = ImageFilter.getExtension(file);
            for (String string2 : EXTENSIONS) {
                if (!string2.equals(string)) continue;
                return true;
            }
            return false;
        }

        public String getDescription() {
            return this.description;
        }

        private static String getExtension(File file) {
            String string = null;
            String string2 = file.getName();
            int n = string2.lastIndexOf(46);
            if (n > 0 && n < string2.length() - 1) {
                string = string2.substring(n + 1).toLowerCase();
            }
            return string;
        }
    }
}

