/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.propertyeditors.MidpPropertyEditorSupport;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorUserCode;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.InplaceEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.util.NbBundle;

public class PropertyEditorColorChooser
extends PropertyEditorUserCode
implements PropertyEditorElement {
    private static final String ERROR_WARNING = NbBundle.getMessage(PropertyEditorColorChooser.class, (String)"MSG_ILLEGAL_FORMATING");
    private static final String BUTTON_NAME = NbBundle.getMessage(PropertyEditorColorChooser.class, (String)"LBL_BUTTON_NAME");
    private static final String ACSN_BUTTON = NbBundle.getMessage(PropertyEditorColorChooser.class, (String)"ACSN_COLOR_BUTTON");
    private static final String ACSD_BUTTON = NbBundle.getMessage(PropertyEditorColorChooser.class, (String)"ACSD_COLOR_BUTTON");
    private static final String ACSN_COLOR_CHOOSER = NbBundle.getMessage(PropertyEditorColorChooser.class, (String)"ACSN_COLOR_CHOOSER");
    private static final String ACSD_COLOR_CHOOSER = NbBundle.getMessage(PropertyEditorColorChooser.class, (String)"ACSD_COLOR_CHOOSER");
    private JColorChooser customEditorElement;
    private JRadioButton radioButton;
    private InplaceEditor inplaceEditor;
    private boolean supportsCustomEditor;

    public PropertyEditorColorChooser(boolean bl) {
        super(NbBundle.getMessage(PropertyEditorColorChooser.class, (String)"LBL_COLOR_CHOOSER_UCLABEL"));
        this.supportsCustomEditor = bl;
    }

    public void cleanUp(DesignComponent designComponent) {
        super.cleanUp(designComponent);
        this.customEditorElement = null;
        this.radioButton = null;
        this.inplaceEditor = null;
    }

    public InplaceEditor getInplaceEditor() {
        if (this.inplaceEditor == null) {
            this.inplaceEditor = new PickColorInplaceEditor();
        }
        return this.inplaceEditor;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        PropertyValue propertyValue = (PropertyValue)super.getValue();
        Integer n = null;
        if (!(propertyValue.getPrimitiveValue() instanceof Integer)) {
            return;
        }
        n = (Integer)propertyValue.getPrimitiveValue();
        graphics.drawRect(rectangle.x + 1, rectangle.y + 2, 11, 11);
        Color color = new Color(n);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        stringBuffer.append(color.getRed());
        stringBuffer.append(',');
        stringBuffer.append(color.getGreen());
        stringBuffer.append(',');
        stringBuffer.append(color.getBlue());
        stringBuffer.append(']');
        graphics.drawString(stringBuffer.toString(), rectangle.x + 18, rectangle.y + 11);
        graphics.setColor(color);
        graphics.fillRect(rectangle.x + 2, rectangle.y + 3, 10, 10);
        graphics.dispose();
    }

    public boolean supportsCustomEditor() {
        if (!this.supportsCustomEditor) {
            return false;
        }
        return super.supportsCustomEditor();
    }

    public JComponent getCustomEditorComponent() {
        if (this.customEditorElement == null) {
            this.customEditorElement = new JColorChooser();
            this.customEditorElement.getAccessibleContext().setAccessibleName(ACSN_COLOR_CHOOSER);
            this.customEditorElement.getAccessibleContext().setAccessibleDescription(ACSD_COLOR_CHOOSER);
        }
        return this.customEditorElement;
    }

    public JRadioButton getRadioButton() {
        if (this.radioButton == null) {
            this.radioButton = new JRadioButton(BUTTON_NAME);
            Mnemonics.setLocalizedText((AbstractButton)this.radioButton, (String)BUTTON_NAME);
            this.radioButton.getAccessibleContext().setAccessibleName(ACSN_BUTTON);
            this.radioButton.getAccessibleContext().setAccessibleDescription(ACSD_BUTTON);
        }
        return this.radioButton;
    }

    public boolean isPaintable() {
        PropertyValue propertyValue = (PropertyValue)this.getValue();
        return propertyValue.getKind() == PropertyValue.Kind.VALUE;
    }

    public boolean isVerticallyResizable() {
        return true;
    }

    public boolean isInitiallySelected() {
        return false;
    }

    public String getAsText() {
        if (this.isCurrentValueAUserCodeType()) {
            return USER_CODE_TEXT;
        }
        if (this.isCurrentValueANull()) {
            return NULL_TEXT;
        }
        PropertyValue propertyValue = (PropertyValue)this.getValue();
        if (propertyValue.getKind() == PropertyValue.Kind.VALUE && propertyValue.getPrimitiveValue() instanceof Integer) {
            return this.getFormatedRGB((Integer)propertyValue.getPrimitiveValue());
        }
        throw new IllegalStateException();
    }

    private String getFormatedRGB(Integer n) {
        Color color = new Color(n);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        stringBuffer.append(color.getRed());
        stringBuffer.append(',');
        stringBuffer.append(color.getGreen());
        stringBuffer.append(',');
        stringBuffer.append(color.getBlue());
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public void setTextForPropertyValue(String string) {
    }

    public String getTextForPropertyValue() {
        return "";
    }

    public void updateState(PropertyValue propertyValue) {
        this.radioButton.setSelected(!this.isCurrentValueAUserCodeType());
        if (propertyValue == null || propertyValue.getKind() != PropertyValue.Kind.VALUE || propertyValue.getKind() == PropertyValue.Kind.NULL) {
            return;
        }
        if (!(propertyValue.getPrimitiveValue() instanceof Integer)) {
            throw new IllegalStateException();
        }
        this.customEditorElement.setColor(new Color((Integer)propertyValue.getPrimitiveValue()));
    }

    private void saveValue(Integer n) {
        PropertyValue propertyValue = MidpTypes.createIntegerValue(n);
        this.setValue(propertyValue);
        JTextField jTextField = (JTextField)this.inplaceEditor.getComponent();
        jTextField.setText(this.getFormatedRGB(n));
    }

    public void customEditorOKButtonPressed() {
        super.customEditorOKButtonPressed();
        if (this.radioButton.isSelected()) {
            this.saveValue(this.customEditorElement.getColor().getRGB());
        }
    }

    public boolean canWrite() {
        return MidpPropertyEditorSupport.singleSelectionEditAsTextOnly();
    }

    public Component getCustomEditor() {
        if (this.customEditorElement == null) {
            this.initElements(Collections.singleton(this));
        }
        return super.getCustomEditor();
    }

    private class ColorPropertyModel
    implements PropertyModel {
        private JTextField component;

        ColorPropertyModel(JTextField jTextField) {
            this.component = jTextField;
        }

        public Object getValue() throws InvocationTargetException {
            return this.component.getText();
        }

        public void setValue(Object object) throws InvocationTargetException {
            String string = this.component.getText();
            string = string.trim().replaceAll(Pattern.compile("[\\[$\\]]").pattern(), "");
            if (Pattern.compile("[^0123456789,]").matcher(string).find() || string.split(",").length != 3) {
                PropertyValue propertyValue = (PropertyValue)object;
                this.component.setText(PropertyEditorColorChooser.this.getFormatedRGB((Integer)propertyValue.getPrimitiveValue()));
                this.wrongValueWarning((PropertyValue)object, string);
                return;
            }
            int[] nArray = new int[3];
            int n = 0;
            for (String string2 : string.split(",")) {
                try {
                    nArray[n++] = Integer.valueOf(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    this.wrongValueWarning((PropertyValue)object, string);
                    return;
                }
                if (Integer.valueOf(string2) >= 0 && Integer.valueOf(string2) <= 255) continue;
                this.wrongValueWarning((PropertyValue)object, string);
                return;
            }
            int n2 = new Color(nArray[0], nArray[1], nArray[2]).getRGB();
            PropertyEditorColorChooser.this.saveValue(n2);
            PropertyEditorColorChooser.this.invokeSaveToModel();
        }

        public Class getPropertyType() {
            return PropertyEditorColorChooser.class;
        }

        public Class getPropertyEditorClass() {
            return PropertyEditorColorChooser.class;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        private void wrongValueWarning(PropertyValue propertyValue, String string) {
            this.component.setText(PropertyEditorColorChooser.this.getFormatedRGB((Integer)propertyValue.getPrimitiveValue()));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)(ERROR_WARNING + ' ' + string)));
        }
    }

    private class PickColorInplaceEditor
    implements InplaceEditor {
        private PropertyModel model;
        private JTextField component;

        private PickColorInplaceEditor() {
        }

        public void connect(PropertyEditor propertyEditor, PropertyEnv propertyEnv) {
        }

        public JComponent getComponent() {
            if (this.component == null) {
                this.component = new JTextField();
                PropertyValue propertyValue = (PropertyValue)this.getValue();
                if (propertyValue.getKind() == PropertyValue.Kind.VALUE && propertyValue.getPrimitiveValue() instanceof Integer) {
                    this.component.setText(PropertyEditorColorChooser.this.getFormatedRGB((Integer)propertyValue.getPrimitiveValue()));
                }
            }
            this.component.selectAll();
            return this.component;
        }

        public void clear() {
        }

        public Object getValue() {
            return PropertyEditorColorChooser.this.getValue();
        }

        public void setValue(Object object) {
        }

        public boolean supportsTextEntry() {
            return true;
        }

        public void reset() {
        }

        public void addActionListener(ActionListener actionListener) {
        }

        public void removeActionListener(ActionListener actionListener) {
        }

        public KeyStroke[] getKeyStrokes() {
            return null;
        }

        public PropertyEditor getPropertyEditor() {
            return PropertyEditorColorChooser.this;
        }

        public PropertyModel getPropertyModel() {
            if (this.model == null) {
                this.model = new ColorPropertyModel(this.component);
            }
            return this.model;
        }

        public void setPropertyModel(PropertyModel propertyModel) {
        }

        public boolean isKnownComponent(Component component) {
            return true;
        }
    }
}

