/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.components;

import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.presenters.InfoPresenter;
import org.openide.util.NbBundle;

public final class MidpValueSupport {
    public static String getHumanReadableString(PropertyValue propertyValue) {
        if (propertyValue == null) {
            return NbBundle.getMessage(MidpValueSupport.class, (String)"LBL_not_set");
        }
        switch (propertyValue.getKind()) {
            case ENUM: 
            case VALUE: {
                return propertyValue.getPrimitiveValue().toString();
            }
            case USERCODE: {
                return NbBundle.getMessage(MidpValueSupport.class, (String)"LBL_custom_code");
            }
            case NULL: {
                return NbBundle.getMessage(MidpValueSupport.class, (String)"LBL_null");
            }
            case ARRAY: {
                return NbBundle.getMessage(MidpValueSupport.class, (String)"LBL_array");
            }
            case REFERENCE: {
                return NbBundle.getMessage(MidpValueSupport.class, (String)"LBL_component", (Object)propertyValue.getComponent().getComponentID());
            }
        }
        throw new IllegalStateException();
    }

    public static String getHumanReadableString(DesignComponent designComponent) {
        InfoPresenter infoPresenter = (InfoPresenter)designComponent.getPresenter(InfoPresenter.class);
        return infoPresenter != null ? infoPresenter.getDisplayName(InfoPresenter.NameType.PRIMARY) : null;
    }
}

