/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.codegen;

import java.util.List;
import org.netbeans.modules.vmd.api.codegen.CodeReferencePresenter;
import org.netbeans.modules.vmd.api.codegen.CodeSupport;
import org.netbeans.modules.vmd.api.codegen.CodeWriter;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.midp.components.MidpTypes;

public class MidpCodeSupport {
    public static void generateCodeForPropertyValue(CodeWriter codeWriter, PropertyValue propertyValue) {
        switch (propertyValue.getKind()) {
            case ARRAY: {
                int n;
                TypeID typeID = propertyValue.getType();
                int n2 = typeID.getDimension();
                boolean bl = n2 > 1;
                List list = propertyValue.getArray();
                codeWriter.write("new " + MidpTypes.getOptimalizedFQNClassName(typeID));
                for (n = 0; n < n2; ++n) {
                    codeWriter.write("[]");
                }
                codeWriter.write(" {");
                if (list.size() > 0) {
                    codeWriter.write(bl ? "\n" : " ");
                }
                for (n = 0; n < list.size(); ++n) {
                    if (n > 0) {
                        codeWriter.write(bl ? ",\n" : ", ");
                    }
                    PropertyValue propertyValue2 = (PropertyValue)list.get(n);
                    MidpCodeSupport.generateCodeForPropertyValue(codeWriter, propertyValue2);
                }
                codeWriter.write(bl ? "}" : " }");
                break;
            }
            case ENUM: {
                MidpCodeSupport.generateEnumTypes(codeWriter, propertyValue);
                break;
            }
            case NULL: {
                codeWriter.write("null");
                break;
            }
            case REFERENCE: {
                codeWriter.write(CodeReferencePresenter.generateAccessCode((DesignComponent)propertyValue.getComponent()));
                break;
            }
            case USERCODE: {
                codeWriter.write(propertyValue.getUserCode());
                break;
            }
            case VALUE: {
                MidpCodeSupport.generatePrimitiveTypes(codeWriter, propertyValue);
                break;
            }
            default: {
                throw Debug.illegalState((Object[])new Object[0]);
            }
        }
    }

    private static void generatePrimitiveTypes(CodeWriter codeWriter, PropertyValue propertyValue) {
        TypeID typeID = propertyValue.getType();
        if (MidpTypes.TYPEID_INT.equals((Object)typeID)) {
            codeWriter.write(propertyValue.getPrimitiveValue().toString());
        } else if (MidpTypes.TYPEID_LONG.equals((Object)typeID)) {
            codeWriter.write(propertyValue.getPrimitiveValue().toString() + "l");
        } else if (MidpTypes.TYPEID_CHAR.equals((Object)typeID)) {
            codeWriter.write(Integer.toString(((Character)propertyValue.getPrimitiveValue()).charValue()));
        } else if (MidpTypes.TYPEID_BYTE.equals((Object)typeID)) {
            codeWriter.write(propertyValue.getPrimitiveValue().toString());
        } else if (MidpTypes.TYPEID_SHORT.equals((Object)typeID)) {
            codeWriter.write(propertyValue.getPrimitiveValue().toString());
        } else if (MidpTypes.TYPEID_FLOAT.equals((Object)typeID)) {
            codeWriter.write(propertyValue.getPrimitiveValue().toString() + "f");
        } else if (MidpTypes.TYPEID_DOUBLE.equals((Object)typeID)) {
            codeWriter.write(propertyValue.getPrimitiveValue().toString());
        } else if (MidpTypes.TYPEID_BOOLEAN.equals((Object)typeID)) {
            codeWriter.write((Boolean)propertyValue.getPrimitiveValue() != false ? "true" : "false");
        } else if (MidpTypes.TYPEID_JAVA_LANG_STRING.equals((Object)typeID)) {
            codeWriter.write("\"" + CodeSupport.encryptStringToJavaCode((String)propertyValue.getPrimitiveValue().toString()) + "\"");
        } else if (MidpTypes.TYPEID_JAVA_CODE.equals((Object)typeID)) {
            codeWriter.write(propertyValue.getPrimitiveValue().toString());
        }
    }

    private static void generateEnumTypes(CodeWriter codeWriter, PropertyValue propertyValue) {
        TypeID typeID = propertyValue.getType();
        if (MidpTypes.TYPEID_ALERT_TYPE.equals((Object)typeID)) {
            codeWriter.write("AlertType." + propertyValue.getPrimitiveValue().toString());
        }
    }
}

