/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.lang.ref.WeakReference;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RecursiveListener
extends WeakReference<FileObject>
implements FileChangeListener {
    private final FileChangeListener fcl;
    private final Set<FileObject> kept;

    public RecursiveListener(FileObject fileObject, FileChangeListener fileChangeListener, boolean bl) {
        super(fileObject);
        this.fcl = fileChangeListener;
        this.kept = bl ? new HashSet() : null;
        this.addAll(fileObject);
    }

    private void addAll(FileObject fileObject) {
        if (this.kept != null) {
            this.kept.add(fileObject);
            Enumeration<? extends FileObject> enumeration = fileObject.getChildren(true);
            while (enumeration.hasMoreElements()) {
                FileObject fileObject2 = enumeration.nextElement();
                this.kept.add(fileObject2);
            }
        }
    }

    @Override
    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        FileObject fileObject = (FileObject)this.get();
        if (fileObject != null && FileUtil.isParentOf(fileObject, fileRenameEvent.getFile())) {
            this.fcl.fileRenamed(fileRenameEvent);
        }
    }

    @Override
    public void fileFolderCreated(FileEvent fileEvent) {
        FileObject fileObject = (FileObject)this.get();
        FileObject fileObject2 = fileEvent.getFile();
        if (fileObject != null && FileUtil.isParentOf(fileObject, fileObject2)) {
            this.fcl.fileFolderCreated(fileEvent);
            this.addAll(fileObject2);
        }
    }

    @Override
    public void fileDeleted(FileEvent fileEvent) {
        FileObject fileObject = (FileObject)this.get();
        FileObject fileObject2 = fileEvent.getFile();
        if (fileObject != null && FileUtil.isParentOf(fileObject, fileObject2)) {
            this.fcl.fileDeleted(fileEvent);
            if (this.kept != null) {
                this.kept.remove(fileObject2);
            }
        }
    }

    @Override
    public void fileDataCreated(FileEvent fileEvent) {
        FileObject fileObject = (FileObject)this.get();
        FileObject fileObject2 = fileEvent.getFile();
        if (fileObject != null && FileUtil.isParentOf(fileObject, fileObject2)) {
            this.fcl.fileDataCreated(fileEvent);
            if (this.kept != null) {
                this.kept.add(fileObject2);
            }
        }
    }

    @Override
    public void fileChanged(FileEvent fileEvent) {
        FileObject fileObject = (FileObject)this.get();
        if (fileObject != null && FileUtil.isParentOf(fileObject, fileEvent.getFile())) {
            this.fcl.fileChanged(fileEvent);
        }
    }

    @Override
    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        FileObject fileObject = (FileObject)this.get();
        if (fileObject != null && FileUtil.isParentOf(fileObject, fileAttributeEvent.getFile())) {
            this.fcl.fileAttributeChanged(fileAttributeEvent);
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RecursiveListener recursiveListener = (RecursiveListener)object;
        if (!(this.fcl == recursiveListener.fcl || this.fcl != null && this.fcl.equals(recursiveListener.fcl))) {
            return false;
        }
        FileObject fileObject = (FileObject)recursiveListener.get();
        FileObject fileObject2 = (FileObject)this.get();
        return fileObject2 == fileObject || fileObject2 != null && fileObject2.equals(fileObject);
    }

    public int hashCode() {
        FileObject fileObject = (FileObject)this.get();
        int n = 3;
        n = 37 * n + (this.fcl != null ? this.fcl.hashCode() : 0);
        n = 13 * n + (fileObject != null ? fileObject.hashCode() : 0);
        return n;
    }
}

