/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.multiview.ui;

import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.xml.multiview.SectionNode;
import org.netbeans.modules.xml.multiview.Utils;
import org.netbeans.modules.xml.multiview.ui.BoxPanel;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionNodeInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.openide.nodes.Node;

public class SectionNodePanel
extends SectionPanel {
    private final boolean openFirstChild;

    public SectionNodePanel(SectionNode sectionNode) {
        this(sectionNode, true);
    }

    public SectionNodePanel(final SectionNode sectionNode, boolean bl) {
        super((SectionView)sectionNode.getSectionNodeView(), (Node)sectionNode, sectionNode.getDisplayName(), (Object)sectionNode);
        this.openFirstChild = bl;
        if (sectionNode.getKey() instanceof SectionView) {
            this.setInnerViewMode();
        } else if (sectionNode.isExpanded()) {
            this.setExpandedViewMode();
        }
        sectionNode.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("displayName".equals(propertyChangeEvent.getPropertyName())) {
                    SectionNodePanel.this.setTitle(sectionNode.getDisplayName());
                }
            }
        });
    }

    protected void setExpandedViewMode() {
        this.getTitleButton().setVisible(true);
        this.getFoldButton().setVisible(false);
        this.getHeaderSeparator().setVisible(false);
        EmptyBorder emptyBorder = new EmptyBorder(0, 4, 4, 4);
        Border border = new JTextField().getBorder();
        this.setBorder(new CompoundBorder(emptyBorder, new CompoundBorder(border, emptyBorder)));
        this.openInnerPanel();
        this.getFillerLine().setVisible(false);
        this.getFillerEnd().setVisible(false);
    }

    protected void setInnerViewMode() {
        this.getTitleButton().setVisible(false);
        this.getFoldButton().setVisible(false);
        this.getHeaderSeparator().setVisible(false);
        this.openInnerPanel();
        this.getFillerLine().setVisible(false);
        this.getFillerEnd().setVisible(false);
    }

    protected SectionInnerPanel createInnerpanel() {
        SectionNodeInnerPanel sectionNodeInnerPanel = ((SectionNode)this.getNode()).createInnerPanel();
        if (sectionNodeInnerPanel == null) {
            sectionNodeInnerPanel = new BoxPanel(((SectionNode)this.getNode()).getSectionNodeView());
        }
        return sectionNodeInnerPanel;
    }

    protected void openInnerPanel() {
        Node[] nodeArray;
        super.openInnerPanel();
        if (this.openFirstChild && (nodeArray = ((SectionNode)this.getNode()).getChildren().getNodes()) != null && nodeArray.length > 0) {
            SectionNodePanel sectionNodePanel = ((SectionNode)nodeArray[0]).getSectionNodePanel();
            sectionNodePanel.getFoldButton().setSelected(true);
            sectionNodePanel.openInnerPanel();
        }
    }

    protected void closeInnerPanel() {
        if (this.getFoldButton().isVisible()) {
            if (this.getSectionView().getActivePanel() == this) {
                for (Container container = this.getParent(); container != null; container = container.getParent()) {
                    if (!(container instanceof SectionPanel)) continue;
                    final SectionPanel sectionPanel = (SectionPanel)container;
                    Utils.runInAwtDispatchThread(new Runnable(){

                        public void run() {
                            sectionPanel.setActive(true);
                        }
                    });
                    break;
                }
            }
            super.closeInnerPanel();
        }
    }

    public void open() {
        Node node = this.getNode().getParentNode();
        if (node instanceof SectionNode) {
            ((SectionNode)node).getSectionNodePanel().open();
        }
        if (this.getInnerPanel() == null) {
            super.open();
        }
    }
}

