/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.multiview;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public abstract class XmlMultiViewDataSynchronizer {
    private final int updateDelay;
    private long timeStamp;
    private final XmlMultiViewDataObject dataObject;
    private int reloading = 0;
    private int updating = 0;
    protected final RequestProcessor requestProcessor = new RequestProcessor("XmlMultiViewDataSynchronizer RequestProcessor", 1);
    private FileLock updateLock = null;
    private final RequestProcessor.Task updateTask = this.requestProcessor.create(new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (XmlMultiViewDataSynchronizer.this.isUpdateLock()) {
                XmlMultiViewDataSynchronizer.this.finishUpdateTask.cancel();
                XmlMultiViewDataSynchronizer.this.updateData(XmlMultiViewDataSynchronizer.this.updateLock, true);
                RequestProcessor.Task task = XmlMultiViewDataSynchronizer.this.updateTask;
                synchronized (task) {
                    if (XmlMultiViewDataSynchronizer.this.updateTask.getDelay() <= 0) {
                        XmlMultiViewDataSynchronizer.this.finishUpdateTask.schedule(1);
                    }
                }
            }
        }
    });
    private final RequestProcessor.Task finishUpdateTask = this.requestProcessor.create(new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            RequestProcessor.Task task = XmlMultiViewDataSynchronizer.this.updateTask;
            synchronized (task) {
                if (XmlMultiViewDataSynchronizer.this.isUpdateLock()) {
                    XmlMultiViewDataSynchronizer.this.updateLock.releaseLock();
                    XmlMultiViewDataSynchronizer.this.updateLock = null;
                }
            }
        }
    });
    private final RequestProcessor.Task reloadTask = this.requestProcessor.create(new Runnable(){

        public void run() {
            XmlMultiViewDataSynchronizer.this.reloadModel();
        }
    });
    private final XmlMultiViewDataObject.DataCache dataCache;

    public XmlMultiViewDataSynchronizer(XmlMultiViewDataObject xmlMultiViewDataObject, int n) {
        this.dataObject = xmlMultiViewDataObject;
        this.dataCache = xmlMultiViewDataObject.getDataCache();
        this.updateDelay = n;
        this.dataObject.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("data modified".equals(propertyChangeEvent.getPropertyName())) {
                    XmlMultiViewDataSynchronizer.this.dataModified((Long)propertyChangeEvent.getNewValue());
                } else if ("data changed".equals(propertyChangeEvent.getPropertyName())) {
                    XmlMultiViewDataSynchronizer.this.dataUpdated((Long)propertyChangeEvent.getNewValue());
                }
            }
        });
    }

    protected void dataModified(long l) {
        if (this.timeStamp < l) {
            this.reloadTask.schedule(10);
        }
    }

    protected void dataUpdated(long l) {
        if (this.updating == 0 && this.timeStamp < l) {
            this.reloadTask.schedule(10);
        }
    }

    public FileLock takeLock() throws IOException {
        FileLock fileLock = this.dataObject.waitForLock(1000L);
        if (fileLock != null) {
            if (this.mayUpdateData(true)) {
                return fileLock;
            }
            fileLock.releaseLock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void requestUpdateData() {
        if (this.reloading == 0) {
            RequestProcessor.Task task = this.updateTask;
            synchronized (task) {
                this.finishUpdateTask.cancel();
                if (!this.isUpdateLock()) {
                    try {
                        this.updateLock = this.takeLock();
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify((Throwable)iOException);
                        return;
                    }
                }
                this.updateTask.schedule(this.updateDelay);
            }
        }
    }

    private boolean isUpdateLock() {
        return this.updateLock != null && this.updateLock.isValid();
    }

    protected abstract boolean mayUpdateData(boolean var1);

    protected abstract void updateDataFromModel(Object var1, FileLock var2, boolean var3);

    protected abstract Object getModel();

    protected abstract void reloadModelFromData();

    final void reloadingStarted() {
        ++this.reloading;
    }

    final void reloadingFinished() {
        --this.reloading;
    }

    public final RequestProcessor.Task getReloadTask() {
        return this.reloadTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reloadModel() {
        long l = this.dataCache.getTimeStamp();
        if (this.timeStamp < l) {
            this.reloadingStarted();
            try {
                this.timeStamp = l;
                this.reloadModelFromData();
            }
            finally {
                this.reloadingFinished();
            }
        }
    }

    public Transaction openTransaction() {
        try {
            FileLock fileLock = this.takeLock();
            if (fileLock != null) {
                return new Transaction(fileLock);
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().annotate((Throwable)iOException, NbBundle.getMessage(XmlMultiViewDataSynchronizer.class, (String)"START_TRANSACTION_FAILED"));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateData(FileLock fileLock, boolean bl) {
        ++this.updating;
        try {
            this.updateDataFromModel(this.getModel(), fileLock, bl);
            this.timeStamp = this.dataCache.getTimeStamp();
        }
        finally {
            --this.updating;
            if (fileLock != null && fileLock.isValid()) {
                fileLock.releaseLock();
            }
        }
    }

    public class Transaction {
        private FileLock lock;

        private Transaction(FileLock fileLock) {
            this.lock = fileLock;
        }

        public void rollback() {
            if (this.lock != null) {
                XmlMultiViewDataSynchronizer.this.reloadModel();
                this.lock.releaseLock();
                this.lock = null;
            }
        }

        public void commit() throws IOException {
            XmlMultiViewDataSynchronizer.this.dataCache.testLock(this.lock);
            XmlMultiViewDataSynchronizer.this.updateData(this.lock, false);
            this.lock.releaseLock();
            this.lock = null;
        }
    }
}

