/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.search;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.classpath.GlobalPathRegistryEvent;
import org.netbeans.api.java.classpath.GlobalPathRegistryListener;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.modules.javadoc.search.JavadocSearchType;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class JavadocRegistry
implements GlobalPathRegistryListener,
ChangeListener,
PropertyChangeListener {
    private static JavadocRegistry INSTANCE;
    private GlobalPathRegistry regs = GlobalPathRegistry.getDefault();
    private ArrayList listeners;
    private Set results;
    private ClassPath docRoots;
    private Set classpaths;

    private JavadocRegistry() {
        this.regs.addGlobalPathRegistryListener((GlobalPathRegistryListener)this);
    }

    public static synchronized JavadocRegistry getDefault() {
        if (INSTANCE == null) {
            INSTANCE = new JavadocRegistry();
        }
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject[] getDocRoots() {
        Object object = this;
        synchronized (object) {
            if (this.docRoots != null) {
                return this.docRoots.getRoots();
            }
        }
        object = new HashSet();
        HashSet hashSet = new HashSet();
        Set set = JavadocRegistry.readRoots(this, (Set)object, hashSet);
        JavadocRegistry javadocRegistry = this;
        synchronized (javadocRegistry) {
            if (this.docRoots == null) {
                this.docRoots = ClassPathSupport.createClassPath((URL[])set.toArray(new URL[set.size()]));
                this.classpaths = object;
                this.results = hashSet;
                JavadocRegistry.registerListeners(this, (Set)object, hashSet, this.docRoots);
            }
            return this.docRoots.getRoots();
        }
    }

    public JavadocSearchType findSearchType(FileObject fileObject) {
        String string = this.getDocEncoding(fileObject);
        Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(JavadocSearchType.class));
        for (JavadocSearchType javadocSearchType : result.allInstances()) {
            if (!javadocSearchType.accepts(fileObject, string)) continue;
            return javadocSearchType;
        }
        return null;
    }

    private static Set readRoots(JavadocRegistry javadocRegistry, Set set, Set set2) {
        HashSet<URL> hashSet = new HashSet<URL>();
        LinkedList linkedList = new LinkedList();
        linkedList.addAll(javadocRegistry.regs.getPaths("classpath/compile"));
        linkedList.addAll(javadocRegistry.regs.getPaths("classpath/boot"));
        for (ClassPath classPath : linkedList) {
            set.add(classPath);
            List list = classPath.entries();
            for (ClassPath.Entry entry : list) {
                JavadocForBinaryQuery.Result result = JavadocForBinaryQuery.findJavadoc((URL)entry.getURL());
                set2.add(result);
                URL[] uRLArray = result.getRoots();
                hashSet.addAll(Arrays.asList(uRLArray));
            }
        }
        return hashSet;
    }

    private static void registerListeners(JavadocRegistry javadocRegistry, Set set, Set set2, ClassPath classPath) {
        for (ClassPath classPath2 : set) {
            classPath2.addPropertyChangeListener((PropertyChangeListener)javadocRegistry);
        }
        for (ClassPath classPath2 : set2) {
            classPath2.addChangeListener((ChangeListener)javadocRegistry);
        }
        classPath.addPropertyChangeListener((PropertyChangeListener)javadocRegistry);
    }

    public void pathsAdded(GlobalPathRegistryEvent globalPathRegistryEvent) {
        this.throwCache();
        this.fireChange();
    }

    public void pathsRemoved(GlobalPathRegistryEvent globalPathRegistryEvent) {
        this.throwCache();
        this.fireChange();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("entries".equals(propertyChangeEvent.getPropertyName()) || propertyChangeEvent.getSource() == this.docRoots) {
            this.throwCache();
            this.fireChange();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.throwCache();
        this.fireChange();
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        assert (changeListener != null) : "Listener can not be null.";
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(changeListener);
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        assert (changeListener != null) : "Listener can not be null.";
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        Iterator iterator = null;
        Object object = this;
        synchronized (object) {
            if (this.listeners == null) {
                return;
            }
            iterator = ((ArrayList)this.listeners.clone()).iterator();
        }
        object = new ChangeEvent(this);
        while (iterator.hasNext()) {
            ((ChangeListener)iterator.next()).stateChanged((ChangeEvent)object);
        }
    }

    private synchronized void throwCache() {
        ClassPath classPath;
        Iterator iterator;
        if (this.classpaths != null) {
            iterator = this.classpaths.iterator();
            while (iterator.hasNext()) {
                classPath = (ClassPath)iterator.next();
                classPath.removePropertyChangeListener((PropertyChangeListener)this);
                iterator.remove();
            }
        }
        if (this.results != null) {
            iterator = this.results.iterator();
            while (iterator.hasNext()) {
                classPath = (JavadocForBinaryQuery.Result)iterator.next();
                classPath.removeChangeListener((ChangeListener)this);
                iterator.remove();
            }
        }
        if (this.docRoots != null) {
            this.docRoots.removePropertyChangeListener((PropertyChangeListener)this);
            this.docRoots = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDocEncoding(FileObject fileObject) {
        assert (fileObject != null && fileObject.isFolder());
        FileObject fileObject2 = fileObject.getFileObject("index-all.html");
        if (fileObject2 == null) {
            fileObject2 = fileObject.getFileObject("index-files");
            if (fileObject2 == null) {
                return null;
            }
            if ((fileObject2 = fileObject2.getFileObject("index-1.html")) == null) {
                return null;
            }
        }
        ParserDelegator parserDelegator = new ParserDelegator();
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileObject2.getInputStream()));
            EncodingCallback encodingCallback = new EncodingCallback(bufferedReader);
            try {
                parserDelegator.parse(bufferedReader, encodingCallback, true);
            }
            catch (IOException iOException) {
            }
            finally {
                bufferedReader.close();
            }
            return encodingCallback.getEncoding();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().annotate((Throwable)iOException, fileObject2.toString());
            ErrorManager.getDefault().notify((Throwable)iOException);
            return null;
        }
    }

    private static class EncodingCallback
    extends HTMLEditorKit.ParserCallback {
        private Reader in;
        private String encoding;

        public EncodingCallback(Reader reader) {
            this.in = reader;
        }

        public String getEncoding() {
            return this.encoding;
        }

        public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
            String string;
            if (tag == HTML.Tag.META && (string = (String)mutableAttributeSet.getAttribute(HTML.Attribute.CONTENT)) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken().trim();
                    if (!string2.startsWith("charset") || (string2 = string2.substring(7).trim()).charAt(0) != '=') continue;
                    this.encoding = string2.substring(1).trim();
                    try {
                        this.in.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return;
                }
            }
        }

        public void handleStartTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
            if (tag == HTML.Tag.BODY) {
                try {
                    this.in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

