/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.hints;

import com.sun.javadoc.Doc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.Tag;
import com.sun.javadoc.ThrowsTag;
import com.sun.javadoc.Type;
import com.sun.source.tree.Tree;
import java.awt.EventQueue;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.lexer.JavadocTokenId;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.Line;
import org.openide.text.NbDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavadocUtilities {
    private static Set<TokenId> IGNORE_TOKES = null;

    private JavadocUtilities() {
    }

    private static TokenSequence<JavadocTokenId> findTokenSequence(CompilationInfo compilationInfo, Doc doc) {
        Element element = compilationInfo.getElementUtilities().elementFor(doc);
        if (element == null) {
            return null;
        }
        Tree tree = compilationInfo.getTrees().getTree(element);
        if (tree == null) {
            return null;
        }
        int n = (int)compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), tree);
        TokenSequence tokenSequence = compilationInfo.getTokenHierarchy().tokenSequence();
        tokenSequence.move(n);
        Token token = null;
        while (tokenSequence.movePrevious() && ((token = tokenSequence.token()).id() != JavaTokenId.BLOCK_COMMENT || !"/**/".contentEquals(token.text())) && IGNORE_TOKES.contains(token.id())) {
        }
        if (token == null || token.id() != JavaTokenId.JAVADOC_COMMENT) {
            return null;
        }
        return tokenSequence.embedded(JavadocTokenId.language());
    }

    static TokenSequence<JavadocTokenId> findTokenSequence(CompilationInfo compilationInfo, Element element) {
        if (element == null || compilationInfo.getElementUtilities().isSynthetic(element) || compilationInfo.getElements().getDocComment(element) == null) {
            return null;
        }
        Doc doc = compilationInfo.getElementUtilities().javaDocFor(element);
        return doc == null ? null : JavadocUtilities.findTokenSequence(compilationInfo, doc);
    }

    private static void moveToTag(TokenSequence<JavadocTokenId> tokenSequence, Tag tag, CompilationInfo compilationInfo) {
        Doc doc = tag.holder();
        Tag[] tagArray = doc.tags();
        int n = JavadocUtilities.findIndex(tagArray, tag);
        if (n == -1) {
            tagArray = doc.inlineTags();
            n = JavadocUtilities.findIndex(tagArray, tag);
            assert (n >= 0);
            n = JavadocUtilities.computeTagsWithSameNumberBefore(tagArray, tag);
        } else {
            n = JavadocUtilities.computeTagsWithSameNumberBefore(tagArray, tag);
        }
        assert (n >= 0);
        while (n >= 0 && tokenSequence.moveNext()) {
            if (tokenSequence.token().id() != JavadocTokenId.TAG || !tag.name().contentEquals(tokenSequence.token().text()) || --n >= 0) continue;
            return;
        }
        throw new IllegalStateException("Cannot match the tag: '" + tag.toString() + "'\nDoc.dump:\n" + doc.getRawCommentText() + "\nTokenSequence.dump: '" + tokenSequence.toString() + "'\nElement.dump: " + compilationInfo.getElementUtilities().elementFor(doc) + "\nFile.name: " + compilationInfo.getFileObject() + "\nFile.dump:\n" + compilationInfo.getText());
    }

    public static TokenSequence<JavadocTokenId> tokensFor(CompilationInfo compilationInfo, Tag tag) {
        Doc doc = tag.holder();
        TokenSequence<JavadocTokenId> tokenSequence = JavadocUtilities.findTokenSequence(compilationInfo, doc);
        assert (tokenSequence != null);
        JavadocUtilities.moveToTag(tokenSequence, tag, compilationInfo);
        int n = tokenSequence.offset();
        int n2 = tag.text().length();
        n2 = n2 > 0 ? n2 : tag.name().length();
        TokenSequence tokenSequence2 = compilationInfo.getTokenHierarchy().tokenSequence();
        return tokenSequence2.embedded(JavadocTokenId.language()).subSequence(n, n + n2);
    }

    public static Position[] findTagNameBounds(CompilationInfo compilationInfo, Document document, Tag tag) throws BadLocationException {
        TokenSequence<JavadocTokenId> tokenSequence = JavadocUtilities.findTokenSequence(compilationInfo, tag.holder());
        if (tokenSequence == null) {
            return null;
        }
        JavadocUtilities.moveToTag(tokenSequence, tag, compilationInfo);
        Position[] positionArray = new Position[]{document.createPosition(tokenSequence.offset()), document.createPosition(tokenSequence.offset() + tokenSequence.token().length())};
        return positionArray;
    }

    public static Position[] findDocBounds(CompilationInfo compilationInfo, Document document, Doc doc) throws BadLocationException {
        Element element = compilationInfo.getElementUtilities().elementFor(doc);
        if (element == null) {
            return null;
        }
        Tree tree = compilationInfo.getTrees().getTree(element);
        if (tree == null) {
            return null;
        }
        int n = (int)compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), tree);
        TokenSequence tokenSequence = compilationInfo.getTokenHierarchy().tokenSequence();
        tokenSequence.move(n);
        Token token = null;
        while (tokenSequence.movePrevious() && ((token = tokenSequence.token()).id() != JavaTokenId.BLOCK_COMMENT || !"/**/".contentEquals(token.text())) && IGNORE_TOKES.contains(token.id())) {
        }
        if (token == null || token.id() != JavaTokenId.JAVADOC_COMMENT) {
            return null;
        }
        Position[] positionArray = new Position[]{document.createPosition(tokenSequence.offset()), document.createPosition(tokenSequence.offset() + tokenSequence.token().length())};
        return positionArray;
    }

    public static Position[] findTagBounds(CompilationInfo compilationInfo, Document document, Tag tag) throws BadLocationException {
        return JavadocUtilities.findTagBounds(compilationInfo, document, tag, null);
    }

    public static Position[] findTagBounds(CompilationInfo compilationInfo, Document document, Tag tag, boolean[] blArray) throws BadLocationException {
        TokenSequence<JavadocTokenId> tokenSequence = JavadocUtilities.findTokenSequence(compilationInfo, tag.holder());
        if (tokenSequence == null) {
            return null;
        }
        JavadocUtilities.moveToTag(tokenSequence, tag, compilationInfo);
        int n = tokenSequence.offset();
        Token token = null;
        Token token2 = null;
        while (tokenSequence.moveNext()) {
            if (tokenSequence.token().id() == JavadocTokenId.TAG && token2 != null && (token2.id() != JavadocTokenId.OTHER_TEXT || token2.text().charAt(token2.text().length() - 1) != '{')) {
                token = tokenSequence.token();
                break;
            }
            token2 = tokenSequence.token();
        }
        if (blArray != null && blArray.length > 0) {
            blArray[0] = false;
        }
        int n2 = 0;
        if (token == null) {
            tokenSequence.moveEnd();
            tokenSequence.movePrevious();
            n2 = ((Object)tokenSequence.token().text()).toString().indexOf(10);
            int n3 = n2 = n2 >= 0 ? n2 : tokenSequence.token().length();
            if (blArray != null && blArray.length > 0) {
                blArray[0] = true;
            }
        }
        Position[] positionArray = new Position[]{document.createPosition(n), document.createPosition(tokenSequence.offset() + n2)};
        return positionArray;
    }

    public static Position[] findLastTokenBounds(CompilationInfo compilationInfo, Document document, Doc doc) throws BadLocationException {
        Position[] positionArray;
        TokenSequence<JavadocTokenId> tokenSequence = JavadocUtilities.findTokenSequence(compilationInfo, doc);
        if (tokenSequence == null) {
            return null;
        }
        if (tokenSequence.isEmpty()) {
            positionArray = JavadocUtilities.findDocBounds(compilationInfo, document, doc);
            positionArray[0] = document.createPosition(positionArray[0].getOffset() + "/**".length());
            positionArray[1] = positionArray[0];
        } else {
            tokenSequence.moveEnd();
            tokenSequence.movePrevious();
            positionArray = new Position[]{document.createPosition(tokenSequence.offset()), document.createPosition(tokenSequence.offset() + tokenSequence.token().length())};
        }
        return positionArray;
    }

    private static int computeTagsWithSameNumberBefore(Tag[] tagArray, Tag tag) {
        int n = 0;
        for (Tag tag2 : tagArray) {
            if (tag2 == tag) {
                return n;
            }
            if (!tag2.name().equals(tag.name())) continue;
            ++n;
        }
        return -1;
    }

    private static int findIndex(Tag[] tagArray, Tag tag) {
        for (int i = 0; i < tagArray.length; ++i) {
            if (tag != tagArray[i]) continue;
            return i;
        }
        return -1;
    }

    public static boolean isDeprecated(CompilationInfo compilationInfo, Element element) {
        return JavadocUtilities.findDeprecated(compilationInfo, element) != null;
    }

    public static AnnotationMirror findDeprecated(CompilationInfo compilationInfo, Element element) {
        TypeElement typeElement = compilationInfo.getElements().getTypeElement("java.lang.Deprecated");
        if (typeElement == null) {
            String string = String.format("Even though the source level of %s is set to JDK5 or later, java.lang.Deprecated cannot be found on the bootclasspath: %s", compilationInfo.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE), compilationInfo.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.BOOT));
            Logger.getLogger(JavadocUtilities.class.getName()).warning(string);
            return null;
        }
        for (AnnotationMirror annotationMirror : compilationInfo.getElements().getAllAnnotationMirrors(element)) {
            if (!typeElement.equals(annotationMirror.getAnnotationType().asElement())) continue;
            return annotationMirror;
        }
        return null;
    }

    public static boolean hasInheritedDoc(CompilationInfo compilationInfo, Element element) {
        return JavadocUtilities.findInheritedDoc(compilationInfo, element) != null;
    }

    public static MethodDoc findInheritedDoc(CompilationInfo compilationInfo, Element element) {
        if (element.getKind() == ElementKind.METHOD) {
            TypeElement typeElement = (TypeElement)element.getEnclosingElement();
            return JavadocUtilities.searchInInterfaces(compilationInfo, typeElement, typeElement, (ExecutableElement)element, new HashSet<TypeElement>());
        }
        return null;
    }

    private static MethodDoc searchInInterfaces(CompilationInfo compilationInfo, TypeElement typeElement, TypeElement typeElement2, ExecutableElement executableElement, Set<TypeElement> set) {
        MethodDoc methodDoc;
        TypeElement typeElement3;
        for (TypeMirror typeMirror : typeElement.getInterfaces()) {
            if (typeMirror.getKind() != TypeKind.DECLARED || set.contains(typeElement3 = (TypeElement)((DeclaredType)typeMirror).asElement())) continue;
            methodDoc = JavadocUtilities.searchInMethods(compilationInfo, typeElement3, typeElement2, executableElement);
            if (methodDoc != null) {
                return methodDoc;
            }
            set.add(typeElement3);
        }
        for (TypeMirror typeMirror : typeElement.getInterfaces()) {
            if (typeMirror.getKind() != TypeKind.DECLARED || (methodDoc = JavadocUtilities.searchInInterfaces(compilationInfo, typeElement3 = (TypeElement)((DeclaredType)typeMirror).asElement(), typeElement2, executableElement, set)) == null) continue;
            return methodDoc;
        }
        return JavadocUtilities.searchInSuperclass(compilationInfo, typeElement, typeElement2, executableElement, set);
    }

    private static MethodDoc searchInSuperclass(CompilationInfo compilationInfo, TypeElement typeElement, TypeElement typeElement2, ExecutableElement executableElement, Set<TypeElement> set) {
        TypeMirror typeMirror = typeElement.getSuperclass();
        if (typeMirror.getKind() != TypeKind.DECLARED) {
            return null;
        }
        TypeElement typeElement3 = (TypeElement)((DeclaredType)typeMirror).asElement();
        MethodDoc methodDoc = JavadocUtilities.searchInMethods(compilationInfo, typeElement3, typeElement2, executableElement);
        if (methodDoc != null) {
            return methodDoc;
        }
        return JavadocUtilities.searchInInterfaces(compilationInfo, typeElement3, typeElement2, executableElement, set);
    }

    private static MethodDoc searchInMethods(CompilationInfo compilationInfo, TypeElement typeElement, TypeElement typeElement2, ExecutableElement executableElement) {
        for (Element element : typeElement.getEnclosedElements()) {
            if (element.getKind() != ElementKind.METHOD || !compilationInfo.getElements().overrides(executableElement, (ExecutableElement)element, typeElement2)) continue;
            Doc doc = compilationInfo.getElementUtilities().javaDocFor(element);
            return doc != null && doc.getRawCommentText().length() > 0 ? (MethodDoc)doc : null;
        }
        return null;
    }

    public static ParamTag findParamTag(CompilationInfo compilationInfo, MethodDoc methodDoc, String string, boolean bl, boolean bl2) {
        ExecutableElement executableElement = (ExecutableElement)compilationInfo.getElementUtilities().elementFor((Doc)methodDoc);
        TypeElement typeElement = (TypeElement)executableElement.getEnclosingElement();
        TypeElement typeElement2 = null;
        HashSet<TypeElement> hashSet = null;
        while (methodDoc != null) {
            ParamTag[] paramTagArray = bl ? methodDoc.typeParamTags() : methodDoc.paramTags();
            for (ParamTag paramTag : paramTagArray) {
                if (!string.equals(paramTag.parameterName())) continue;
                return paramTag;
            }
            if (!bl2) break;
            if (hashSet == null) {
                hashSet = new HashSet<TypeElement>();
            }
            if (typeElement2 == null) {
                typeElement2 = typeElement;
            } else {
                Element element = compilationInfo.getElementUtilities().elementFor((Doc)methodDoc);
                typeElement2 = (TypeElement)element.getEnclosingElement();
            }
            methodDoc = JavadocUtilities.searchInInterfaces(compilationInfo, typeElement2, typeElement, executableElement, hashSet);
        }
        return null;
    }

    public static ThrowsTag findThrowsTag(CompilationInfo compilationInfo, MethodDoc methodDoc, String string, boolean bl) {
        ExecutableElement executableElement = (ExecutableElement)compilationInfo.getElementUtilities().elementFor((Doc)methodDoc);
        TypeElement typeElement = (TypeElement)executableElement.getEnclosingElement();
        TypeElement typeElement2 = null;
        HashSet<TypeElement> hashSet = null;
        while (methodDoc != null) {
            for (ThrowsTag throwsTag : methodDoc.throwsTags()) {
                Type type = throwsTag.exceptionType();
                String string2 = null;
                string2 = type != null ? throwsTag.exceptionType().qualifiedTypeName() : throwsTag.exceptionName();
                if (!string2.equals(string)) continue;
                return throwsTag;
            }
            if (!bl) break;
            if (hashSet == null) {
                hashSet = new HashSet<TypeElement>();
            }
            if (typeElement2 == null) {
                typeElement2 = typeElement;
            } else {
                Element element = compilationInfo.getElementUtilities().elementFor((Doc)methodDoc);
                typeElement2 = (TypeElement)element.getEnclosingElement();
            }
            methodDoc = JavadocUtilities.searchInInterfaces(compilationInfo, typeElement2, typeElement, executableElement, hashSet);
            JavadocUtilities.loadInheritedContext(compilationInfo, methodDoc);
        }
        return null;
    }

    public static Tag findReturnTag(CompilationInfo compilationInfo, MethodDoc methodDoc, boolean bl) {
        ExecutableElement executableElement = (ExecutableElement)compilationInfo.getElementUtilities().elementFor((Doc)methodDoc);
        TypeElement typeElement = (TypeElement)executableElement.getEnclosingElement();
        TypeElement typeElement2 = null;
        HashSet<TypeElement> hashSet = null;
        while (methodDoc != null) {
            Tag[] tagArray = methodDoc.tags("@return");
            if (tagArray.length > 0) {
                return tagArray[0];
            }
            if (!bl) break;
            if (hashSet == null) {
                hashSet = new HashSet<TypeElement>();
            }
            if (typeElement2 == null) {
                typeElement2 = typeElement;
            } else {
                Element element = compilationInfo.getElementUtilities().elementFor((Doc)methodDoc);
                typeElement2 = (TypeElement)element.getEnclosingElement();
            }
            methodDoc = JavadocUtilities.searchInInterfaces(compilationInfo, typeElement2, typeElement, executableElement, hashSet);
        }
        return null;
    }

    private static void loadInheritedContext(CompilationInfo compilationInfo, MethodDoc methodDoc) {
        Element element = compilationInfo.getElementUtilities().elementFor((Doc)methodDoc);
        Tree tree = compilationInfo.getTrees().getTree(element);
    }

    public static void open(final FileObject fileObject, final int n) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                JavadocUtilities.doOpenImpl(fileObject, n);
            }
        });
    }

    private static boolean doOpenImpl(FileObject fileObject, int n) {
        try {
            StyledDocument styledDocument;
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
            if (editorCookie != null && lineCookie != null && n != -1 && (styledDocument = editorCookie.openDocument()) != null) {
                Line line;
                int n2 = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n);
                int n3 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)n2);
                int n4 = n - n3;
                if (n2 != -1 && (line = lineCookie.getLineSet().getCurrent(n2)) != null) {
                    line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS, n4);
                    return true;
                }
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(JavadocUtilities.class.getName()).log(Level.SEVERE, iOException.getMessage(), iOException);
        }
        return false;
    }

    static {
        IGNORE_TOKES = new HashSet<TokenId>();
        IGNORE_TOKES.add((TokenId)JavaTokenId.WHITESPACE);
        IGNORE_TOKES.add((TokenId)JavaTokenId.BLOCK_COMMENT);
        IGNORE_TOKES.add((TokenId)JavaTokenId.LINE_COMMENT);
    }

    public static final class TagHandle {
        private final String name;
        private final String text;
        private final int index;

        private TagHandle(Tag tag) {
            this.name = tag.name();
            this.text = tag.text();
            this.index = JavadocUtilities.findIndex(tag.holder().tags(), tag);
        }

        public static TagHandle create(Tag tag) {
            return new TagHandle(tag);
        }

        public Tag resolve(Doc doc) {
            Tag[] tagArray = doc.tags();
            if (this.index < tagArray.length && this.name.equals(tagArray[this.index].name()) && this.text.equals(tagArray[this.index].text())) {
                return tagArray[this.index];
            }
            for (Tag tag : tagArray) {
                if (!this.name.equals(tag.name()) || !this.text.equals(tag.text())) continue;
                return tag;
            }
            return null;
        }

        public String toString() {
            return super.toString() + "[index: " + this.index + "name: " + this.name + "text: " + this.text + ']';
        }
    }
}

