/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.builtin;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.api.diff.Difference;
import org.netbeans.modules.diff.cmdline.CmdlineDiffProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Patch
extends Reader {
    private static final int CONTEXT_DIFF = 0;
    private static final int NORMAL_DIFF = 1;
    private static final int UNIFIED_DIFF = 2;
    private Difference[] diffs;
    private PushbackReader source;
    private int currDiff = 0;
    private int line = 1;
    private String newLine = null;
    private StringBuffer buff = new StringBuffer();
    private static final String CONTEXT_MARK1B = "*** ";
    private static final String CONTEXT_MARK2B = "--- ";
    private static final String CONTEXT_MARK_DELIMETER = ",";
    private static final String DIFFERENCE_DELIMETER = "***************";
    private static final String LINE_PREP_ADD = "+ ";
    private static final String LINE_PREP_REMOVE = "- ";
    private static final String LINE_PREP_CHANGE = "! ";
    private static final String UNIFIED_MARK = "@@";
    private static final String UNIFIED_MARK1 = "--- ";
    private static final String LINE_PREP_UNIF_ADD = "+";
    private static final String LINE_PREP_UNIF_REMOVE = "-";

    private Patch(Difference[] differenceArray, Reader reader) {
        this.diffs = differenceArray;
        this.source = new PushbackReader(new BufferedReader(reader), 1);
    }

    public static Reader apply(Difference[] differenceArray, Reader reader) {
        return new Patch(differenceArray, reader);
    }

    public static FileDifferences[] parse(Reader reader) throws IOException {
        ArrayList<FileDifferences> arrayList = new ArrayList<FileDifferences>();
        SinglePatchReader singlePatchReader = new SinglePatchReader(reader);
        int[] nArray = new int[1];
        String[] stringArray = new String[2];
        while (singlePatchReader.hasNextPatch(nArray, stringArray)) {
            Difference[] differenceArray = null;
            switch (nArray[0]) {
                case 0: {
                    differenceArray = Patch.parseContextDiff(singlePatchReader);
                    break;
                }
                case 2: {
                    differenceArray = Patch.parseUnifiedDiff(singlePatchReader);
                    break;
                }
                case 1: {
                    differenceArray = Patch.parseNormalDiff(singlePatchReader);
                }
            }
            if (differenceArray == null) continue;
            arrayList.add(new FileDifferences(stringArray[0], stringArray[1], differenceArray));
        }
        return arrayList.toArray(new FileDifferences[arrayList.size()]);
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3;
        if (this.buff.length() < n2) {
            this.doRetrieve(n2 - this.buff.length());
        }
        if ((n3 = Math.min(this.buff.length(), n2)) == 0) {
            return -1;
        }
        String string = this.buff.substring(0, n3);
        char[] cArray2 = string.toCharArray();
        System.arraycopy(cArray2, 0, cArray, n, n3);
        this.buff.delete(0, n3);
        return n3;
    }

    @Override
    public void close() throws IOException {
        if (this.currDiff < this.diffs.length) {
            throw new IOException("There are " + (this.diffs.length - this.currDiff) + " pending hunks!");
        }
        this.source.close();
    }

    private void doRetrieve(int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            CharSequence charSequence;
            if (this.currDiff < this.diffs.length && (1 == this.diffs[this.currDiff].getType() && this.line == this.diffs[this.currDiff].getFirstStart() + 1 || 1 != this.diffs[this.currDiff].getType() && this.line == this.diffs[this.currDiff].getFirstStart())) {
                if (this.compareText(this.source, this.diffs[this.currDiff].getFirstText())) {
                    charSequence = Patch.convertNewLines(this.diffs[this.currDiff].getSecondText(), this.newLine);
                    this.buff.append((String)charSequence);
                    ++this.currDiff;
                } else {
                    throw new IOException("Patch not applicable.");
                }
            }
            charSequence = null;
            if (this.newLine == null) {
                charSequence = new StringBuffer();
            }
            String string = Patch.readLine(this.source, charSequence);
            if (charSequence != null) {
                this.newLine = charSequence.toString();
            }
            if (string == null) break;
            this.buff.append(string);
            this.buff.append(this.newLine);
            ++this.line;
        }
    }

    private static String readLine(PushbackReader pushbackReader, StringBuffer stringBuffer) throws IOException {
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = pushbackReader.read();
        if (n == -1) {
            return null;
        }
        char c = (char)n;
        while (c != '\n' && c != '\r') {
            stringBuffer2.append(c);
            n = pushbackReader.read();
            if (n == -1) break;
            c = (char)n;
        }
        if (stringBuffer != null) {
            stringBuffer.append(c);
        }
        if (c == '\r') {
            try {
                n = pushbackReader.read();
                if (n != -1) {
                    c = (char)n;
                    if (c != '\n') {
                        pushbackReader.unread(c);
                    } else if (stringBuffer != null) {
                        stringBuffer.append(c);
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return stringBuffer2.toString();
    }

    private static String convertNewLines(String string, String string2) {
        if (string == null) {
            return "";
        }
        if (string2 == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\n') {
                stringBuffer.append(string2);
                continue;
            }
            if (c == '\r') {
                if (i + 1 >= string.length() || string.charAt(i + 1) != '\n') continue;
                ++i;
                stringBuffer.append(string2);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private boolean compareText(PushbackReader pushbackReader, String string) throws IOException {
        int n;
        if (string == null || string.length() == 0) {
            return true;
        }
        string = this.adjustTextNL(string);
        char[] cArray = new char[string.length()];
        int n2 = 0;
        String string2 = "";
        do {
            if ((n = pushbackReader.read(cArray, 0, cArray.length - n2)) > 0) {
                n2 += n;
                string2 = string2 + new String(cArray, 0, n);
            }
            if (string2.endsWith("\r")) {
                try {
                    char c = (char)pushbackReader.read();
                    if (c != '\n') {
                        pushbackReader.unread(c);
                    } else {
                        string2 = string2 + c;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            string2 = this.adjustTextNL(string2);
            n2 = string2.length();
        } while (n > 0 && n2 < cArray.length);
        string2.getChars(0, string2.length(), cArray, 0);
        this.line += Patch.numChars('\n', cArray);
        return string2.equals(string);
    }

    private String adjustTextNL(String string) {
        string = string.replace("\r\n", "\n");
        string = string.replace("\n\r", "\n");
        string = string.replace("\r", "\n");
        return string;
    }

    private static int numChars(char c, char[] cArray) {
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != c) continue;
            ++n;
        }
        return n;
    }

    private static Difference[] parseContextDiff(Reader reader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        ArrayList<Difference> arrayList = new ArrayList<Difference>();
        String string = null;
        do {
            if (string == null || !DIFFERENCE_DELIMETER.equals(string)) {
                while ((string = bufferedReader.readLine()) != null && !DIFFERENCE_DELIMETER.equals(string)) {
                }
            }
            int[] nArray = new int[2];
            string = bufferedReader.readLine();
            if (string == null || !string.startsWith(CONTEXT_MARK1B)) continue;
            try {
                Patch.readNums(string, CONTEXT_MARK1B.length(), nArray);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException(numberFormatException.getLocalizedMessage());
            }
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            string = Patch.fillChanges(nArray, bufferedReader, "--- ", arrayList2);
            int[] nArray2 = new int[2];
            if (string == null || !string.startsWith("--- ")) continue;
            try {
                Patch.readNums(string, "--- ".length(), nArray2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException(numberFormatException.getLocalizedMessage());
            }
            ArrayList<Object> arrayList3 = new ArrayList<Object>();
            string = Patch.fillChanges(nArray2, bufferedReader, DIFFERENCE_DELIMETER, arrayList3);
            if (!Patch.changesCountInvariant(arrayList2, arrayList3)) {
                throw new IOException("Diff file format error. Number of new and old file changes in one hunk must be same!");
            }
            Patch.mergeChanges(nArray, nArray2, arrayList2, arrayList3, arrayList);
        } while (string != null);
        return arrayList.toArray(new Difference[arrayList.size()]);
    }

    private static boolean changesCountInvariant(List<Object> list, List<Object> list2) {
        Object object;
        int n = 0;
        Iterator<Object> iterator = list.iterator();
        while (iterator.hasNext()) {
            int[] nArray = (int[])iterator.next();
            if (nArray[2] == 2) {
                ++n;
            }
            object = (String)iterator.next();
        }
        int n2 = 0;
        iterator = list2.iterator();
        while (iterator.hasNext()) {
            object = (int[])iterator.next();
            if (object[2] == 2) {
                ++n2;
            }
            String string = (String)iterator.next();
        }
        return n == n2;
    }

    private static void readNums(String string, int n, int[] nArray) throws NumberFormatException {
        int n2 = string.indexOf(CONTEXT_MARK_DELIMETER, n);
        if (n2 <= 0) {
            throw new NumberFormatException("Missing comma.");
        }
        nArray[0] = Integer.parseInt(string.substring(n, n2).trim());
        n = n2 + 1;
        n2 = string.indexOf(32, n);
        if (n2 <= 0) {
            throw new NumberFormatException("Missing final space.");
        }
        nArray[1] = Integer.parseInt(string.substring(n, n2).trim());
    }

    private static String fillChanges(int[] nArray, BufferedReader bufferedReader, String string, List<Object> list) throws IOException {
        String string2 = bufferedReader.readLine();
        for (int i = nArray[0]; i <= nArray[1] && string2 != null && !string2.startsWith(string); ++i) {
            StringBuffer stringBuffer;
            int[] nArray2;
            if (string2.startsWith(LINE_PREP_ADD)) {
                nArray2 = new int[3];
                nArray2[0] = i;
                nArray2[2] = 1;
                stringBuffer = new StringBuffer();
                stringBuffer.append(string2.substring(LINE_PREP_ADD.length()));
                stringBuffer.append('\n');
                while ((string2 = bufferedReader.readLine()) != null && string2.startsWith(LINE_PREP_ADD)) {
                    stringBuffer.append(string2.substring(LINE_PREP_ADD.length()));
                    stringBuffer.append('\n');
                    ++i;
                }
                nArray2[1] = i;
                list.add(nArray2);
                list.add(stringBuffer.toString());
                continue;
            }
            if (string2.startsWith(LINE_PREP_REMOVE)) {
                nArray2 = new int[3];
                nArray2[0] = i;
                nArray2[2] = 0;
                stringBuffer = new StringBuffer();
                stringBuffer.append(string2.substring(LINE_PREP_REMOVE.length()));
                stringBuffer.append('\n');
                while ((string2 = bufferedReader.readLine()) != null && string2.startsWith(LINE_PREP_REMOVE)) {
                    stringBuffer.append(string2.substring(LINE_PREP_REMOVE.length()));
                    stringBuffer.append('\n');
                    ++i;
                }
                nArray2[1] = i;
                list.add(nArray2);
                list.add(stringBuffer.toString());
                continue;
            }
            if (string2.startsWith(LINE_PREP_CHANGE)) {
                nArray2 = new int[3];
                nArray2[0] = i;
                nArray2[2] = 2;
                stringBuffer = new StringBuffer();
                stringBuffer.append(string2.substring(LINE_PREP_CHANGE.length()));
                stringBuffer.append('\n');
                while ((string2 = bufferedReader.readLine()) != null && string2.startsWith(LINE_PREP_CHANGE)) {
                    stringBuffer.append(string2.substring(LINE_PREP_CHANGE.length()));
                    stringBuffer.append('\n');
                    ++i;
                }
                nArray2[1] = i;
                list.add(nArray2);
                list.add(stringBuffer.toString());
                continue;
            }
            string2 = bufferedReader.readLine();
        }
        return string2;
    }

    private static void mergeChanges(int[] nArray, int[] nArray2, List list, List list2, List<Difference> list3) {
        int n = list.size();
        int n2 = list2.size();
        int n3 = nArray2[0] - nArray[0];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n || n4 < n2) {
            int[] nArray3;
            int[] nArray4;
            boolean bl = true;
            while (bl && n5 < n) {
                nArray4 = (int[])list.get(n5);
                if (n4 < n2 && nArray4[0] + n3 > (nArray3 = (int[])list2.get(n4))[0]) break;
                bl = nArray4[2] == 1 || nArray4[2] == 0;
                if (!bl) continue;
                if (nArray4[2] == 1) {
                    list3.add(new Difference(nArray4[2], nArray4[0] - 1, 0, nArray4[0] + n3, nArray4[1] + n3, (String)list.get(n5 + 1), ""));
                    n3 += nArray4[1] - nArray4[0] + 1;
                } else {
                    list3.add(new Difference(nArray4[2], nArray4[0], nArray4[1], nArray4[0] + n3 - 1, 0, (String)list.get(n5 + 1), ""));
                    n3 -= nArray4[1] - nArray4[0] + 1;
                }
                n5 += 2;
            }
            bl = true;
            while (bl && n4 < n2) {
                nArray4 = (int[])list2.get(n4);
                bl = nArray4[2] == 1 || nArray4[2] == 0;
                if (!bl) continue;
                if (nArray4[2] == 1) {
                    list3.add(new Difference(nArray4[2], nArray4[0] - n3 - 1, 0, nArray4[0], nArray4[1], "", (String)list2.get(n4 + 1)));
                    n3 += nArray4[1] - nArray4[0] + 1;
                } else {
                    list3.add(new Difference(nArray4[2], nArray4[0] - n3, nArray4[1] - n3, nArray4[0] - 1, 0, "", (String)list2.get(n4 + 1)));
                    n3 -= nArray4[1] - nArray4[0] + 1;
                }
                n4 += 2;
            }
            if (n5 >= n || n4 >= n2 || (nArray4 = (int[])list.get(n5))[2] != 2) continue;
            nArray3 = (int[])list2.get(n4);
            list3.add(new Difference(nArray4[2], nArray4[0], nArray4[1], nArray3[0], nArray3[1], (String)list.get(n5 + 1), (String)list2.get(n4 + 1)));
            n5 += 2;
            n4 += 2;
            n3 += nArray3[1] - nArray3[0] - (nArray4[1] - nArray4[0]);
        }
    }

    private static Difference[] parseUnifiedDiff(Reader reader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        ArrayList<Difference> arrayList = new ArrayList<Difference>();
        String string = null;
        while (true) {
            if (!(string != null && string.startsWith(UNIFIED_MARK) && string.length() > UNIFIED_MARK.length() && string.endsWith(UNIFIED_MARK) || (string = bufferedReader.readLine()) == null)) {
                continue;
            }
            if (string != null) {
                int[] nArray = new int[4];
                try {
                    Patch.readUnifiedNums(string, UNIFIED_MARK.length(), nArray);
                }
                catch (NumberFormatException numberFormatException) {
                    IOException iOException = new IOException("Can not parse: " + string);
                    iOException.initCause(numberFormatException);
                    throw iOException;
                }
                string = Patch.fillUnidifChanges(nArray, bufferedReader, arrayList);
            }
            if (string == null) break;
        }
        return arrayList.toArray(new Difference[arrayList.size()]);
    }

    private static void readUnifiedNums(String string, int n, int[] nArray) throws NumberFormatException {
        while (string.charAt(n) == ' ' || string.charAt(n) == '-') {
            ++n;
        }
        int n2 = string.indexOf(CONTEXT_MARK_DELIMETER, n);
        if (n2 <= 0) {
            throw new NumberFormatException("Missing comma.");
        }
        nArray[0] = Integer.parseInt(string.substring(n, n2).trim());
        n = n2 + 1;
        n2 = string.indexOf(32, n);
        if (n2 <= 0) {
            throw new NumberFormatException("Missing middle space.");
        }
        nArray[1] = Integer.parseInt(string.substring(n, n2).trim());
        n = n2 + 1;
        while (string.charAt(n) == ' ' || string.charAt(n) == '+') {
            ++n;
        }
        n2 = string.indexOf(CONTEXT_MARK_DELIMETER, n);
        if (n2 <= 0) {
            throw new NumberFormatException("Missing second comma.");
        }
        nArray[2] = Integer.parseInt(string.substring(n, n2).trim());
        n = n2 + 1;
        n2 = string.indexOf(32, n);
        if (n2 <= 0) {
            throw new NumberFormatException("Missing final space.");
        }
        nArray[3] = Integer.parseInt(string.substring(n, n2).trim());
        nArray[1] = nArray[1] + (nArray[0] - 1);
        nArray[3] = nArray[3] + (nArray[2] - 1);
    }

    private static String fillUnidifChanges(int[] nArray, BufferedReader bufferedReader, List<Difference> list) throws IOException {
        String string = bufferedReader.readLine();
        int n = nArray[0];
        int n2 = nArray[2];
        while (string != null && n <= nArray[1] && n2 <= nArray[3]) {
            Difference difference;
            Difference difference2;
            StringBuffer stringBuffer;
            int n3;
            if (string.startsWith(LINE_PREP_UNIF_ADD)) {
                n3 = n2;
                stringBuffer = new StringBuffer();
                stringBuffer.append(string.substring(LINE_PREP_UNIF_ADD.length()));
                stringBuffer.append('\n');
                while (true) {
                    string = bufferedReader.readLine();
                    ++n2;
                    if (!string.startsWith(LINE_PREP_UNIF_ADD)) break;
                    stringBuffer.append(string.substring(LINE_PREP_UNIF_ADD.length()));
                    stringBuffer.append('\n');
                }
                difference2 = null;
                if (list.size() > 0 && 0 == (difference = list.get(list.size() - 1)).getType() && difference.getFirstEnd() == n - 1) {
                    difference2 = new Difference(2, difference.getFirstStart(), difference.getFirstEnd(), n3, n2 - 1, difference.getFirstText(), stringBuffer.toString());
                    list.remove(list.size() - 1);
                }
                if (difference2 == null) {
                    difference2 = new Difference(1, n - 1, 0, n3, n2 - 1, null, stringBuffer.toString());
                }
                list.add(difference2);
                continue;
            }
            if (string.startsWith(LINE_PREP_UNIF_REMOVE)) {
                n3 = n;
                stringBuffer = new StringBuffer();
                stringBuffer.append(string.substring(LINE_PREP_UNIF_REMOVE.length()));
                stringBuffer.append('\n');
                while (true) {
                    string = bufferedReader.readLine();
                    ++n;
                    if (!string.startsWith(LINE_PREP_UNIF_REMOVE)) break;
                    stringBuffer.append(string.substring(LINE_PREP_UNIF_REMOVE.length()));
                    stringBuffer.append('\n');
                }
                difference2 = null;
                if (list.size() > 0 && 1 == (difference = list.get(list.size() - 1)).getType() && difference.getSecondEnd() == n2 - 1) {
                    difference2 = new Difference(2, n3, n - 1, difference.getFirstStart(), difference.getFirstEnd(), stringBuffer.toString(), difference.getFirstText());
                    list.remove(list.size() - 1);
                }
                if (difference2 == null) {
                    difference2 = new Difference(0, n3, n - 1, n2 - 1, 0, stringBuffer.toString(), null);
                }
                list.add(difference2);
                continue;
            }
            string = bufferedReader.readLine();
            ++n;
            ++n2;
        }
        return string;
    }

    private static Difference[] parseNormalDiff(Reader reader) throws IOException {
        String string;
        Pattern pattern;
        try {
            pattern = Pattern.compile("(^[0-9]+(,[0-9]+|)[d][0-9]+$)|(^[0-9]+(,[0-9]+|)[c][0-9]+(,[0-9]+|)$)|(^[0-9]+[a][0-9]+(,[0-9]+|)$)");
        }
        catch (PatternSyntaxException patternSyntaxException) {
            pattern = null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(reader);
        ArrayList<Difference> arrayList = new ArrayList<Difference>();
        while ((string = bufferedReader.readLine()) != null) {
            CmdlineDiffProvider.outputLine(string, pattern, arrayList, stringBuffer, stringBuffer2);
        }
        CmdlineDiffProvider.setTextOnLastDifference(arrayList, stringBuffer, stringBuffer2);
        return arrayList.toArray(new Difference[arrayList.size()]);
    }

    public static class FileDifferences {
        private String fileName;
        private String indexName;
        private Difference[] diffs;

        public FileDifferences(String string, String string2, Difference[] differenceArray) {
            this.fileName = string;
            this.diffs = differenceArray;
            this.indexName = string2;
        }

        public final String getFileName() {
            return this.fileName;
        }

        public final String getIndexName() {
            return this.indexName;
        }

        public final Difference[] getDifferences() {
            return this.diffs;
        }
    }

    private static class SinglePatchReader
    extends Reader {
        private static final int BUFF_SIZE = 512;
        private PushbackReader in;
        private char[] buffer = new char[512];
        private int buffLength = 0;
        private int buffPos = 0;
        private boolean isAtEndOfPatch = false;
        private static final String FILE_INDEX = "Index: ";

        public SinglePatchReader(Reader reader) {
            this.in = new PushbackReader(reader, 512);
        }

        public int read(char[] cArray, int n, int n2) throws IOException {
            int n3 = 0;
            while (n2 > 0) {
                int n4;
                if (n2 < this.buffLength) {
                    n4 = n2;
                    n2 = 0;
                } else if (this.buffLength > 0) {
                    n4 = this.buffLength;
                    n2 -= this.buffLength;
                } else if (this.isAtEndOfPatch) {
                    n2 = 0;
                    n4 = -1;
                } else {
                    this.buffLength = this.readTillEndOfPatch(this.buffer);
                    this.buffPos = 0;
                    if (this.buffLength <= 0) {
                        n4 = -1;
                    } else {
                        n4 = Math.min(n2, this.buffLength);
                        n2 -= n4;
                    }
                }
                if (n4 > 0) {
                    System.arraycopy(this.buffer, this.buffPos, cArray, n, n4);
                    n += n4;
                    this.buffLength -= n4;
                    this.buffPos += n4;
                    n3 += n4;
                    continue;
                }
                n2 = 0;
            }
            if (n3 == 0) {
                n3 = -1;
            }
            return n3;
        }

        private int readTillEndOfPatch(char[] cArray) throws IOException {
            int n = this.in.read(cArray);
            String string = new String(cArray);
            int n2 = 0;
            if (string.startsWith(FILE_INDEX) || (n2 = string.indexOf("\nIndex: ")) >= 0) {
                this.isAtEndOfPatch = true;
            } else {
                n2 = string.lastIndexOf(10);
                if (n2 >= 0) {
                    ++n2;
                }
            }
            if (n2 >= 0 && n2 < n) {
                this.in.unread(cArray, n2, n - n2);
                n = n2;
            }
            if (n2 == 0) {
                n = -1;
            }
            return n;
        }

        public void close() throws IOException {
        }

        private boolean hasNextPatch(int[] nArray, String[] stringArray) throws IOException {
            int n;
            Pattern pattern;
            this.isAtEndOfPatch = false;
            PushbackReader pushbackReader = this.in;
            char[] cArray = new char[Patch.DIFFERENCE_DELIMETER.length()];
            boolean bl = false;
            try {
                pattern = Pattern.compile("(^[0-9]+(,[0-9]+|)[d][0-9]+$)|(^[0-9]+(,[0-9]+|)[c][0-9]+(,[0-9]+|)$)|(^[0-9]+[a][0-9]+(,[0-9]+|)$)");
            }
            catch (PatternSyntaxException patternSyntaxException) {
                pattern = null;
            }
            while ((n = pushbackReader.read(cArray)) > 0) {
                int n2;
                char c;
                int n3;
                char c2;
                String string = new String(cArray, 0, n);
                int n4 = string.indexOf(10);
                int n5 = string.indexOf(13);
                int n6 = n4 < 0 ? n5 : n4;
                if (n6 >= 0) {
                    string = n4 > 0 && n4 == n5 + 1 ? string.substring(0, n6 - 1) : string.substring(0, n6);
                    if (n6 + 1 < n) {
                        pushbackReader.unread(cArray, n6 + 1, n - (n6 + 1));
                        n = n6 + 1;
                    }
                }
                if (string.equals(Patch.DIFFERENCE_DELIMETER)) {
                    nArray[0] = 0;
                    pushbackReader.unread(cArray, 0, n);
                    return true;
                }
                if (string.startsWith("@@ ")) {
                    nArray[0] = 2;
                    pushbackReader.unread(cArray, 0, n);
                    return true;
                }
                if (string.startsWith(FILE_INDEX)) {
                    StringBuffer stringBuffer = new StringBuffer(string.substring(FILE_INDEX.length()));
                    if (n6 < 0) {
                        while ((c2 = (char)(n3 = pushbackReader.read())) != '\n' && n3 != -1 && n3 != 13) {
                            stringBuffer.append(c2);
                        }
                    }
                    stringArray[1] = stringBuffer.toString();
                    continue;
                }
                if (string.startsWith(Patch.CONTEXT_MARK1B) || !bl && string.startsWith("--- ")) {
                    StringBuffer stringBuffer;
                    if (string.startsWith(Patch.CONTEXT_MARK1B)) {
                        bl = true;
                        stringBuffer = new StringBuffer(string.substring(Patch.CONTEXT_MARK1B.length()));
                    } else {
                        stringBuffer = new StringBuffer(string.substring("--- ".length()));
                    }
                    String string2 = stringBuffer.toString();
                    c2 = string2.indexOf(9);
                    if (c2 > '\u0000') {
                        stringBuffer = stringBuffer.delete(c2, stringBuffer.length());
                    }
                    if (n6 < 0) {
                        int n7 = 0;
                        char c3 = '\u0000';
                        if (c2 < '\u0000') {
                            while (true) {
                                n7 = pushbackReader.read();
                                char c4 = (char)n7;
                                c3 = c4;
                                if (c4 == '\n' || c3 == 13 || c3 == 9 || n7 == -1) break;
                                stringBuffer.append(c3);
                            }
                        }
                        if (c3 != '\n' && c3 != '\r' && n7 != -1) {
                            char c5;
                            do {
                                n7 = pushbackReader.read();
                                c5 = (char)n7;
                                c3 = c5;
                            } while (c5 != '\n' && c3 != '\r' && n7 != -1);
                        }
                        if (c3 == '\r' && (n7 = pushbackReader.read()) != -1 && (c3 = (char)((char)n7)) != '\n') {
                            pushbackReader.unread(c3);
                        }
                    }
                    stringArray[0] = stringBuffer.toString();
                    continue;
                }
                if (pattern != null && pattern.matcher(string).matches()) {
                    nArray[0] = 1;
                    pushbackReader.unread(cArray, 0, n);
                    return true;
                }
                if (n6 >= 0) continue;
                do {
                    n2 = pushbackReader.read();
                    c = (char)n2;
                    n3 = c;
                } while (c != '\n' && n3 != 13 && n2 != -1);
                if (n3 != 13 || (n2 = pushbackReader.read()) == -1 || (n3 = (int)((char)n2)) == 10) continue;
                pushbackReader.unread(n3);
            }
            return false;
        }
    }
}

