/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.ui.actions;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.modules.hudson.api.ConnectionBuilder;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.api.HudsonJobBuild;
import org.netbeans.modules.hudson.api.HudsonMavenModuleBuild;
import org.netbeans.modules.hudson.ui.actions.Hyperlinker;
import org.openide.awt.HtmlBrowser;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ShowFailures
extends AbstractAction
implements Runnable {
    private static final Logger LOG = Logger.getLogger(ShowFailures.class.getName());
    private final HudsonJob job;
    private final String url;
    private final String displayName;

    public ShowFailures(HudsonJobBuild hudsonJobBuild) {
        this(hudsonJobBuild.getJob(), hudsonJobBuild.getUrl(), hudsonJobBuild.getDisplayName());
    }

    public ShowFailures(HudsonMavenModuleBuild hudsonMavenModuleBuild) {
        this(hudsonMavenModuleBuild.getBuild().getJob(), hudsonMavenModuleBuild.getUrl(), hudsonMavenModuleBuild.getBuildDisplayName());
    }

    private ShowFailures(HudsonJob hudsonJob, String string, String string2) {
        this.job = hudsonJob;
        this.url = string;
        this.displayName = string2;
        this.putValue("Name", NbBundle.getMessage(ShowFailures.class, (String)"ShowFailures.label"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        new RequestProcessor(this.url + "testReport").post((Runnable)this);
    }

    public void run() {
        try {
            XMLReader xMLReader = XMLUtil.createXMLReader();
            xMLReader.setContentHandler(new DefaultHandler(){
                InputOutput io;
                StringBuilder buf;
                Hyperlinker hyperlinker;
                Stack<Suite> suites;
                boolean firstLine;
                {
                    this.hyperlinker = new Hyperlinker(ShowFailures.this.job);
                    this.suites = new Stack();
                    this.firstLine = true;
                }

                private void prepareOutput() {
                    if (this.io == null) {
                        String string = NbBundle.getMessage(ShowFailures.class, (String)"ShowFailures.title", (Object)ShowFailures.this.displayName);
                        this.io = IOProvider.getDefault().getIO(string, new Action[0]);
                        this.io.select();
                    }
                }

                public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
                    if (string3.matches("errorStackTrace|stdout|stderr|name|className")) {
                        this.buf = new StringBuilder();
                    } else if (string3.equals("suite")) {
                        this.suites.push(new Suite());
                    } else if (string3.equals("case") && !this.suites.empty()) {
                        this.suites.peek().cases.push(new Case());
                    }
                }

                public void characters(char[] cArray, int n, int n2) throws SAXException {
                    if (this.buf != null) {
                        this.buf.append(cArray, n, n2);
                    }
                }

                public void endElement(String string, String string2, String string3) throws SAXException {
                    if (this.suites.empty()) {
                        return;
                    }
                    Suite suite = this.suites.peek();
                    String string4 = this.buf != null && this.buf.length() > 0 ? this.buf.toString() : null;
                    this.buf = null;
                    if (suite.cases.empty()) {
                        if (string3.equals("stdout")) {
                            suite.stdout = string4;
                        } else if (string3.equals("stderr")) {
                            suite.stderr = string4;
                        } else if (string3.equals("name")) {
                            suite.name = string4;
                        }
                    } else {
                        Case case_ = suite.cases.peek();
                        if (string3.equals("errorStackTrace")) {
                            case_.errorStackTrace = string4;
                        } else if (string3.equals("name")) {
                            case_.name = string4;
                        } else if (string3.equals("className")) {
                            case_.className = string4;
                        }
                    }
                    if (string3.equals("suite")) {
                        try {
                            this.show(suite);
                        }
                        catch (IOException iOException) {
                            LOG.log(Level.FINE, null, iOException);
                        }
                        this.suites.pop();
                    } else if (string3.equals("case")) {
                        suite.casesDone.add(suite.cases.pop());
                    }
                }

                void show(Suite suite) throws IOException {
                    this.prepareOutput();
                    OutputWriter outputWriter = this.io.getOut();
                    OutputWriter outputWriter2 = this.io.getErr();
                    for (final Case case_ : suite.casesDone) {
                        if (case_.errorStackTrace == null) continue;
                        String string = case_.className + "." + case_.name;
                        if (suite.name != null && !suite.name.equals(case_.className)) {
                            string = NbBundle.getMessage(ShowFailures.class, (String)"ShowFailures.from_suite", (Object)string, (Object)suite.name);
                        }
                        this.println();
                        outputWriter.println(string, new OutputListener(){

                            public void outputLineAction(OutputEvent outputEvent) {
                                try {
                                    HtmlBrowser.URLDisplayer.getDefault().showURL(new URL(ShowFailures.this.url + "testReport/" + case_.className.replaceFirst("[.][^.]+$", "") + "/" + case_.className.replaceFirst(".+[.]", "") + "/" + case_.name + "/"));
                                }
                                catch (MalformedURLException malformedURLException) {
                                    LOG.log(Level.FINE, null, malformedURLException);
                                }
                            }

                            public void outputLineSelected(OutputEvent outputEvent) {
                            }

                            public void outputLineCleared(OutputEvent outputEvent) {
                            }
                        });
                        this.show(case_.errorStackTrace, outputWriter);
                    }
                    if (suite.stderr != null || suite.stdout != null) {
                        this.println();
                        this.show(suite.stderr, outputWriter2);
                        this.show(suite.stdout, outputWriter);
                    }
                }

                void println() {
                    if (this.firstLine) {
                        this.firstLine = false;
                    } else {
                        this.io.getOut().println();
                    }
                }

                void show(String string, OutputWriter outputWriter) {
                    if (string == null) {
                        return;
                    }
                    for (String string2 : string.split("\r\n?|\n")) {
                        this.hyperlinker.handleLine(string2, outputWriter);
                    }
                }

                public void endDocument() throws SAXException {
                    if (this.io != null) {
                        this.io.getOut().close();
                        this.io.getErr().close();
                    }
                }

                class Case {
                    String className;
                    String name;
                    String errorStackTrace;

                    Case() {
                    }
                }

                class Suite {
                    String name;
                    String stdout;
                    String stderr;
                    Stack<Case> cases = new Stack();
                    List<Case> casesDone = new ArrayList<Case>();

                    Suite() {
                    }
                }
            });
            String string = this.url + "testReport/api/xml?xpath=//suite[case/errorStackTrace]&wrapper=failures";
            InputSource inputSource = new InputSource(new ConnectionBuilder().job(this.job).url(string).connection().getInputStream());
            inputSource.setSystemId(string);
            xMLReader.parse(inputSource);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Toolkit.getDefaultToolkit().beep();
        }
        catch (Exception exception) {
            Toolkit.getDefaultToolkit().beep();
            LOG.log(Level.INFO, null, exception);
        }
    }
}

