/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.ui.actions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.hudson.api.HudsonInstance;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.impl.HudsonManagerImpl;
import org.netbeans.modules.hudson.spi.ProjectHudsonJobCreatorFactory;
import org.netbeans.modules.hudson.spi.ProjectHudsonProvider;
import org.netbeans.modules.hudson.ui.wizard.InstanceDialog;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.DialogDescriptor;
import org.openide.NotificationLineSupport;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class CreateJobPanel
extends JPanel
implements ChangeListener {
    private Set<String> takenNames;
    private NotificationLineSupport notifications;
    private DialogDescriptor descriptor;
    private Set<Project> manuallyAddedProjects = new HashSet<Project>();
    ProjectHudsonJobCreatorFactory.ProjectHudsonJobCreator creator;
    HudsonInstance instance;
    private JButton addServer;
    private JButton browse;
    private JPanel custom;
    private JLabel explanationLabel;
    private JTextField name;
    private JLabel nameLabel;
    private JComboBox project;
    private JLabel projectLabel;
    private JComboBox server;
    private JLabel serverLabel;

    CreateJobPanel() {
    }

    void init(DialogDescriptor dialogDescriptor, HudsonInstance hudsonInstance) {
        this.descriptor = dialogDescriptor;
        this.notifications = dialogDescriptor.createNotificationLineSupport();
        this.initComponents();
        this.updateServerModel();
        this.instance = hudsonInstance;
        this.server.setSelectedItem(hudsonInstance);
        this.server.setRenderer(new ServerRenderer());
        this.updateProjectModel();
        this.project.setSelectedItem(this.project.getItemCount() > 0 ? this.project.getItemAt(0) : null);
        this.project.setRenderer(new ProjectRenderer());
        this.name.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                CreateJobPanel.this.check();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                CreateJobPanel.this.check();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
    }

    public void addNotify() {
        super.addNotify();
        this.project.requestFocusInWindow();
        this.check();
    }

    private void check() {
        JButton jButton;
        ProjectHudsonJobCreatorFactory.ConfigurationStatus configurationStatus;
        this.descriptor.setValid(false);
        this.notifications.clearMessages();
        if (this.instance == null) {
            this.notifications.setInformationMessage(NbBundle.getMessage(CreateJobPanel.class, (String)"CreateJobPanel.pick_server"));
            return;
        }
        Project project = this.selectedProject();
        if (project == null) {
            this.notifications.setInformationMessage(NbBundle.getMessage(CreateJobPanel.class, (String)"CreateJobPanel.pick_project"));
            return;
        }
        if (this.creator == null) {
            this.notifications.setErrorMessage(NbBundle.getMessage(CreateJobPanel.class, (String)"CreateJobPanel.unknown_project_type"));
            return;
        }
        if (this.takenNames.contains(this.name())) {
            this.notifications.setErrorMessage(NbBundle.getMessage(CreateJobPanel.class, (String)"CreateJobPanel.name_taken"));
            return;
        }
        if (ProjectHudsonProvider.getDefault().findAssociation(project) != null) {
            this.notifications.setWarningMessage(NbBundle.getMessage(CreateJobPanel.class, (String)"CreateJobPanel.already_associated"));
        }
        if ((configurationStatus = this.creator.status()).getErrorMessage() != null) {
            this.notifications.setErrorMessage(configurationStatus.getErrorMessage());
            return;
        }
        if (configurationStatus.getWarningMessage() != null) {
            this.notifications.setWarningMessage(configurationStatus.getWarningMessage());
        }
        if ((jButton = configurationStatus.getExtraButton()) != null) {
            this.descriptor.setAdditionalOptions(new Object[]{jButton});
            this.descriptor.setClosingOptions(new Object[]{jButton, NotifyDescriptor.CANCEL_OPTION});
        } else {
            this.descriptor.setAdditionalOptions(new Object[0]);
            this.descriptor.setClosingOptions(new Object[]{NotifyDescriptor.CANCEL_OPTION});
        }
        this.descriptor.setValid(true);
    }

    String name() {
        return this.name.getText();
    }

    Project selectedProject() {
        return (Project)this.project.getSelectedItem();
    }

    private void updateServerModel() {
        this.server.setModel(new DefaultComboBoxModel<Object>(HudsonManagerImpl.getDefault().getInstances().toArray()));
    }

    private void computeTakenNames() {
        this.takenNames = new HashSet<String>();
        if (this.instance != null) {
            for (HudsonJob hudsonJob : this.instance.getJobs()) {
                this.takenNames.add(hudsonJob.getName());
            }
        }
    }

    private void updateProjectModel() {
        TreeSet<Project> treeSet = new TreeSet<Project>(new Comparator<Project>(){
            Collator COLL = Collator.getInstance();

            @Override
            public int compare(Project project, Project project2) {
                int n = this.COLL.compare(ProjectUtils.getInformation((Project)project).getDisplayName(), ProjectUtils.getInformation((Project)project2).getDisplayName());
                if (n != 0) {
                    return n;
                }
                return project == project2 ? 0 : project.hashCode() - project2.hashCode();
            }
        });
        treeSet.addAll(Arrays.asList(OpenProjects.getDefault().getOpenProjects()));
        treeSet.addAll(this.manuallyAddedProjects);
        this.project.setModel(new DefaultComboBoxModel<Project>(treeSet.toArray(new Project[treeSet.size()])));
    }

    private void initComponents() {
        this.serverLabel = new JLabel();
        this.server = new JComboBox();
        this.addServer = new JButton();
        this.nameLabel = new JLabel();
        this.name = new JTextField();
        this.projectLabel = new JLabel();
        this.project = new JComboBox();
        this.browse = new JButton();
        this.custom = new JPanel();
        this.explanationLabel = new JLabel();
        this.serverLabel.setLabelFor(this.server);
        Mnemonics.setLocalizedText((JLabel)this.serverLabel, (String)NbBundle.getMessage(CreateJobPanel.class, (String)"CreateJobPanel.serverLabel.text"));
        this.server.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CreateJobPanel.this.serverActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.addServer, (String)NbBundle.getMessage(CreateJobPanel.class, (String)"CreateJobPanel.addServer.text"));
        this.addServer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CreateJobPanel.this.addServerActionPerformed(actionEvent);
            }
        });
        this.nameLabel.setLabelFor(this.name);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(CreateJobPanel.class, (String)"CreateJobPanel.nameLabel.text"));
        this.projectLabel.setLabelFor(this.project);
        Mnemonics.setLocalizedText((JLabel)this.projectLabel, (String)NbBundle.getMessage(CreateJobPanel.class, (String)"CreateJobPanel.projectLabel.text"));
        this.project.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CreateJobPanel.this.projectActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.browse, (String)NbBundle.getMessage(CreateJobPanel.class, (String)"CreateJobPanel.browse.text"));
        this.browse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CreateJobPanel.this.browseActionPerformed(actionEvent);
            }
        });
        this.custom.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((JLabel)this.explanationLabel, (String)NbBundle.getMessage(CreateJobPanel.class, (String)"CreateJobPanel.explanationLabel.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.explanationLabel, -1, 483, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.serverLabel).add((Component)this.nameLabel).add((Component)this.projectLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (Component)this.name, -1, 278, Short.MAX_VALUE).add(2, (Component)this.project, 0, 278, Short.MAX_VALUE).add((Component)this.server, 0, 278, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2, false).add((Component)this.addServer, -1, -1, Short.MAX_VALUE).add((Component)this.browse, -1, -1, Short.MAX_VALUE))).add(1, (Component)this.custom, -1, 483, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.serverLabel).add((Component)this.server, -2, -1, -2).add((Component)this.addServer)).addPreferredGap(1).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.nameLabel).add((Component)this.name, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.projectLabel).add((Component)this.project, -2, -1, -2).add((Component)this.browse)).addPreferredGap(1).add((Component)this.custom, -2, 241, -2).addPreferredGap(1).add((Component)this.explanationLabel, -1, 30, Short.MAX_VALUE).addContainerGap()));
        this.server.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CreateJobPanel.class, (String)"CreateJobPanel.server.AccessibleContext.accessibleDescription"));
        this.addServer.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CreateJobPanel.class, (String)"CreateJobPanel.addServer.AccessibleContext.accessibleDescription"));
        this.name.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CreateJobPanel.class, (String)"CreateJobPanel.name.AccessibleContext.accessibleDescription"));
        this.project.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CreateJobPanel.class, (String)"CreateJobPanel.project.AccessibleContext.accessibleDescription"));
        this.browse.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CreateJobPanel.class, (String)"CreateJobPanel.browse.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CreateJobPanel.class, (String)"CreateJobPanel.AccessibleContext.accessibleDescription"));
    }

    private void browseActionPerformed(ActionEvent actionEvent) {
        FileObject fileObject;
        JFileChooser jFileChooser = ProjectChooser.projectChooser();
        jFileChooser.showOpenDialog(this);
        File file = jFileChooser.getSelectedFile();
        if (file != null && (fileObject = FileUtil.toFileObject((File)file)) != null) {
            try {
                Project project = ProjectManager.getDefault().findProject(fileObject);
                if (project != null) {
                    this.manuallyAddedProjects.add(project);
                    this.updateProjectModel();
                    this.project.setSelectedItem(project);
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    private void projectActionPerformed(ActionEvent actionEvent) {
        if (this.creator != null) {
            this.creator.removeChangeListener(this);
        }
        this.creator = null;
        Project project = this.selectedProject();
        if (project == null) {
            this.check();
            return;
        }
        if (project.getClass().getName().equals("org.netbeans.modules.project.ui.LazyProject")) {
            this.updateProjectModel();
            this.project.setSelectedItem(null);
            return;
        }
        for (ProjectHudsonJobCreatorFactory projectHudsonJobCreatorFactory : Lookup.getDefault().lookupAll(ProjectHudsonJobCreatorFactory.class)) {
            this.creator = projectHudsonJobCreatorFactory.forProject(project);
            if (this.creator == null) continue;
            break;
        }
        if (this.creator == null) {
            this.check();
            return;
        }
        this.name.setText(this.creator.jobName());
        this.custom.removeAll();
        this.custom.add(this.creator.customizer());
        this.creator.addChangeListener(this);
        this.check();
    }

    private void serverActionPerformed(ActionEvent actionEvent) {
        this.instance = (HudsonInstance)this.server.getSelectedItem();
        this.computeTakenNames();
        this.check();
    }

    private void addServerActionPerformed(ActionEvent actionEvent) {
        HudsonInstance hudsonInstance = new InstanceDialog().show();
        if (hudsonInstance != null) {
            this.updateServerModel();
            this.instance = hudsonInstance;
            this.server.setSelectedItem(this.instance);
            this.check();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.check();
    }

    private static class ServerRenderer
    extends DefaultListCellRenderer {
        private ServerRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object == null) {
                return super.getListCellRendererComponent((JList<?>)jList, (Object)null, n, bl, bl2);
            }
            return super.getListCellRendererComponent((JList<?>)jList, ((HudsonInstance)object).getName(), n, bl, bl2);
        }
    }

    private static class ProjectRenderer
    extends DefaultListCellRenderer {
        private ProjectRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object == null) {
                return super.getListCellRendererComponent((JList<?>)jList, (Object)null, n, bl, bl2);
            }
            ProjectInformation projectInformation = ProjectUtils.getInformation((Project)((Project)object));
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, projectInformation.getDisplayName(), n, bl, bl2);
            jLabel.setIcon(projectInformation.getIcon());
            return jLabel;
        }
    }
}

