/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.spi;

import java.awt.EventQueue;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.Line;
import org.openide.windows.OutputWriter;

public interface HudsonLogger {
    public HudsonLogSession createSession(HudsonJob var1);

    public static class Helper {
        private static final Logger LOG = Logger.getLogger(HudsonLogger.class.getName());

        public static void openAt(FileObject fileObject, int n, final int n2, final boolean bl) {
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                if (n == -1) {
                    if (bl) {
                        Runnable runnable;
                        final EditorCookie editorCookie = (EditorCookie)dataObject.getLookup().lookup(EditorCookie.class);
                        if (editorCookie != null) {
                            runnable = new Runnable(){

                                public void run() {
                                    try {
                                        editorCookie.openDocument();
                                    }
                                    catch (IOException iOException) {
                                        LOG.log(Level.INFO, null, iOException);
                                    }
                                }
                            };
                        } else {
                            LOG.fine("no EditorCookie found for " + fileObject);
                            final OpenCookie openCookie = (OpenCookie)dataObject.getLookup().lookup(OpenCookie.class);
                            if (openCookie == null) {
                                LOG.fine("no OpenCookie found for " + fileObject);
                                return;
                            }
                            runnable = new Runnable(){

                                public void run() {
                                    openCookie.open();
                                }
                            };
                        }
                        EventQueue.invokeLater(runnable);
                    }
                    return;
                }
                LineCookie lineCookie = (LineCookie)dataObject.getLookup().lookup(LineCookie.class);
                if (lineCookie == null) {
                    LOG.fine("no LineCookie found for " + fileObject);
                    Helper.openAt(fileObject, -1, -1, bl);
                    return;
                }
                try {
                    final Line line = lineCookie.getLineSet().getOriginal(n);
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            line.show(bl ? Line.ShowOpenType.REUSE : Line.ShowOpenType.NONE, bl ? Line.ShowVisibilityType.FOCUS : Line.ShowVisibilityType.FRONT, n2);
                        }
                    });
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    LOG.log(Level.INFO, null, indexOutOfBoundsException);
                }
            }
            catch (IOException iOException) {
                LOG.log(Level.INFO, null, iOException);
            }
        }
    }

    public static interface HudsonLogSession {
        public boolean handle(String var1, OutputWriter var2);
    }
}

