/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.debugger;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.debugger.registry.ContextAwareServiceHandler;
import org.netbeans.spi.debugger.ContextAwareService;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public final class ContextAwareSupport {
    private ContextAwareSupport() {
    }

    /*
     * WARNING - void declaration
     */
    public static Object createInstance(String string, ContextProvider contextProvider) {
        try {
            ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            String string2 = null;
            if (string.endsWith("()")) {
                int n = string.lastIndexOf(46);
                if (n < 0) {
                    Exceptions.printStackTrace((Throwable)new IllegalStateException("Bad service - dot before method name is missing: '" + string + "'."));
                    return null;
                }
                string2 = string.substring(n + 1, string.length() - 2).trim();
                string = string.substring(0, n);
            }
            Class<?> clazz = classLoader.loadClass(string);
            Object object = null;
            if (string2 != null) {
                void var6_16;
                void var6_14;
                Object object2 = null;
                if (contextProvider != null) {
                    try {
                        Method method = clazz.getDeclaredMethod(string2, ContextProvider.class);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                if (var6_14 == null) {
                    try {
                        Method method = clazz.getDeclaredMethod(string2, new Class[0]);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                if (var6_16 != null) {
                    Object[] objectArray;
                    if (var6_16.getParameterTypes().length == 0) {
                        objectArray = new Object[]{};
                    } else {
                        Object[] objectArray2 = new Object[1];
                        objectArray = objectArray2;
                        objectArray2[0] = contextProvider;
                    }
                    object = var6_16.invoke(null, objectArray);
                }
            }
            if (object == null && contextProvider != null) {
                for (Constructor<?> constructor : clazz.getConstructors()) {
                    if (constructor.getParameterTypes().length != 1 || !ContextProvider.class.isAssignableFrom(constructor.getParameterTypes()[0])) continue;
                    try {
                        object = constructor.newInstance(contextProvider);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)illegalAccessException, (String)("service: " + string)));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)illegalArgumentException, (String)("service: " + string)));
                    }
                }
            }
            if (object == null) {
                object = clazz.newInstance();
            }
            if (Logger.getLogger(ContextAwareSupport.class.getName()).isLoggable(Level.FINE)) {
                Logger.getLogger(ContextAwareSupport.class.getName()).fine("instance " + object + " created.");
            }
            return object;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)classNotFoundException, (String)("The service " + string + " not found.")));
        }
        catch (InstantiationException instantiationException) {
            Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)instantiationException, (String)("The service " + string + " can not be instantiated.")));
        }
        catch (IllegalAccessException illegalAccessException) {
            Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)illegalAccessException, (String)("The service " + string + " can not be accessed.")));
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getCause() instanceof ThreadDeath) {
                throw (ThreadDeath)invocationTargetException.getCause();
            }
            Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)invocationTargetException, (String)("The service " + string + " can not be created.")));
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)exceptionInInitializerError, (String)("The service " + string + " can not be initialized.")));
        }
        return null;
    }

    static ContextAwareService createService(Map map) throws ClassNotFoundException {
        String string = (String)map.get("serviceName");
        String string2 = (String)map.get("serviceClasses");
        if (string2 == null) {
            string2 = (String)map.get("instanceOf");
        }
        String[] stringArray = ContextAwareSupport.splitClasses(string2);
        ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        Class[] classArray = new Class[stringArray.length + 1];
        classArray[0] = ContextAwareService.class;
        for (int i = 0; i < stringArray.length; ++i) {
            classArray[i + 1] = Class.forName(stringArray[i], true, classLoader);
        }
        return (ContextAwareService)Proxy.newProxyInstance(classLoader, classArray, (InvocationHandler)new ContextAwareServiceHandler(string, classArray, Collections.EMPTY_MAP));
    }

    private static String[] splitClasses(String string) {
        return string.split("[, ]+");
    }
}

