/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject.rake;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RakeTask
implements Comparable<RakeTask> {
    private final String task;
    private final String description;
    private final String displayName;
    private final List<String> taskParameters = new ArrayList<String>();
    private final List<String> rakeParameters = new ArrayList<String>();
    private Set<RakeTask> children;

    public static RakeTask newNameSpace(String string) {
        return new RakeTask(null, string, null);
    }

    public RakeTask(String string, String string2, String string3) {
        this.task = string;
        this.displayName = string2;
        this.description = string3;
    }

    boolean isNameSpace() {
        return this.task == null;
    }

    public void addRakeParameters(String ... stringArray) {
        for (String string : stringArray) {
            this.rakeParameters.add(string);
        }
    }

    public void addTaskParameters(String ... stringArray) {
        for (String string : stringArray) {
            this.taskParameters.add(string);
        }
    }

    List<String> getTaskParameters() {
        return this.taskParameters;
    }

    List<String> getRakeParameters() {
        return this.rakeParameters;
    }

    public String getTask() {
        return this.task;
    }

    public Set<RakeTask> getChildren() {
        return this.children;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void addChild(RakeTask rakeTask) {
        if (this.children == null) {
            this.children = new TreeSet<RakeTask>();
        }
        this.children.add(rakeTask);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RakeTask rakeTask = (RakeTask)object;
        return this.task == rakeTask.task || this.task != null && this.task.equals(rakeTask.task);
    }

    public int hashCode() {
        int n = 7;
        n = 59 * n + (this.task != null ? this.task.hashCode() : 0);
        return n;
    }

    @Override
    public int compareTo(RakeTask rakeTask) {
        if (this.isNameSpace() && !rakeTask.isNameSpace()) {
            return -1;
        }
        if (!this.isNameSpace() && rakeTask.isNameSpace()) {
            return 1;
        }
        if (this.task == null || rakeTask.getTask() == null) {
            assert (this.displayName != null) : "displayName not null";
            assert (rakeTask.getDisplayName() != null) : "other displayName not null";
            return this.displayName.compareTo(rakeTask.getDisplayName());
        }
        return this.getTask().compareTo(rakeTask.getTask());
    }

    public String toString() {
        return "RakeTask[task: " + this.getTask() + ", displayName: " + this.getDisplayName() + ", description: " + this.getDescription() + ']';
    }
}

