/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.platform.PlatformComponentFactory;
import org.netbeans.modules.ruby.platform.RubyPreferences;
import org.netbeans.modules.ruby.rubyproject.RubyBaseProject;
import org.netbeans.modules.ruby.rubyproject.RubyTestingSettings;
import org.netbeans.modules.ruby.rubyproject.spi.TestRunner;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

public final class Util {
    private static final String LAST_PLATFORM_ID = "projectPanelLastPlatformID";
    private static final Logger USG_LOGGER = Logger.getLogger("org.netbeans.ui.metrics.ruby");

    private Util() {
    }

    public static RubyBaseProject inferRubyProject() {
        RubyBaseProject rubyBaseProject;
        Lookup lookup;
        Lookup lookup2;
        Lookup lookup3 = WindowManager.getDefault().getRegistry().getActivatedNodes();
        if (lookup3 != null) {
            lookup2 = lookup3;
            int n = ((Lookup)lookup2).length;
            for (int i = 0; i < n; ++i) {
                lookup = lookup2[i];
                Project[] projectArray = Util.lookupRubyBaseProject(lookup.getLookup());
                if (projectArray == null) continue;
                return projectArray;
            }
        }
        if ((rubyBaseProject = Util.lookupRubyBaseProject(lookup2 = Utilities.actionsGlobalContext())) != null) {
            return rubyBaseProject;
        }
        FileObject fileObject = (FileObject)lookup2.lookup(FileObject.class);
        if (fileObject != null && (rubyBaseProject = Util.lookupRubyBaseProject(FileOwnerQuery.getOwner((FileObject)fileObject))) != null) {
            return rubyBaseProject;
        }
        lookup = OpenProjects.getDefault();
        rubyBaseProject = Util.lookupRubyBaseProject(lookup.getMainProject());
        if (rubyBaseProject != null) {
            return rubyBaseProject;
        }
        for (Project project : lookup.getOpenProjects()) {
            rubyBaseProject = Util.lookupRubyBaseProject(project);
            if (rubyBaseProject == null) continue;
            return rubyBaseProject;
        }
        return null;
    }

    private static RubyBaseProject lookupRubyBaseProject(Project project) {
        if (project != null) {
            return Util.lookupRubyBaseProject(project.getLookup());
        }
        return null;
    }

    private static RubyBaseProject lookupRubyBaseProject(Lookup lookup) {
        RubyBaseProject rubyBaseProject = (RubyBaseProject)lookup.lookup(RubyBaseProject.class);
        if (rubyBaseProject != null) {
            return rubyBaseProject;
        }
        Project project = (Project)lookup.lookup(Project.class);
        if (project != null && (rubyBaseProject = (RubyBaseProject)project.getLookup().lookup(RubyBaseProject.class)) != null) {
            return rubyBaseProject;
        }
        return null;
    }

    public static void preselectWizardPlatform(JComboBox jComboBox) {
        org.netbeans.modules.ruby.platform.Util.preselectPlatform((JComboBox)jComboBox, (String)LAST_PLATFORM_ID);
    }

    public static void storeWizardPlatform(JComboBox jComboBox) {
        RubyPlatform rubyPlatform = PlatformComponentFactory.getPlatform((JComboBox)jComboBox);
        if (rubyPlatform != null) {
            RubyPreferences.getPreferences().put(LAST_PLATFORM_ID, rubyPlatform.getID());
        }
    }

    public static String stripExtension(String string, String string2) {
        int n = string.lastIndexOf(46);
        String string3 = n == -1 ? "" : string.substring(n);
        return string2.equals(string3) ? string.substring(0, n) : string;
    }

    public static String getProjectNameWarning(String string) {
        return RubyUtils.getIdentifierWarning((String)string.replace('-', '_'), (int)0);
    }

    public static void logUsage(Class clazz, String string, Object ... objectArray) {
        Parameters.notNull((CharSequence)"message", (Object)string);
        LogRecord logRecord = new LogRecord(Level.INFO, string);
        logRecord.setLoggerName(USG_LOGGER.getName());
        logRecord.setResourceBundle(NbBundle.getBundle((Class)clazz));
        logRecord.setResourceBundleName(clazz.getPackage().getName() + ".Bundle");
        if (objectArray != null) {
            logRecord.setParameters(objectArray);
        }
        USG_LOGGER.log(logRecord);
    }

    public static TestRunner getTestRunner(TestRunner.TestType testType) {
        if (!RubyTestingSettings.getDefault().useRunner(testType)) {
            return null;
        }
        Collection collection = Lookup.getDefault().lookupAll(TestRunner.class);
        for (TestRunner testRunner : collection) {
            if (!testRunner.supports(testType)) continue;
            return testRunner;
        }
        return null;
    }

    public static boolean isProjectAlready(File file) {
        boolean bl;
        Project project;
        block5: {
            if (!file.exists()) {
                return false;
            }
            assert (file.isDirectory()) : "Directory must be given: " + file;
            project = null;
            bl = false;
            try {
                project = ProjectManager.getDefault().findProject(FileUtil.toFileObject((File)file));
            }
            catch (IOException iOException) {
                bl = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ($assertionsDisabled) break block5;
                throw new AssertionError((Object)"Should not get here");
            }
        }
        return project != null || bl;
    }
}

