/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.editors.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.modules.j2ee.sun.ide.editors.ui.DDTableModel;
import org.netbeans.modules.j2ee.sun.ide.editors.ui.DDTableModelEditor;
import org.netbeans.modules.j2ee.sun.ide.editors.ui.MessageArea;
import org.netbeans.modules.j2ee.sun.ide.editors.ui.MultiLineField;
import org.netbeans.modules.j2ee.sun.ide.editors.ui.SortableDDTableModel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class DDTablePanel
extends JPanel
implements EnhancedCustomPropertyEditor {
    static final ResourceBundle bundle = NbBundle.getBundle(DDTablePanel.class);
    private DDTableModel model;
    private JScrollPane scrollPane;
    private JTable tab;
    private JButton addButton;
    private JButton editButton;
    private JButton removeButton;
    private int sortCol;
    private Dialog editDialog;
    boolean getPropertyValueCalled = false;

    public DDTablePanel(DDTableModel dDTableModel, String[] stringArray) {
        this.initComponents(dDTableModel, stringArray, true, true, true, 500, 70, 12);
    }

    public DDTablePanel(DDTableModel dDTableModel, String[] stringArray, int n) {
        this.initComponents(dDTableModel, stringArray, true, true, true, 500, 70, n);
    }

    public DDTablePanel(DDTableModel dDTableModel, String[] stringArray, boolean bl, boolean bl2) {
        this.initComponents(dDTableModel, stringArray, bl, bl2, true, 500, 70, 12);
    }

    public DDTablePanel(DDTableModel dDTableModel) {
        this.initComponents(dDTableModel, new String[0], false, false, false, 500, 70, 12);
    }

    public DDTablePanel(DDTableModel dDTableModel, String[] stringArray, int n, int n2) {
        this.initComponents(dDTableModel, stringArray, true, true, true, n, n2, 12);
    }

    private void initComponents(DDTableModel dDTableModel, String[] stringArray, boolean bl, boolean bl2, boolean bl3, int n, int n2, int n3) {
        this.model = dDTableModel;
        this.sortCol = -1;
        this.setBorder(new EmptyBorder(n3, n3, n3, n3));
        this.setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane();
        this.tab = new JTable(this.model);
        this.tab.setSelectionMode(0);
        this.scrollPane.setViewportView(this.tab);
        this.add((Component)this.scrollPane, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        this.addButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)bundle.getString("CTL_Add"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DDTablePanel.this.addButtonActionPerformed(actionEvent);
            }
        });
        jPanel.add(this.addButton);
        this.addButton.setVisible(bl);
        this.editButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.editButton, (String)bundle.getString("CTL_Edit"));
        this.editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DDTablePanel.this.editButtonActionPerformed(actionEvent);
            }
        });
        jPanel.add(this.editButton);
        this.removeButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)bundle.getString("CTL_Remove"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DDTablePanel.this.removeButtonActionPerformed(actionEvent);
            }
        });
        jPanel.add(this.removeButton);
        this.removeButton.setEnabled(false);
        this.removeButton.setVisible(bl2);
        this.add((Component)jPanel, "South");
        if (this.model instanceof SortableDDTableModel) {
            this.addMouseListenerToHeader((SortableDDTableModel)this.model);
        }
        this.setHeaderToolTips(stringArray);
        if (bl2 || bl3) {
            this.tab.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!listSelectionEvent.getValueIsAdjusting() && DDTablePanel.this.tab.getRowCount() > 0) {
                        boolean bl = DDTablePanel.this.tab.getSelectedRow() != -1;
                        DDTablePanel.this.removeButton.setEnabled(bl);
                        DDTablePanel.this.editButton.setEnabled(bl);
                    }
                }
            });
        }
        if (bl3) {
            this.tab.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    int n;
                    if (mouseEvent.getClickCount() == 2 && (n = DDTablePanel.this.tab.rowAtPoint(mouseEvent.getPoint())) != -1) {
                        DDTablePanel.this.tab.setRowSelectionInterval(n, n);
                        DDTablePanel.this.editButtonActionPerformed(null);
                    }
                }
            });
        }
        this.editButton.setEnabled(false);
        this.editButton.setVisible(bl3);
        int n4 = this.initColumnSizes();
        if (n4 > n) {
            n = n4;
        }
        this.tab.setPreferredScrollableViewportSize(new Dimension(n, n2));
        this.addAncestorListener(new AListener());
        this.initAccessibility();
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_DDTablePanel"));
        this.addButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_add"));
        this.editButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_edit"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_remove"));
        this.tab.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_DDTable"));
        this.tab.getAccessibleContext().setAccessibleName(this.model.getModelName());
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.tab.getSelectionModel().addListSelectionListener(listSelectionListener);
    }

    public void addVerticalScrollBarAdjustmentListener(AdjustmentListener adjustmentListener) {
        this.scrollPane.getVerticalScrollBar().addAdjustmentListener(adjustmentListener);
    }

    public void setVerticalScrollBarValue(int n) {
        int n2 = this.scrollPane.getVerticalScrollBar().getValue();
        if (n2 != n) {
            this.scrollPane.getVerticalScrollBar().setValue(n);
        }
    }

    public void linkLabel(JLabel jLabel) {
        jLabel.setLabelFor(this.tab);
    }

    public Color getHeaderColor() {
        if (this.tab.getColumnCount() < 1) {
            return Color.black;
        }
        TableColumn tableColumn = this.tab.getColumnModel().getColumn(0);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        Component component = tableCellRenderer.getTableCellRendererComponent(this.tab, tableColumn.getHeaderValue(), false, false, -1, 0);
        return component.getForeground();
    }

    public int getSelectedRow() {
        return this.tab.getSelectedRow();
    }

    public void setSelectedRow(int n) {
        if (n == -1) {
            this.tab.clearSelection();
        } else {
            this.tab.addRowSelectionInterval(n, n);
        }
    }

    private void setHeaderToolTips(String[] stringArray) {
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            TableColumn tableColumn = this.tab.getColumnModel().getColumn(i);
            TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
            DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    JTableHeader jTableHeader;
                    if (jTable != null && (jTableHeader = jTable.getTableHeader()) != null) {
                        this.setForeground(jTableHeader.getForeground());
                        this.setBackground(jTableHeader.getBackground());
                        int n3 = DDTablePanel.this.tab.convertColumnIndexToModel(n2) == DDTablePanel.this.sortCol ? 1 : 0;
                        this.setFont(jTableHeader.getFont().deriveFont(n3));
                    }
                    this.setText(object == null ? "" : object.toString());
                    this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                    return this;
                }
            };
            defaultTableCellRenderer.setHorizontalAlignment(0);
            tableColumn.setHeaderRenderer(defaultTableCellRenderer);
            tableCellRenderer = defaultTableCellRenderer;
            Component component = tableCellRenderer.getTableCellRendererComponent(this.tab, tableColumn.getHeaderValue(), false, false, -1, i);
            if (component == null || !(component instanceof JComponent) || i >= stringArray.length) continue;
            JComponent jComponent = (JComponent)component;
            jComponent.setToolTipText(stringArray[i]);
        }
    }

    private int maxSize(int n) {
        Component component = null;
        int n2 = 0;
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            component = this.tab.getDefaultRenderer(this.model.getColumnClass(n)).getTableCellRendererComponent(this.tab, this.model.getValueAt(i, n), false, false, i, n);
            if (component.getPreferredSize().width <= n2) continue;
            n2 = component.getPreferredSize().width;
        }
        return n2;
    }

    private int initColumnSizes() {
        int n = this.tab.getIntercellSpacing().width * this.model.getColumnCount();
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            TableColumn tableColumn = this.tab.getColumnModel().getColumn(i);
            Component component = tableColumn.getHeaderRenderer().getTableCellRendererComponent(null, tableColumn.getHeaderValue(), false, false, 0, 0);
            int n2 = component.getPreferredSize().width + 6;
            int n3 = this.maxSize(i);
            n += Math.max(n2, n3);
            tableColumn.setPreferredWidth(Math.max(n2, n3));
        }
        return n;
    }

    public void setCellEditor(int n, TableCellEditor tableCellEditor) {
        this.tab.getColumnModel().getColumn(n).setCellEditor(tableCellEditor);
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        this.editRow(this.tab.getSelectedRow(), true);
    }

    private void closeEditDialog() {
        this.editDialog.setVisible(false);
        this.editDialog.dispose();
        this.editDialog = null;
    }

    public void editSelectedRow() {
        this.editRow(this.tab.getSelectedRow(), false);
    }

    private void editRow(final int n, final boolean bl) {
        final DDTableModelEditor dDTableModelEditor = this.model.getEditor();
        final Object object = bl ? this.model.makeNewElement() : this.model.getValueAt(n);
        dDTableModelEditor.setValue(object);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = dDTableModelEditor.getPanel();
        Object var7_7 = null;
        if (var7_7 != null) {
            HelpCtx.setHelpIDString((JComponent)jPanel, (String)var7_7.getHelpID());
        }
        jPanel.add("North", jPanel2);
        jPanel.getAccessibleContext().setAccessibleDescription(jPanel2.getAccessibleContext().getAccessibleDescription());
        String string = bl ? bundle.getString("TTL_ADD") : bundle.getString("TTL_EDIT");
        String string2 = MessageFormat.format(bundle.getString("TTL_DIALOG"), string, this.model.getModelName());
        if (jPanel.getAccessibleContext().getAccessibleDescription() == null) {
            jPanel.getAccessibleContext().setAccessibleDescription(string2);
        }
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jPanel, string2, true, 2, null, 0, null, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() != NotifyDescriptor.OK_OPTION) {
                    if (bl) {
                        DDTablePanel.this.model.newElementCancelled(object);
                    }
                } else {
                    List list = DDTablePanel.this.model.isValueValid(dDTableModelEditor.getValue(), bl ? -1 : n);
                    if (!list.isEmpty()) {
                        Component component = DDTablePanel.this.getErrorComponent("MSG_TableErrors", list);
                        component.getAccessibleContext().setAccessibleDescription(DDTablePanel.this.getA11yText(list));
                        NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)component, MessageFormat.format(bundle.getString("TTL_DIALOG"), bundle.getString("TTL_ERROR"), DDTablePanel.this.model.getModelName()), 2, 0, new Object[]{NotifyDescriptor.OK_OPTION}, null);
                        DialogDisplayer.getDefault().notify(notifyDescriptor);
                        return;
                    }
                    if (!bl) {
                        if (!DDTablePanel.this.model.isEditValid(dDTableModelEditor.getValue(), n)) {
                            return;
                        }
                        int[] nArray = DDTablePanel.this.tab.getSelectedRows();
                        DDTablePanel.this.tab.clearSelection();
                        DDTablePanel.this.model.setValueAt(n, dDTableModelEditor.getValue());
                        if (nArray != null) {
                            for (int i = 0; i < nArray.length; ++i) {
                                DDTablePanel.this.tab.setRowSelectionInterval(nArray[i], nArray[i]);
                            }
                        }
                    } else {
                        DDTablePanel.this.model.addRowAt(n >= DDTablePanel.this.model.getRowCount() ? DDTablePanel.this.model.getRowCount() - 1 : n, object, dDTableModelEditor.getValue());
                    }
                }
                DDTablePanel.this.closeEditDialog();
            }
        });
        dialogDescriptor.setClosingOptions(new Object[0]);
        JButton jButton = new JButton(bundle.getString("LBL_Cancel"));
        jButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_Cancel"));
        jButton.setVerifyInputWhenFocusTarget(false);
        dialogDescriptor.setOptions(new Object[]{NotifyDescriptor.OK_OPTION, jButton});
        this.editDialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        this.editDialog.setVisible(true);
    }

    private void editButtonActionPerformed(ActionEvent actionEvent) {
        this.editRow(this.tab.getSelectedRow(), false);
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        Object object;
        int n = this.tab.getSelectedRow();
        List list = this.model.canRemoveRow(n);
        if (!list.isEmpty()) {
            object = this.getErrorComponent("MSG_RemoveWarning", list);
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation(object, bundle.getString("CTL_Remove") + " " + this.model.getModelName() + " " + bundle.getString("TTL_WARNING"));
            Object[] objectArray = new Object[]{bundle.getString("CTL_Remove"), NotifyDescriptor.CANCEL_OPTION};
            confirmation.setOptions(objectArray);
            Object object2 = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
            if (object2 == NotifyDescriptor.CANCEL_OPTION) {
                return;
            }
        }
        this.tab.removeRowSelectionInterval(n, n);
        object = this.model.getEditor();
        object.setValue(this.model.getValueAt(n));
        this.model.removeRowAt(n);
    }

    private Component getErrorComponent(String string, List list) {
        if (list.size() == 1) {
            return new MultiLineField((String)list.get(0));
        }
        MessageArea messageArea = new MessageArea();
        Object[] objectArray = new Object[]{this.model.getModelName()};
        messageArea.setText(MessageFormat.format(bundle.getString(string), objectArray));
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            messageArea.appendBulletItem((String)iterator.next());
        }
        return messageArea;
    }

    private String getA11yText(List list) {
        Object[] objectArray = new Object[]{this.model.getModelName()};
        StringBuffer stringBuffer = new StringBuffer(MessageFormat.format(bundle.getString("MSG_TableErrors"), objectArray));
        for (int i = 0; i < list.size(); ++i) {
            stringBuffer.append("\n" + (String)list.get(i));
        }
        return stringBuffer.toString();
    }

    private void addMouseListenerToHeader(final SortableDDTableModel sortableDDTableModel) {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                TableColumnModel tableColumnModel = DDTablePanel.this.tab.getColumnModel();
                int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                int n2 = DDTablePanel.this.tab.convertColumnIndexToModel(n);
                if (mouseEvent.getClickCount() == 1 && n2 != -1) {
                    sortableDDTableModel.setSortColumn(DDTablePanel.this.sortCol = n2);
                }
            }
        };
        JTableHeader jTableHeader = this.tab.getTableHeader();
        jTableHeader.addMouseListener(mouseAdapter);
    }

    public Object getPropertyValue() throws IllegalStateException {
        this.getPropertyValueCalled = true;
        return this.model.getValue();
    }

    class AListener
    implements AncestorListener {
        AListener() {
        }

        public void ancestorAdded(AncestorEvent ancestorEvent) {
        }

        public void ancestorMoved(AncestorEvent ancestorEvent) {
        }

        public void ancestorRemoved(AncestorEvent ancestorEvent) {
            if (!DDTablePanel.this.isShowing() && !DDTablePanel.this.getPropertyValueCalled) {
                DDTablePanel.this.model.editsCancelled();
            }
        }
    }
}

