/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.threadmap.storage;

import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.netbeans.modules.dlight.core.stack.api.ThreadState;
import org.netbeans.modules.dlight.core.stack.api.support.ThreadStateMapper;

public final class ThreadStateImpl
implements ThreadState {
    private final byte[] stateIDs;
    private final byte[] statePercentage;
    private final int size;
    private final long timestamp;
    private final long samplePeriod;
    static ThreadState.MSAState[] collectedStates = new ThreadState.MSAState[]{null, null, null, ThreadState.MSAState.RunningUser, ThreadState.MSAState.RunningSystemCall, ThreadState.MSAState.RunningOther, ThreadState.MSAState.SleepingUserTextPageFault, ThreadState.MSAState.SleepingUserDataPageFault, ThreadState.MSAState.SleepingKernelPageFault, ThreadState.MSAState.WaitingCPU, ThreadState.MSAState.ThreadStopped, ThreadState.MSAState.SleepingUserLock, ThreadState.MSAState.SleepingOther, null, null, null, null, null};

    public ThreadStateImpl(long l, long l2, long[] lArray) {
        int n;
        int n2 = 0;
        this.samplePeriod = l2;
        byte[] byArray = new byte[lArray.length];
        long l3 = 0L;
        for (n = 3; n < lArray.length; ++n) {
            if (lArray[n] <= 0L) continue;
            l3 += lArray[n];
            byArray[n2++] = (byte)n;
        }
        this.size = n2;
        this.stateIDs = new byte[this.size];
        this.statePercentage = new byte[this.size];
        for (n = 0; n < this.size; ++n) {
            this.stateIDs[n] = byArray[n];
            this.statePercentage[n] = (byte)(100.0 * (double)lArray[this.stateIDs[n]] / (double)l3);
        }
        this.timestamp = l;
    }

    public int size() {
        return this.size;
    }

    public ThreadState.MSAState getMSAState(int n, boolean bl) {
        if (n >= this.stateIDs.length) {
            return ThreadState.MSAState.ThreadFinished;
        }
        byte by = this.stateIDs[n];
        assert (by > 2);
        ThreadState.MSAState mSAState = collectedStates[by];
        return bl ? mSAState : ThreadStateMapper.toSimpleState((ThreadState.MSAState)mSAState);
    }

    public byte getState(int n) {
        return this.statePercentage[n];
    }

    public long getTimeStamp(int n) {
        return -1L;
    }

    public long getTimeStamp() {
        return this.timestamp;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("MSA " + this.timestamp);
        stringBuilder.append(" has " + this.size);
        stringBuilder.append(" states\n\tMSA:");
        for (int i = 0; i < this.size(); ++i) {
            stringBuilder.append(" ");
            stringBuilder.append(this.getMSAState(i, true));
            stringBuilder.append("=" + this.getState(i));
        }
        return stringBuilder.toString();
    }

    public int getSamplingStateIndex(boolean bl) {
        EnumMap<ThreadState.MSAState, Object> enumMap = new EnumMap<ThreadState.MSAState, Object>(ThreadState.MSAState.class);
        for (int i = 0; i < this.size; ++i) {
            ThreadState.MSAState mSAState = this.getMSAState(i, bl);
            if (mSAState == null) continue;
            Object object = (AtomicInteger)enumMap.get(mSAState);
            if (object == null) {
                object = new AtomicInteger(this.getState(i));
                enumMap.put(mSAState, object);
                continue;
            }
            ((AtomicInteger)object).addAndGet(this.getState(i));
        }
        ThreadState.MSAState mSAState = null;
        int n = 0;
        for (Map.Entry entry : enumMap.entrySet()) {
            if (((AtomicInteger)entry.getValue()).get() <= n) continue;
            n = ((AtomicInteger)entry.getValue()).get();
            mSAState = (ThreadState.MSAState)entry.getKey();
        }
        if (mSAState != null) {
            for (int i = 0; i < this.size; ++i) {
                ThreadState.MSAState mSAState2 = this.getMSAState(i, bl);
                if (!mSAState.equals((Object)mSAState2)) continue;
                return i;
            }
        }
        return 0;
    }

    public long getMSASamplePeriod() {
        return this.samplePeriod;
    }
}

