/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.debug;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.debug.DebugContext;
import org.jruby.debug.DebugFrame;
import org.jruby.debug.Debugger;
import org.jruby.debug.Util;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.builtin.IRubyObject;

public class Context
extends RubyObject {
    private static final long serialVersionUID = 1L;
    private final Debugger debugger;

    Context(Ruby runtime, RubyClass type, Debugger debugger) {
        super(runtime, type);
        this.debugger = debugger;
    }

    DebugContext debugContext() {
        return (DebugContext)this.dataGetStruct();
    }

    @JRubyMethod(name={"stop_next=", "step"}, required=1, optional=1)
    public IRubyObject stop_next_set(IRubyObject[] args, Block block) {
        Ruby rt = this.getRuntime();
        this.checkStarted();
        IRubyObject force = Arity.checkArgumentCount((Ruby)rt, (IRubyObject[])args, (int)1, (int)2) == 2 ? args[1] : rt.getNil();
        IRubyObject steps = args[0];
        if (RubyFixnum.fix2int((IRubyObject)steps) < 0) {
            rt.newRuntimeError("Steps argument can't be negative.");
        }
        DebugContext debug_context = this.debugContext();
        debug_context.setStopNext(RubyFixnum.fix2int((IRubyObject)steps));
        debug_context.setForceMove(!force.isNil() && force.isTrue());
        return steps;
    }

    @JRubyMethod(name={"step_over"}, required=1, optional=2)
    public IRubyObject step_over(IRubyObject[] rawArgs, Block block) {
        Ruby rt = this.getRuntime();
        this.checkStarted();
        DebugContext debugContext = this.debugContext();
        if (debugContext.getStackSize() == 0) {
            rt.newRuntimeError("No frames collected.");
        }
        IRubyObject[] args = Arity.scanArgs((Ruby)rt, (IRubyObject[])rawArgs, (int)1, (int)2);
        IRubyObject lines = args[0];
        IRubyObject frame = args[1];
        IRubyObject force = args[2];
        debugContext.setStopLine(RubyFixnum.fix2int((IRubyObject)lines));
        debugContext.setStepped(false);
        if (frame.isNil()) {
            debugContext.setDestFrame(debugContext.getStackSize());
        } else {
            int frameInt = this.checkFrameNumber(frame);
            debugContext.setDestFrame(debugContext.getStackSize() - frameInt);
        }
        debugContext.setForceMove(force.isTrue());
        return rt.getNil();
    }

    @JRubyMethod(name={"stop_frame="}, required=1)
    public IRubyObject stop_frame_set(IRubyObject rFrameNo, Block block) {
        this.checkStarted();
        DebugContext debugContext = this.debugContext();
        int frameNo = RubyNumeric.fix2int((IRubyObject)rFrameNo);
        if (frameNo < 0 || frameNo >= debugContext.getStackSize()) {
            this.getRuntime().newRuntimeError("Stop frame is out of range.");
        }
        debugContext.setStopFrame(debugContext.getStackSize() - frameNo);
        return rFrameNo;
    }

    @JRubyMethod(name={"thread"})
    public IRubyObject thread(Block block) {
        this.checkStarted();
        return this.debugContext().getThread();
    }

    @JRubyMethod(name={"thnum"})
    public IRubyObject thnum(Block block) {
        return RubyFixnum.newFixnum((Ruby)this.getRuntime(), (long)this.debugContext().getThnum());
    }

    @JRubyMethod(name={"stop_reason"})
    public IRubyObject stop_reason(Block block) {
        String symName;
        Ruby rt = this.getRuntime();
        this.checkStarted();
        DebugContext debugContext = this.debugContext();
        switch (debugContext.getStopReason()) {
            case STEP: {
                symName = "step";
                break;
            }
            case BREAKPOINT: {
                symName = "breakpoint";
                break;
            }
            case CATCHPOINT: {
                symName = "catchpoint";
                break;
            }
            default: {
                symName = "none";
            }
        }
        if (debugContext.isDead()) {
            symName = "post-mortem";
        }
        return rt.newSymbol(symName);
    }

    @JRubyMethod(name={"suspend"})
    public IRubyObject suspend(Block block) {
        this.checkStarted();
        DebugContext debugContext = this.debugContext();
        if (debugContext.isSuspended()) {
            throw this.getRuntime().newRuntimeError("Already suspended.");
        }
        this.suspend0();
        return this.getRuntime().getNil();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void suspend0() {
        DebugContext debugContext = this.debugContext();
        String status = debugContext.getThread().status().toString();
        if (status.equals("run") || status.equals("sleep")) {
            Context context = this;
            synchronized (context) {
                debugContext.setWasRunning(true);
                debugContext.setSuspended(true);
            }
        }
    }

    @JRubyMethod(name={"suspended?"})
    public IRubyObject suspended_p(Block block) {
        this.checkStarted();
        return this.getRuntime().newBoolean(this.debugContext().isSuspended());
    }

    @JRubyMethod(name={"resume"})
    public IRubyObject resume(Block block) {
        this.checkStarted();
        DebugContext debugContext = this.debugContext();
        if (!debugContext.isSuspended()) {
            throw this.getRuntime().newRuntimeError("Thread is not suspended.");
        }
        this.resume0();
        return this.getRuntime().getNil();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resume0() {
        DebugContext debugContext = this.debugContext();
        Context context = this;
        synchronized (context) {
            debugContext.setSuspended(false);
        }
        if (debugContext.isWasRunning()) {
            debugContext.getThread().wakeup();
        }
    }

    @JRubyMethod(name={"tracing"})
    public IRubyObject tracing(Block block) {
        this.checkStarted();
        DebugContext debugContext = this.debugContext();
        return this.getRuntime().newBoolean(debugContext.isTracing());
    }

    @JRubyMethod(name={"tracing="}, required=1)
    public IRubyObject tracing_set(IRubyObject tracing, Block block) {
        this.checkStarted();
        DebugContext debugContext = this.debugContext();
        debugContext.setTracing(tracing.isTrue());
        return tracing;
    }

    @JRubyMethod(name={"ignored?"})
    public IRubyObject ignored_p(Block block) {
        this.checkStarted();
        return this.getRuntime().newBoolean(this.debugContext().isIgnored());
    }

    @JRubyMethod(name={"frame_args"}, required=1)
    public IRubyObject frame_args(IRubyObject frameNo, Block block) {
        this.checkStarted();
        DebugFrame frame = this.getFrame(frameNo);
        if (frame.isDead()) {
            return frame.getInfo().getCopyArgs();
        }
        return this.contextCopyArgs(frame);
    }

    @JRubyMethod(name={"frame_binding"}, required=1)
    public IRubyObject frame_binding(IRubyObject frameNo, Block block) {
        this.checkStarted();
        return this.getFrame(frameNo).getBinding();
    }

    @JRubyMethod(name={"frame_id", "frame_method"}, required=1)
    public IRubyObject frame_method(IRubyObject frameNo, Block block) {
        this.checkStarted();
        String methodName = this.getFrame(frameNo).getMethodName();
        return methodName == null ? this.getRuntime().getNil() : this.getRuntime().newSymbol(methodName);
    }

    @JRubyMethod(name={"frame_args_info"}, optional=1)
    public IRubyObject frame_args_info(IRubyObject[] args, Block block) {
        this.checkStarted();
        return this.getFrame(args).getArgValues();
    }

    @JRubyMethod(name={"frame_line"}, optional=1)
    public IRubyObject frame_line(IRubyObject[] args, Block block) {
        this.checkStarted();
        return this.getRuntime().newFixnum(this.getFrame(args).getLine());
    }

    @JRubyMethod(name={"frame_file"}, optional=1)
    public IRubyObject frame_file(IRubyObject[] args, Block block) {
        return this.getRuntime().newString(this.getFrame(args).getFile());
    }

    @JRubyMethod(name={"frame_locals"}, required=1)
    public IRubyObject frame_locals(IRubyObject frameNo, Block block) {
        this.checkStarted();
        DebugFrame frame = this.getFrame(frameNo);
        if (frame.isDead()) {
            return frame.getInfo().getCopyLocals();
        }
        return this.contextCopyLocals(frame);
    }

    @JRubyMethod(name={"frame_self"}, required=1)
    public IRubyObject frame_self(IRubyObject frameNo, Block block) {
        this.checkStarted();
        return this.getFrame(frameNo).getSelf();
    }

    @JRubyMethod(name={"frame_class"}, optional=1)
    public IRubyObject frame_class(IRubyObject[] args, Block block) {
        this.checkStarted();
        DebugFrame frame = this.getFrame(args);
        if (frame.isDead()) {
            return this.getRuntime().getNil();
        }
        return frame.getInfo().getFrame().getKlazz();
    }

    @JRubyMethod(name={"stack_size"})
    public IRubyObject stack_size(Block block) {
        this.checkStarted();
        return this.getRuntime().newFixnum(this.debugContext().getStackSize());
    }

    @JRubyMethod(name={"dead?"})
    public IRubyObject dead_p(Block block) {
        this.checkStarted();
        return Util.toRBoolean((IRubyObject)this, this.debugContext().isDead());
    }

    @JRubyMethod(name={"breakpoint"})
    public IRubyObject breakpoint(Block block) {
        this.checkStarted();
        return this.debugContext().getBreakpoint();
    }

    @JRubyMethod(name={"set_breakpoint"}, required=2, optional=1)
    public IRubyObject set_breakpoint(IRubyObject[] args, Block block) {
        this.checkStarted();
        IRubyObject breakpoint = this.debugger.createBreakpointFromArgs((IRubyObject)this, args, 0);
        this.debugContext().setBreakpoint(breakpoint);
        return breakpoint;
    }

    private IRubyObject getFrameNumber(IRubyObject[] args) {
        return args.length == 1 ? args[0] : this.getRuntime().newFixnum(0);
    }

    private DebugFrame getFrame(IRubyObject[] args) {
        return this.getFrame(this.getFrameNumber(args));
    }

    private DebugFrame getFrame(IRubyObject frameNo) {
        DebugContext debugContext = this.debugContext();
        int frameNoInt = this.checkFrameNumber(frameNo);
        return debugContext.getFrame(frameNoInt);
    }

    private int checkFrameNumber(IRubyObject rFrameNo) {
        int frameNo = RubyFixnum.fix2int((IRubyObject)rFrameNo);
        if (frameNo < 0 || frameNo >= this.debugContext().getStackSize()) {
            throw rFrameNo.getRuntime().newArgumentError(String.format("Invalid frame number %d, stack (0...%d)", frameNo, this.debugContext().getStackSize()));
        }
        return frameNo;
    }

    private void checkStarted() {
        this.debugger.checkStarted(this.getRuntime());
    }

    private IRubyObject contextCopyArgs(DebugFrame debugFrame) {
        RubyArray result = this.getRuntime().newArray();
        StaticScope scope = debugFrame.getInfo().getScope();
        int count = scope.getRequiredArgs() + scope.getOptionalArgs();
        if (scope.getRestArg() >= 0) {
            ++count;
        }
        String[] names = scope.getVariables();
        for (int i = 0; i < count; ++i) {
            result.append((IRubyObject)this.getRuntime().newString(names[i]));
        }
        return result;
    }

    private IRubyObject contextCopyLocals(DebugFrame debugFrame) {
        RubyHash locals = RubyHash.newHash((Ruby)this.getRuntime());
        DynamicScope scope = debugFrame.getInfo().getDynaVars();
        if (scope != null) {
            DynamicScope evalScope = scope.getEvalScope();
            if (evalScope != null) {
                scope = evalScope;
            }
            while (scope != null) {
                String[] variableNames = scope.getStaticScope().getVariables();
                if (variableNames != null) {
                    for (int i = 0; i < variableNames.length; ++i) {
                        locals.op_aset(this.getRuntime().getCurrentContext(), (IRubyObject)RubyString.newString((Ruby)this.getRuntime(), (CharSequence)variableNames[i]), scope.getValues()[i]);
                    }
                }
                scope = scope.getNextCapturedScope();
            }
        }
        return locals;
    }
}

