/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.util;

import java.text.NumberFormat;
import java.util.Locale;
import org.netbeans.modules.dlight.util.ValueFormatter;

public final class BytesFormatter
implements ValueFormatter {
    private static final int BINARY_ORDER = 1024;
    private static final int DECIMAL_ORDER = 1000;
    private static final String[] SUFFIXES = new String[]{"b", "K", "M", "G", "T"};
    private static final NumberFormat INT_FORMAT = NumberFormat.getIntegerInstance(Locale.US);
    private static final NumberFormat FRAC_FORMAT = NumberFormat.getNumberInstance(Locale.US);

    public String format(long l) {
        double d = l;
        int n = 0;
        while (1024.0 <= d && n + 1 < SUFFIXES.length) {
            d /= 1024.0;
            ++n;
        }
        if (1000.0 <= d && n + 1 < SUFFIXES.length) {
            d /= 1024.0;
            ++n;
        }
        NumberFormat numberFormat = d < 10.0 ? FRAC_FORMAT : INT_FORMAT;
        return numberFormat.format(d) + SUFFIXES[n];
    }

    static {
        FRAC_FORMAT.setMaximumFractionDigits(1);
    }
}

