/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupportFactory;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.project.classpath.support.ProjectClassPathSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.WeakListeners;

public final class ClassPathProviderImpl
implements ClassPathProvider,
PropertyChangeListener {
    private final AntProjectHelper helper;
    private final File projectDirectory;
    private final PropertyEvaluator evaluator;
    private ClassPath runtimeClassPath = null;
    private ClassPath bootClassPath = null;
    private final Map<String, FileObject> dirCache = new HashMap<String, FileObject>();

    public ClassPathProviderImpl(AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator) {
        this.helper = antProjectHelper;
        this.projectDirectory = FileUtil.toFile((FileObject)antProjectHelper.getProjectDirectory());
        assert (this.projectDirectory != null);
        this.evaluator = propertyEvaluator;
        propertyEvaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)propertyEvaluator));
    }

    private FileObject getDir(final String string) {
        return (FileObject)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<FileObject>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public FileObject run() {
                ClassPathProviderImpl classPathProviderImpl = ClassPathProviderImpl.this;
                synchronized (classPathProviderImpl) {
                    String string2;
                    FileObject fileObject = (FileObject)ClassPathProviderImpl.this.dirCache.get(string);
                    if (!(fileObject != null && fileObject.isValid() || (string2 = ClassPathProviderImpl.this.evaluator.getProperty(string)) == null)) {
                        fileObject = ClassPathProviderImpl.this.helper.resolveFileObject(string2);
                        ClassPathProviderImpl.this.dirCache.put(string, fileObject);
                    }
                    return fileObject;
                }
            }
        });
    }

    private FileObject getDistJar() {
        return this.getDir("dist.jar");
    }

    private FileObject getBuildDir() {
        return this.getDir("build.dir");
    }

    private int getType(FileObject fileObject) {
        FileObject fileObject2 = this.getDistJar();
        if (fileObject2 != null && fileObject2.equals(FileUtil.getArchiveFile((FileObject)fileObject))) {
            return 0;
        }
        fileObject2 = this.getBuildDir();
        if (fileObject2 != null && (fileObject2.equals(fileObject) || FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject))) {
            return 0;
        }
        return -1;
    }

    private synchronized ClassPath getRunTimeClasspath(FileObject fileObject) {
        if (this.getType(fileObject) == -1) {
            return null;
        }
        if (this.runtimeClassPath == null) {
            this.runtimeClassPath = ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])new String[]{"debug.classpath", "j2ee.platform.classpath"}));
        }
        return this.runtimeClassPath;
    }

    private synchronized ClassPath getBootClassPath() {
        if (this.bootClassPath == null) {
            this.bootClassPath = ClassPathFactory.createClassPath((ClassPathImplementation)ClassPathSupportFactory.createBootClassPathImplementation((PropertyEvaluator)this.evaluator));
        }
        return this.bootClassPath;
    }

    public ClassPath findClassPath(FileObject fileObject, String string) {
        if (string.equals("classpath/execute")) {
            return this.getRunTimeClasspath(fileObject);
        }
        if (string.equals("classpath/boot")) {
            return this.getBootClassPath();
        }
        return null;
    }

    public ClassPath[] getProjectClassPaths(String string) {
        if ("classpath/boot".equals(string)) {
            return new ClassPath[]{this.getBootClassPath()};
        }
        assert (false);
        return null;
    }

    public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.dirCache.remove(propertyChangeEvent.getPropertyName());
    }
}

