/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.j2meunit;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.netbeans.spi.mobility.project.support.DefaultPropertyParsers;
import org.netbeans.spi.mobility.project.ui.customizer.support.VisualPropertySupport;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestUtils {
    static final String TEST_CLASSNAME_PREFIX = NbBundle.getMessage(TestUtils.class, (String)"PROP_test_classname_prefix");
    static final String TEST_CLASSNAME_SUFFIX = NbBundle.getMessage(TestUtils.class, (String)"PROP_test_classname_suffix");
    static final String SUITE_CLASSNAME_PREFIX = NbBundle.getMessage(TestUtils.class, (String)"PROP_suite_classname_prefix");
    static final String SUITE_CLASSNAME_SUFFIX = NbBundle.getMessage(TestUtils.class, (String)"PROP_suite_classname_suffix");
    static final boolean GENERATE_TESTS_FROM_TEST_CLASSES = NbBundle.getMessage(TestUtils.class, (String)"PROP_generate_tests_from_test_classes").equals("true");
    static final String TEST_METHODNAME_PREFIX = NbBundle.getMessage(TestUtils.class, (String)"PROP_test_method_prefix");
    static final String TEST_METHODNAME_SUFFIX = NbBundle.getMessage(TestUtils.class, (String)"PROP_test_method_suffix");
    static final String TEST_RUNNER_NAME = "TestRunnerMIDlet";

    public static Set<Modifier> createModifierSet(Modifier ... modifierArray) {
        EnumSet<Modifier> enumSet = EnumSet.noneOf(Modifier.class);
        for (Modifier modifier : modifierArray) {
            enumSet.add(modifier);
        }
        return enumSet;
    }

    public static String getTestClassName(String string) {
        return TEST_CLASSNAME_PREFIX + string + TEST_CLASSNAME_SUFFIX;
    }

    public static String getSimpleName(String string) {
        int n = string.lastIndexOf(46);
        return n == -1 ? string : string.substring(n + 1);
    }

    public static String getPackageName(String string) {
        if (string != null) {
            int n = string.lastIndexOf(46);
            return n != -1 ? string.substring(0, n) : "";
        }
        return "";
    }

    public static String getTestClassFullName(String string, String string2) {
        String string3 = TestUtils.getTestClassName(string);
        return string2 == null || string2.length() == 0 ? string3 : string2.replace('.', '/') + '/' + string3;
    }

    public static String createTestMethodName(String string) {
        return "test" + string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    static void addTestClassProperty(Project project, AntProjectHelper antProjectHelper, String string) throws IOException {
        ProjectConfigurationsHelper projectConfigurationsHelper = (ProjectConfigurationsHelper)project.getLookup().lookup(ProjectConfigurationsHelper.class);
        Collection collection = projectConfigurationsHelper.getConfigurations();
        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
        ReferenceHelper referenceHelper = (ReferenceHelper)project.getLookup().lookup(ReferenceHelper.class);
        String string2 = editableProperties.getProperty("manifest.jad");
        HashMap hashMap = string2 != null ? (HashMap)DefaultPropertyParsers.MANIFEST_PROPERTY_PARSER.decode(string2, antProjectHelper, referenceHelper) : new HashMap();
        TestUtils.addTestClassProperty(hashMap, string);
        editableProperties.put("manifest.jad", DefaultPropertyParsers.MANIFEST_PROPERTY_PARSER.encode((Object)hashMap, antProjectHelper, referenceHelper));
        for (ProjectConfiguration projectConfiguration : collection) {
            String string3;
            String string4 = projectConfiguration.getDisplayName();
            String string5 = VisualPropertySupport.translatePropertyName((String)string4, (String)"manifest.jad", (boolean)false);
            if (string5 == null || (string3 = editableProperties.getProperty(string5)) == null) continue;
            hashMap = (HashMap)DefaultPropertyParsers.MANIFEST_PROPERTY_PARSER.decode(string2, antProjectHelper, referenceHelper);
            TestUtils.addTestClassProperty(hashMap, string);
            editableProperties.put(string5, DefaultPropertyParsers.MANIFEST_PROPERTY_PARSER.encode((Object)hashMap, antProjectHelper, referenceHelper));
        }
        antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
        ProjectManager.getDefault().saveProject(project);
    }

    private static void addTestClassProperty(Map map, String string) {
        String string2 = NbBundle.getMessage(TestUtils.class, (String)"PROP_config_TestClasses_key");
        if (map.containsKey(string2)) {
            String string3 = (String)map.get(string2);
            if (string3.indexOf(string) < 0) {
                string3 = string3 == null || string3.equals("") ? string : string3 + " " + string;
                map.put(string2, string3);
            }
        } else {
            map.put(string2, string);
        }
    }

    static void addTestRunnerMIDletProperty(Project project, AntProjectHelper antProjectHelper) throws IOException {
        String string = NbBundle.getMessage(TestUtils.class, (String)"PROP_config_TestRunner_name");
        String string2 = NbBundle.getMessage(TestUtils.class, (String)"PROP_config_TestRunner_clazz");
        String string3 = NbBundle.getMessage(TestUtils.class, (String)"PROP_config_TestRunner_icon");
        ProjectConfigurationsHelper projectConfigurationsHelper = (ProjectConfigurationsHelper)project.getLookup().lookup(ProjectConfigurationsHelper.class);
        Collection collection = projectConfigurationsHelper.getConfigurations();
        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
        String string4 = editableProperties.getProperty("manifest.midlets");
        HashMap hashMap = string4 != null ? (HashMap)DefaultPropertyParsers.MANIFEST_PROPERTY_PARSER.decode(string4, null, null) : new HashMap();
        TestUtils.addTestRunnerMIDletProperty(hashMap, string, string2, string3);
        editableProperties.put("manifest.midlets", DefaultPropertyParsers.MANIFEST_PROPERTY_PARSER.encode((Object)hashMap, null, null));
        for (ProjectConfiguration projectConfiguration : collection) {
            String string5;
            String string6 = projectConfiguration.getDisplayName();
            String string7 = VisualPropertySupport.translatePropertyName((String)string6, (String)"manifest.midlets", (boolean)false);
            if (string7 == null || (string5 = editableProperties.getProperty(string7)) == null) continue;
            hashMap = (HashMap)DefaultPropertyParsers.MANIFEST_PROPERTY_PARSER.decode(string4, null, null);
            TestUtils.addTestRunnerMIDletProperty(hashMap, string, string2, string3);
            editableProperties.put(string7, DefaultPropertyParsers.MANIFEST_PROPERTY_PARSER.encode((Object)hashMap, null, null));
        }
        antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
        ProjectManager.getDefault().saveProject(project);
    }

    private static void addTestRunnerMIDletProperty(Map map, String string, String string2, String string3) {
        int n = 1;
        boolean bl = false;
        while (map.containsKey("MIDlet-" + n)) {
            String string4 = (String)map.get("MIDlet-" + n);
            if (string4.contains(NbBundle.getMessage(TestUtils.class, (String)"PROP_config_TestRunner_clazz"))) {
                bl = true;
            }
            ++n;
        }
        if (!bl) {
            map.put("MIDlet-" + n, string + ", " + string3 + ", " + string2);
        }
    }

    public static FileObject getTestFileObject(FileObject fileObject) {
        String string = TEST_CLASSNAME_PREFIX + fileObject.getName() + TEST_CLASSNAME_SUFFIX;
        String string2 = FileUtil.toFile((FileObject)fileObject).getAbsolutePath();
        String string3 = string2.substring(string2.indexOf(fileObject.getName()));
        File file = new File(string3 + string + ".java");
        return FileUtil.toFileObject((File)file);
    }

    public static boolean testMethodExists(ClassTree classTree, String string) {
        assert (classTree.getKind() == Tree.Kind.CLASS);
        List<? extends Tree> list = classTree.getMembers();
        for (Tree tree : list) {
            MethodTree methodTree;
            if (!(tree instanceof MethodTree) || !(methodTree = (MethodTree)tree).getName().toString().equals(string)) continue;
            return true;
        }
        return false;
    }

    private static boolean isTestable(ClassTree classTree, TreeUtilities treeUtilities) {
        return !treeUtilities.isAnnotation(classTree);
    }

    static boolean isTestable(FileObject fileObject) {
        return !fileObject.getName().endsWith(TEST_RUNNER_NAME) && !fileObject.getName().endsWith(TEST_CLASSNAME_SUFFIX) && fileObject.getExt().equals("java");
    }

    static boolean isTestable(Element element) {
        ElementKind elementKind = element.getKind();
        return elementKind != ElementKind.ANNOTATION_TYPE && (elementKind.isClass() || elementKind.isInterface());
    }

    static boolean isTestMethod(MethodTree methodTree) {
        String string = methodTree.getName().toString();
        return string.startsWith(NbBundle.getMessage(TestUtils.class, (String)"PROP_test_method_prefix")) && !string.equals(NbBundle.getMessage(TestUtils.class, (String)"PROP_test_method_prefix")) && string.endsWith(NbBundle.getMessage(TestUtils.class, (String)"PROP_test_method_suffix"));
    }

    private static List<TypeElement> findTopClassElems(CompilationInfo compilationInfo, CompilationUnitTree compilationUnitTree) {
        List<? extends Tree> list = compilationUnitTree.getTypeDecls();
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TypeElement> arrayList = new ArrayList<TypeElement>(list.size());
        Trees trees = compilationInfo.getTrees();
        for (Tree tree : list) {
            if (tree.getKind() != Tree.Kind.CLASS) continue;
            Element element = trees.getElement(new TreePath(new TreePath(compilationUnitTree), tree));
            TypeElement typeElement = (TypeElement)element;
            if (!TestUtils.isTestable(element)) continue;
            arrayList.add(typeElement);
        }
        return arrayList;
    }

    private static List<ElementHandle<TypeElement>> findTopClassElemHandles(CompilationInfo compilationInfo, CompilationUnitTree compilationUnitTree) {
        return TestUtils.getElemHandles(TestUtils.findTopClassElems(compilationInfo, compilationUnitTree));
    }

    private static <T extends Element> List<ElementHandle<T>> getElemHandles(List<T> list) {
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ElementHandle<T>> arrayList = new ArrayList<ElementHandle<T>>(list.size());
        for (Element element : list) {
            arrayList.add(ElementHandle.create((Element)element));
        }
        return arrayList;
    }

    public static List<ClassTree> findTopClasses(CompilationUnitTree compilationUnitTree, TreeUtilities treeUtilities) {
        List<? extends Tree> list = compilationUnitTree.getTypeDecls();
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ClassTree> arrayList = new ArrayList<ClassTree>(list.size());
        for (Tree tree : list) {
            ClassTree classTree;
            if (tree.getKind() != Tree.Kind.CLASS || !TestUtils.isTestable(classTree = (ClassTree)tree, treeUtilities)) continue;
            arrayList.add(classTree);
        }
        return arrayList;
    }

    public static HashMap<ElementHandle<TypeElement>, List<ExecutableElement>> findTopClasses(JavaSource javaSource, Set<Modifier> set, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws IOException {
        TopClassFinderTask topClassFinderTask = new TopClassFinderTask(set, bl, bl2, bl3, bl4);
        javaSource.runUserActionTask((Task)topClassFinderTask, true);
        return topClassFinderTask.getTopClassElems();
    }

    public static boolean hasSetUp(ClassTree classTree) {
        assert (classTree.getKind() == Tree.Kind.CLASS);
        List<? extends Tree> list = classTree.getMembers();
        for (Tree tree : list) {
            MethodTree methodTree;
            if (!(tree instanceof MethodTree) || !(methodTree = (MethodTree)tree).getName().toString().equals(NbBundle.getMessage(TestUtils.class, (String)"PROP_generator_method_setup"))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasTearDown(ClassTree classTree) {
        assert (classTree.getKind() == Tree.Kind.CLASS);
        List<? extends Tree> list = classTree.getMembers();
        for (Tree tree : list) {
            MethodTree methodTree;
            if (!(tree instanceof MethodTree) || !(methodTree = (MethodTree)tree).getName().toString().equals(NbBundle.getMessage(TestUtils.class, (String)"PROP_generator_method_teardown"))) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TestableTypeFinder
    implements CancellableTask<CompilationController> {
        private volatile boolean cancelled;
        private boolean testable = true;

        TestableTypeFinder() {
        }

        public void run(CompilationController compilationController) throws Exception {
            compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            if (this.cancelled) {
                return;
            }
            List<? extends Tree> list = compilationController.getCompilationUnit().getTypeDecls();
            if (list == null || list.isEmpty()) {
                return;
            }
            ArrayList arrayList = new ArrayList(list.size());
            Trees trees = compilationController.getTrees();
            for (Tree tree : list) {
                if (tree.getKind() != Tree.Kind.CLASS) continue;
                TypeElement typeElement = (TypeElement)trees.getElement(new TreePath(new TreePath(compilationController.getCompilationUnit()), tree));
                ElementKind elementKind = typeElement.getKind();
                if (elementKind.isInterface()) {
                    this.testable = false;
                    return;
                }
                TypeElement typeElement2 = compilationController.getElements().getTypeElement("javax.microedition.midlet.MIDlet");
                if (typeElement2 != null && !compilationController.getTypeUtilities().isCastable(typeElement.asType(), typeElement2.asType())) continue;
                this.testable = false;
                return;
            }
        }

        public boolean isTestable() {
            return this.testable;
        }

        public void cancel() {
            this.cancelled = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TopClassFinderTask
    implements CancellableTask<CompilationController> {
        private volatile boolean cancelled;
        private final boolean testPkgPrivateMethods;
        private final Set<Modifier> accessModifiers;
        final boolean skipAbstractClasses;
        final boolean skipPkgPrivateClasses;
        final boolean skipExceptionClasses;
        private HashMap<ElementHandle<TypeElement>, List<ExecutableElement>> topClassMap = new HashMap();

        private TopClassFinderTask(Set<Modifier> set, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            this.accessModifiers = set;
            this.testPkgPrivateMethods = bl;
            this.skipAbstractClasses = bl2;
            this.skipExceptionClasses = bl4;
            this.skipPkgPrivateClasses = bl3;
        }

        public void cancel() {
            this.cancelled = true;
        }

        public void run(CompilationController compilationController) throws Exception {
            compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            if (this.cancelled) {
                return;
            }
            TypeElement typeElement = null;
            if (this.skipExceptionClasses) {
                typeElement = compilationController.getElements().getTypeElement("java.lang.Exception");
            }
            List list = TestUtils.findTopClassElems((CompilationInfo)compilationController, compilationController.getCompilationUnit());
            for (TypeElement typeElement2 : list) {
                Object object;
                boolean bl;
                Set<Modifier> set = typeElement2.getModifiers();
                if (this.skipAbstractClasses && set.contains((Object)Modifier.ABSTRACT) || this.skipPkgPrivateClasses && !set.contains((Object)Modifier.PUBLIC) || typeElement != null && (bl = (object = compilationController.getTypes()).isSubtype(object.erasure(typeElement2.asType()), object.erasure(typeElement.asType())))) continue;
                object = TestUtils.findTopClassElemHandles((CompilationInfo)compilationController, compilationController.getCompilationUnit());
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    ElementHandle elementHandle = (ElementHandle)iterator.next();
                    this.topClassMap.put((ElementHandle<TypeElement>)elementHandle, this.findTestableMethods((TypeElement)elementHandle.resolve((CompilationInfo)compilationController)));
                }
            }
        }

        private boolean isTestableMethod(ExecutableElement executableElement) {
            if (executableElement.getKind() != ElementKind.METHOD) {
                throw new IllegalArgumentException();
            }
            return this.isMethodAcceptable(executableElement);
        }

        private boolean isMethodAcceptable(ExecutableElement executableElement) {
            Set<Modifier> set = executableElement.getModifiers();
            if (set.contains((Object)Modifier.PUBLIC) && this.accessModifiers.contains((Object)Modifier.PUBLIC)) {
                return true;
            }
            if (set.contains((Object)Modifier.PROTECTED) && this.accessModifiers.contains((Object)Modifier.PROTECTED)) {
                return true;
            }
            return !set.contains((Object)Modifier.PUBLIC) && !set.contains((Object)Modifier.PROTECTED) && !set.contains((Object)Modifier.PRIVATE) && this.testPkgPrivateMethods;
        }

        private List<ExecutableElement> findTestableMethods(TypeElement typeElement) {
            List<ExecutableElement> list = ElementFilter.methodsIn(typeElement.getEnclosedElements());
            if (list.isEmpty()) {
                return Collections.emptyList();
            }
            List<ExecutableElement> list2 = null;
            int n = 0;
            for (ExecutableElement executableElement : list) {
                if (this.isTestableMethod(executableElement)) {
                    if (list2 == null) {
                        list2 = new ArrayList<ExecutableElement>(list.size() - n);
                    }
                    list2.add(executableElement);
                    continue;
                }
                ++n;
            }
            return list2 != null ? list2 : Collections.emptyList();
        }

        public HashMap<ElementHandle<TypeElement>, List<ExecutableElement>> getTopClassElems() {
            return this.topClassMap;
        }
    }
}

