/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.grammar;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import org.apache.maven.embedder.MavenEmbedder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.filter.Filter;
import org.jdom.input.SAXBuilder;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.grammar.AbstractSchemaBasedGrammar;
import org.netbeans.modules.maven.grammar.MavenSettingsGrammar;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.PluginIndexManager;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.indexer.api.RepositoryQueries;
import org.netbeans.modules.xml.api.model.GrammarEnvironment;
import org.netbeans.modules.xml.api.model.GrammarResult;
import org.netbeans.modules.xml.api.model.HintContext;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenProjectGrammar
extends AbstractSchemaBasedGrammar {
    private static final String[] SCOPES = new String[]{"compile", "test", "runtime", "provided", "system"};
    private Set<String> groupCache;
    private RequestProcessor.Task groupTask;
    private Map<String, RequestProcessor.Task> artifactTasks = new HashMap<String, RequestProcessor.Task>();
    private Map<String, Set<String>> artifactCache = new HashMap<String, Set<String>>();
    private Map<String, RequestProcessor.Task> versionTasks = new HashMap<String, RequestProcessor.Task>();
    private Map<String, Set<String>> versionCache = new HashMap<String, Set<String>>();
    private final Object GROUP_LOCK = new Object();
    private final Object ARTIFACT_LOCK = new Object();
    private final Object VERSION_LOCK = new Object();

    public MavenProjectGrammar(GrammarEnvironment grammarEnvironment) {
        super(grammarEnvironment);
        this.groupTask = RequestProcessor.getDefault().create((Runnable)new GroupTask());
    }

    @Override
    protected InputStream getSchemaStream() {
        return this.getClass().getResourceAsStream("/org/netbeans/modules/maven/grammar/maven-4.0.0.xsd");
    }

    @Override
    protected List<GrammarResult> getDynamicCompletion(String string, HintContext hintContext, org.jdom.Element element) {
        if (string.endsWith("plugins/plugin/configuration") || string.endsWith("plugins/plugin/executions/execution/configuration")) {
            MavenEmbedder mavenEmbedder;
            Node node = string.indexOf("execution") > 0 ? hintContext.getParentNode().getParentNode().getParentNode().getPreviousSibling() : hintContext.getParentNode().getPreviousSibling();
            ArtifactInfoHolder artifactInfoHolder = this.findPluginInfo(node, mavenEmbedder = EmbedderFactory.getOnlineEmbedder(), true);
            List<GrammarResult> list = this.collectPluginParams(artifactInfoHolder, hintContext);
            if (list == null) {
                Document document = this.loadDocument(artifactInfoHolder, mavenEmbedder);
                if (document != null) {
                    return this.collectPluginParams(document, hintContext);
                }
            } else {
                return list;
            }
        }
        return Collections.emptyList();
    }

    private ArtifactInfoHolder findArtifactInfo(Node node) {
        ArtifactInfoHolder artifactInfoHolder = new ArtifactInfoHolder();
        while (node != null) {
            Element element;
            NodeList nodeList;
            if (node instanceof Element && (nodeList = (element = (Element)node).getChildNodes()).getLength() > 0) {
                if ("artifactId".equals(element.getNodeName())) {
                    artifactInfoHolder.setArtifactId(nodeList.item(0).getNodeValue());
                }
                if ("groupId".equals(element.getNodeName())) {
                    artifactInfoHolder.setGroupId(nodeList.item(0).getNodeValue());
                }
                if ("version".equals(element.getNodeName())) {
                    artifactInfoHolder.setVersion(nodeList.item(0).getNodeValue());
                }
            }
            node = node.getPreviousSibling();
        }
        return artifactInfoHolder;
    }

    private ArtifactInfoHolder findPluginInfo(Node node, MavenEmbedder mavenEmbedder, boolean bl) {
        File file;
        File file2;
        File file3;
        ArtifactInfoHolder artifactInfoHolder = this.findArtifactInfo(node);
        if (artifactInfoHolder.getGroupId() == null) {
            artifactInfoHolder.setGroupId("org.apache.maven.plugins");
        }
        if (bl && (artifactInfoHolder.getVersion() == null || "LATEST".equals(artifactInfoHolder.getVersion()) || "RELEASE".equals(artifactInfoHolder.getVersion())) && artifactInfoHolder.getArtifactId() != null && artifactInfoHolder.getGroupId() != null && (file3 = new File(file2 = new File(file = new File(mavenEmbedder.getLocalRepository().getBasedir(), artifactInfoHolder.getGroupId().replace('.', File.separatorChar)), artifactInfoHolder.getArtifactId()), "maven-metadata-local.xml")).exists()) {
            MetadataXpp3Reader metadataXpp3Reader = new MetadataXpp3Reader();
            try {
                Metadata metadata = metadataXpp3Reader.read((Reader)new InputStreamReader(new FileInputStream(file3)));
                if (metadata.getVersion() != null) {
                    artifactInfoHolder.setVersion(metadata.getVersion());
                } else {
                    Versioning versioning = metadata.getVersioning();
                    if (versioning != null) {
                        if ("LATEST".equals(artifactInfoHolder.getVersion())) {
                            artifactInfoHolder.setVersion(versioning.getLatest());
                        }
                        if ("RELEASE".equals(artifactInfoHolder.getVersion())) {
                            artifactInfoHolder.setVersion(versioning.getRelease());
                        }
                    }
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            catch (XmlPullParserException xmlPullParserException) {
                xmlPullParserException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (artifactInfoHolder.getVersion() == null) {
            artifactInfoHolder.setVersion("RELEASE");
        }
        return artifactInfoHolder;
    }

    private List<GrammarResult> collectPluginParams(Document document, HintContext hintContext) {
        Iterator iterator = document.getRootElement().getDescendants(new Filter(){

            public boolean matches(Object object) {
                org.jdom.Element element;
                return object instanceof org.jdom.Element && "parameter".equals((element = (org.jdom.Element)object).getName()) && element.getParentElement() != null && "parameters".equals(element.getParentElement().getName()) && element.getParentElement().getParentElement() != null && "mojo".equals(element.getParentElement().getParentElement().getName());
            }
        });
        ArrayList<GrammarResult> arrayList = new ArrayList<GrammarResult>();
        HashSet<String> hashSet = new HashSet<String>();
        while (iterator.hasNext()) {
            String string;
            org.jdom.Element element = (org.jdom.Element)iterator.next();
            String string2 = element.getChildText("editable");
            if (!"true".equalsIgnoreCase(string2) || !(string = element.getChildText("name")).startsWith(hintContext.getCurrentPrefix()) || hashSet.contains(string)) continue;
            hashSet.add(string);
            arrayList.add(new AbstractSchemaBasedGrammar.MyElement(string));
        }
        return arrayList;
    }

    private List<GrammarResult> collectPluginParams(ArtifactInfoHolder artifactInfoHolder, HintContext hintContext) {
        Set set;
        try {
            set = PluginIndexManager.getPluginParameters((String)artifactInfoHolder.getGroupId(), (String)artifactInfoHolder.getArtifactId(), (String)artifactInfoHolder.getVersion(), null);
            if (set == null) {
                return null;
            }
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
            return null;
        }
        ArrayList<GrammarResult> arrayList = new ArrayList<GrammarResult>();
        for (PluginIndexManager.ParameterDetail parameterDetail : set) {
            if (!parameterDetail.getName().startsWith(hintContext.getCurrentPrefix())) continue;
            AbstractSchemaBasedGrammar.MyElement myElement = new AbstractSchemaBasedGrammar.MyElement(parameterDetail.getName());
            myElement.setDescription(parameterDetail.getHtmlDetails(true));
            arrayList.add(myElement);
        }
        return arrayList;
    }

    @Override
    protected Enumeration<GrammarResult> getDynamicValueCompletion(String string, HintContext hintContext, org.jdom.Element element) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        if (string.endsWith("executions/execution/goals/goal")) {
            object5 = hintContext.getCurrentPrefix().length() == 0 ? hintContext.getParentNode().getParentNode().getParentNode() : hintContext.getParentNode().getParentNode().getParentNode().getParentNode();
            object3 = this.findPluginInfo((Node)(object5 = object5.getPreviousSibling()), (MavenEmbedder)(object4 = EmbedderFactory.getOnlineEmbedder()), true);
            object2 = this.collectGoals((ArtifactInfoHolder)object3, hintContext);
            if (object2 == null) {
                object = this.loadDocument((ArtifactInfoHolder)object3, (MavenEmbedder)object4);
                if (object != null) {
                    return this.collectGoals((Document)object, hintContext);
                }
            } else {
                return object2;
            }
        }
        if (string.endsWith("executions/execution/phase")) {
            object5 = EmbedderFactory.getOnlineEmbedder();
            object4 = object5.getLifecyclePhases();
            return super.createTextValueList(object4.toArray(new String[object4.size()]), hintContext);
        }
        if ((string.endsWith("dependencies/dependency/version") || string.endsWith("plugins/plugin/version") || string.endsWith("extensions/extension/version") || string.endsWith("/project/parent/version")) && ((ArtifactInfoHolder)(object4 = this.findPluginInfo((Node)(object5 = hintContext.getCurrentPrefix().length() == 0 ? hintContext.getPreviousSibling() : hintContext.getParentNode().getPreviousSibling()), null, false))).getGroupId() != null && ((ArtifactInfoHolder)object4).getArtifactId() != null) {
            object3 = this.getVersions(((ArtifactInfoHolder)object4).getGroupId(), ((ArtifactInfoHolder)object4).getArtifactId());
            object2 = new ArrayList();
            for (String string2 : object3) {
                if (!string2.startsWith(hintContext.getCurrentPrefix())) continue;
                object2.add(new AbstractSchemaBasedGrammar.MyTextElement(string2, hintContext.getCurrentPrefix()));
            }
            return Collections.enumeration(object2);
        }
        if (string.endsWith("dependencies/dependency/groupId") || string.endsWith("extensions/extension/groupId")) {
            object5 = this.getGroupIds();
            object4 = new ArrayList<AbstractSchemaBasedGrammar.MyTextElement>();
            object3 = object5.iterator();
            while (object3.hasNext()) {
                object2 = (String)object3.next();
                if (!((String)object2).startsWith(hintContext.getCurrentPrefix())) continue;
                ((ArrayList)object4).add(new AbstractSchemaBasedGrammar.MyTextElement((String)object2, hintContext.getCurrentPrefix()));
            }
            return Collections.enumeration(object4);
        }
        if (string.endsWith("plugins/plugin/groupId")) {
            object5 = RepositoryQueries.filterPluginGroupIds((String)hintContext.getCurrentPrefix(), (RepositoryInfo[])new RepositoryInfo[0]);
            object4 = new ArrayList();
            object3 = object5.iterator();
            while (object3.hasNext()) {
                object2 = (String)object3.next();
                ((ArrayList)object4).add(new AbstractSchemaBasedGrammar.MyTextElement((String)object2, hintContext.getCurrentPrefix()));
            }
            return Collections.enumeration(object4);
        }
        if ((string.endsWith("dependencies/dependency/artifactId") || string.endsWith("extensions/extension/artifactId")) && ((ArtifactInfoHolder)(object4 = this.findArtifactInfo((Node)(object5 = hintContext.getCurrentPrefix().length() == 0 ? hintContext.getPreviousSibling() : hintContext.getParentNode().getPreviousSibling())))).getGroupId() != null) {
            object3 = this.getArtifactIds(((ArtifactInfoHolder)object4).getGroupId());
            object2 = new ArrayList<AbstractSchemaBasedGrammar.MyTextElement>();
            object = hintContext.getCurrentPrefix();
            for (String string3 : object3) {
                if (!string3.startsWith((String)object)) continue;
                ((ArrayList)object2).add(new AbstractSchemaBasedGrammar.MyTextElement(string3, (String)object));
            }
            return Collections.enumeration(object2);
        }
        if (string.endsWith("plugins/plugin/artifactId") && ((ArtifactInfoHolder)(object4 = this.findArtifactInfo((Node)(object5 = hintContext.getCurrentPrefix().length() == 0 ? hintContext.getPreviousSibling() : hintContext.getParentNode().getPreviousSibling())))).getGroupId() != null) {
            object3 = RepositoryQueries.filterPluginArtifactIds((String)((ArtifactInfoHolder)object4).getGroupId(), (String)hintContext.getCurrentPrefix(), (RepositoryInfo[])new RepositoryInfo[0]);
            object2 = new ArrayList();
            for (String string4 : object3) {
                ((ArrayList)object2).add(new AbstractSchemaBasedGrammar.MyTextElement(string4, hintContext.getCurrentPrefix()));
            }
            return Collections.enumeration(object2);
        }
        if (string.endsWith("dependencies/dependency/scope")) {
            return super.createTextValueList(SCOPES, hintContext);
        }
        if (string.endsWith("repositories/repository/releases/updatePolicy") || string.endsWith("repositories/repository/snapshots/updatePolicy") || string.endsWith("pluginRepositories/pluginRepository/releases/updatePolicy") || string.endsWith("pluginRepositories/pluginRepository/snapshots/updatePolicy")) {
            return super.createTextValueList(MavenSettingsGrammar.UPDATE_POLICIES, hintContext);
        }
        if (string.endsWith("repository/releases/checksumPolicy") || string.endsWith("repository/snapshots/checksumPolicy") || string.endsWith("pluginRepository/releases/checksumPolicy") || string.endsWith("pluginRepository/snapshots/checksumPolicy")) {
            return super.createTextValueList(MavenSettingsGrammar.CHECKSUM_POLICIES, hintContext);
        }
        if (string.endsWith("repositories/repository/layout") || string.endsWith("pluginRepositories/pluginRepository/layout") || string.endsWith("distributionManagement/repository/layout")) {
            return super.createTextValueList(MavenSettingsGrammar.LAYOUTS, hintContext);
        }
        if (string.endsWith("repositories/repository/url") || string.endsWith("pluginRepositories/pluginRepository/url") || string.endsWith("distributionManagement/repository/url")) {
            object5 = this.getRepoUrls();
            return super.createTextValueList(object5.toArray(new String[0]), hintContext);
        }
        if (string.endsWith("modules/module") && (object5 = this.getEnvironment().getFileObject()) != null) {
            object4 = FileUtil.toFile((FileObject)object5).getParentFile();
            object3 = ((File)object4).listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() && new File(file, "pom.xml").exists();
                }
            });
            object2 = new ArrayList();
            for (int i = 0; i < ((File[])object3).length; ++i) {
                if (!object3[i].getName().startsWith(hintContext.getCurrentPrefix())) continue;
                object2.add(new AbstractSchemaBasedGrammar.MyTextElement(object3[i].getName(), hintContext.getCurrentPrefix()));
            }
            return Collections.enumeration(object2);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getGroupIds() {
        Set<String> set = null;
        Object object = this.GROUP_LOCK;
        synchronized (object) {
            if (this.groupCache != null) {
                set = this.groupCache;
            } else if (!this.groupTask.isFinished()) {
                this.groupTask.run();
            }
        }
        if (set == null) {
            this.groupTask.waitFinished();
        }
        object = this.GROUP_LOCK;
        synchronized (object) {
            set = this.groupCache != null ? this.groupCache : Collections.emptySet();
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getArtifactIds(String string) {
        Set<String> set;
        Set<String> set2 = null;
        RequestProcessor.Task task = null;
        Object object = this.ARTIFACT_LOCK;
        synchronized (object) {
            task = this.artifactTasks.get(string);
            if (task == null) {
                task = RequestProcessor.getDefault().create((Runnable)new ArtifactTask(string));
                this.artifactTasks.put(string, task);
            }
            if ((set = this.artifactCache.get(string)) != null) {
                set2 = set;
            } else if (!task.isFinished()) {
                task.run();
            }
        }
        if (set2 == null) {
            task.waitFinished();
        }
        object = this.ARTIFACT_LOCK;
        synchronized (object) {
            set = this.artifactCache.get(string);
            set2 = set != null ? set : Collections.emptySet();
        }
        return set2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getVersions(String string, String string2) {
        Set<String> set;
        Set<String> set2 = null;
        RequestProcessor.Task task = null;
        String string3 = string + ":" + string2;
        Object object = this.VERSION_LOCK;
        synchronized (object) {
            task = this.versionTasks.get(string3);
            if (task == null) {
                task = RequestProcessor.getDefault().create((Runnable)new VersionTask(string, string2));
                this.versionTasks.put(string3, task);
            }
            if ((set = this.versionCache.get(string3)) != null) {
                set2 = set;
            } else if (!task.isFinished()) {
                task.run();
            }
        }
        if (set2 == null) {
            task.waitFinished();
        }
        object = this.VERSION_LOCK;
        synchronized (object) {
            set = this.versionCache.get(string3);
            set2 = set != null ? set : Collections.emptySet();
        }
        return set2;
    }

    private List<String> getRepoUrls() {
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = RepositoryPreferences.getInstance().getRepositoryInfos();
        for (RepositoryInfo repositoryInfo : list) {
            if (repositoryInfo.getRepositoryUrl() == null) continue;
            arrayList.add(repositoryInfo.getRepositoryUrl());
        }
        return arrayList;
    }

    private Document loadDocument(ArtifactInfoHolder artifactInfoHolder, MavenEmbedder mavenEmbedder) {
        if (artifactInfoHolder.getArtifactId() != null && artifactInfoHolder.getGroupId() != null && artifactInfoHolder.getVersion() != null) {
            Artifact artifact = mavenEmbedder.createArtifact(artifactInfoHolder.getGroupId(), artifactInfoHolder.getArtifactId(), artifactInfoHolder.getVersion(), null, "jar");
            String string = mavenEmbedder.getLocalRepository().pathOf(artifact);
            File file = new File(mavenEmbedder.getLocalRepository().getBasedir(), string);
            if (file.exists()) {
                try {
                    JarFile jarFile = new JarFile(file);
                    JarEntry jarEntry = jarFile.getJarEntry("META-INF/maven/plugin.xml");
                    if (jarEntry != null) {
                        InputStream inputStream = jarFile.getInputStream(jarEntry);
                        SAXBuilder sAXBuilder = new SAXBuilder();
                        return sAXBuilder.build(inputStream);
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                catch (JDOMException jDOMException) {
                    jDOMException.printStackTrace();
                }
            }
        }
        return null;
    }

    private Enumeration<GrammarResult> collectGoals(Document document, HintContext hintContext) {
        Iterator iterator = document.getRootElement().getDescendants(new Filter(){

            public boolean matches(Object object) {
                org.jdom.Element element;
                return object instanceof org.jdom.Element && "goal".equals((element = (org.jdom.Element)object).getName()) && element.getParentElement() != null && "mojo".equals(element.getParentElement().getName());
            }
        });
        ArrayList<AbstractSchemaBasedGrammar.MyTextElement> arrayList = new ArrayList<AbstractSchemaBasedGrammar.MyTextElement>();
        while (iterator.hasNext()) {
            org.jdom.Element element = (org.jdom.Element)iterator.next();
            String string = element.getText();
            if (!string.startsWith(hintContext.getCurrentPrefix())) continue;
            arrayList.add(new AbstractSchemaBasedGrammar.MyTextElement(string, hintContext.getCurrentPrefix()));
        }
        return Collections.enumeration(arrayList);
    }

    private Enumeration<GrammarResult> collectGoals(ArtifactInfoHolder artifactInfoHolder, HintContext hintContext) {
        Set set;
        if (artifactInfoHolder.getGroupId() == null || artifactInfoHolder.getArtifactId() == null || artifactInfoHolder.getVersion() == null) {
            return null;
        }
        try {
            set = PluginIndexManager.getPluginGoals((String)artifactInfoHolder.getGroupId(), (String)artifactInfoHolder.getArtifactId(), (String)artifactInfoHolder.getVersion());
            if (set == null) {
                return null;
            }
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
            return null;
        }
        ArrayList<AbstractSchemaBasedGrammar.MyTextElement> arrayList = new ArrayList<AbstractSchemaBasedGrammar.MyTextElement>();
        for (String string : set) {
            if (!string.startsWith(hintContext.getCurrentPrefix())) continue;
            arrayList.add(new AbstractSchemaBasedGrammar.MyTextElement(string, hintContext.getCurrentPrefix()));
        }
        return Collections.enumeration(arrayList);
    }

    private class VersionTask
    implements Runnable {
        private String groupId;
        private String artifactId;

        VersionTask(String string, String string2) {
            this.groupId = string;
            this.artifactId = string2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            List list = RepositoryQueries.getVersions((String)this.groupId, (String)this.artifactId, (RepositoryInfo[])new RepositoryInfo[0]);
            TreeSet<String> treeSet = new TreeSet<String>();
            for (NBVersionInfo nBVersionInfo : list) {
                treeSet.add(nBVersionInfo.getVersion());
            }
            Object object = MavenProjectGrammar.this.VERSION_LOCK;
            synchronized (object) {
                MavenProjectGrammar.this.versionCache.put(this.groupId + ":" + this.artifactId, treeSet);
            }
        }
    }

    private class ArtifactTask
    implements Runnable {
        private String groupId;

        ArtifactTask(String string) {
            this.groupId = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Set set = RepositoryQueries.getArtifacts((String)this.groupId, (RepositoryInfo[])new RepositoryInfo[0]);
            Object object = MavenProjectGrammar.this.ARTIFACT_LOCK;
            synchronized (object) {
                MavenProjectGrammar.this.artifactCache.put(this.groupId, set);
            }
        }
    }

    private class GroupTask
    implements Runnable {
        private GroupTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Set set = RepositoryQueries.getGroups((RepositoryInfo[])new RepositoryInfo[0]);
            Object object = MavenProjectGrammar.this.GROUP_LOCK;
            synchronized (object) {
                MavenProjectGrammar.this.groupCache = set;
            }
        }
    }

    private static class ArtifactInfoHolder {
        private String artifactId;
        private String groupId;
        private String version;

        private ArtifactInfoHolder() {
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public void setArtifactId(String string) {
            this.artifactId = string;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public void setGroupId(String string) {
            this.groupId = string;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String string) {
            this.version = string;
        }
    }
}

