/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual.ui.preview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.netbeans.core.browser.api.EmbeddedBrowserFactory;
import org.netbeans.core.browser.api.WebBrowser;
import org.netbeans.modules.css.visual.ui.preview.CssPreviewComponent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class CssWebPreviewPanel
extends JPanel
implements CssPreviewComponent {
    private WebBrowser browser;
    private FileFilter filter = new HTMLFileFilter();
    private Map<String, File> urlToFile = new HashMap<String, File>();
    private String currentUrl;
    private boolean browserDisposed = false;
    private JButton browseButton;
    private JLabel filenameLabel;
    private JPanel jPanel1;

    public CssWebPreviewPanel() {
        this.initComponents();
        if (EmbeddedBrowserFactory.getDefault().isEnabled()) {
            this.browser = EmbeddedBrowserFactory.getDefault().createEmbeddedBrowser();
            this.add(this.browser.getComponent(), "Center");
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.browseButton = new JButton();
        this.filenameLabel = new JLabel();
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.browseButton.setText(NbBundle.getMessage(CssWebPreviewPanel.class, (String)"CssWebPreviewPanel.browseButton.text"));
        this.browseButton.setToolTipText(NbBundle.getMessage(CssWebPreviewPanel.class, (String)"DifferentPreviewFile_Tooltip"));
        this.browseButton.setMargin(new Insets(2, 4, 2, 4));
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CssWebPreviewPanel.this.browseButtonActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.browseButton, gridBagConstraints);
        this.filenameLabel.setText(NbBundle.getMessage(CssWebPreviewPanel.class, (String)"CssWebPreviewPanel.filenameLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel1.add((Component)this.filenameLabel, gridBagConstraints);
        this.add((Component)this.jPanel1, "North");
    }

    private void browseButtonActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setDialogTitle(NbBundle.getMessage(CssWebPreviewPanel.class, (String)"WebPreviewChooserTitle"));
        jFileChooser.setFileSelectionMode(2);
        jFileChooser.setFileFilter(this.filter);
        if (0 == jFileChooser.showOpenDialog(this)) {
            File file = jFileChooser.getSelectedFile();
            try {
                if (file.exists() && file.isFile()) {
                    this.urlToFile.put(this.currentUrl, file);
                    String string = file.toURI().toURL().toExternalForm();
                    this.browser.setURL(string);
                    this.filenameLabel.setText(file.getName());
                    this.filenameLabel.setToolTipText(string);
                }
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
            }
        }
    }

    public void setDocument(InputStream inputStream, String string) throws Exception {
        this.currentUrl = string;
        if (this.browser == null) {
            return;
        }
        File file = this.urlToFile.get(string);
        if (file != null) {
            String string2 = file.toURI().toURL().toExternalForm();
            this.browser.setURL(string2);
            this.filenameLabel.setText(file.getName());
            this.filenameLabel.setToolTipText(string2);
            return;
        }
        this.browser.setContent(this.getContentFromReader(new BufferedReader(new InputStreamReader(inputStream))));
        this.filenameLabel.setText(NbBundle.getMessage(CssWebPreviewPanel.class, (String)"FileNameLabelText"));
        this.filenameLabel.setToolTipText(NbBundle.getMessage(CssWebPreviewPanel.class, (String)"FileNameLabelTooltip"));
    }

    public JComponent getComponent() {
        if ((this.browserDisposed || this.browser == null) && EmbeddedBrowserFactory.getDefault().isEnabled()) {
            this.browser = EmbeddedBrowserFactory.getDefault().createEmbeddedBrowser();
            this.add(this.browser.getComponent(), "Center");
            this.revalidate();
            this.repaint();
            this.browserDisposed = false;
        }
        return this;
    }

    public void dispose() {
        this.browserDisposed = true;
        this.browser.dispose();
    }

    private String getContentFromReader(BufferedReader bufferedReader) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        try {
            string = bufferedReader.readLine();
            while (string != null) {
                stringBuffer.append(string);
                string = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return stringBuffer.toString();
    }

    class HTMLFileFilter
    extends FileFilter {
        HTMLFileFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory() || file.toString().endsWith("html") || file.toString().endsWith("xhtml");
        }

        public String getDescription() {
            return NbBundle.getMessage(CssWebPreviewPanel.class, (String)"WebPreviewFileFilterDesc");
        }
    }
}

