/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.netbeans.modules.css.visual.model.MarginPaddingModel;
import org.netbeans.modules.css.visual.model.PropertyWithUnitData;
import org.netbeans.modules.css.visual.model.Utils;
import org.openide.util.NbBundle;

public class MarginWidthField
extends JPanel {
    PropertyWithUnitData borderMarginData = new PropertyWithUnitData();
    MarginPaddingModel marginPaddingModel = new MarginPaddingModel();
    private JComboBox borderMarginCombo;
    private JComboBox borderMarginUnitCombo;

    public MarginWidthField() {
        this.initComponents();
        this.borderMarginCombo.setModel(this.marginPaddingModel.getMarginList());
        this.borderMarginUnitCombo.setModel(this.marginPaddingModel.getMarginUnitList());
        final JTextField jTextField = (JTextField)this.borderMarginCombo.getEditor().getEditorComponent();
        jTextField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        MarginWidthField.this.borderMarginUnitCombo.setEnabled(Utils.isInteger(jTextField.getText()));
                    }
                });
            }
        });
    }

    public void setMarginString(String string) {
        if (string != null && !string.equals("")) {
            if (Utils.isInteger(string)) {
                this.setMarginValue(string);
            } else {
                String string2 = this.getUnit(string);
                this.setMarginUnit(string2);
                this.setMarginValue(string.replaceAll(string2, "").trim());
            }
        } else {
            this.setMarginValue(null);
            this.setMarginUnit(null);
        }
    }

    public String getMarginString() {
        return this.borderMarginData.toString();
    }

    private String getUnit(String string) {
        DefaultComboBoxModel defaultComboBoxModel = this.marginPaddingModel.getMarginUnitList();
        for (int i = 0; i < defaultComboBoxModel.getSize(); ++i) {
            String string2 = (String)defaultComboBoxModel.getElementAt(i);
            if (!string.trim().endsWith(string2)) continue;
            return string2;
        }
        return "";
    }

    public void setMarginValue(String string) {
        if (string == null || string.equals("")) {
            this.borderMarginCombo.setSelectedIndex(0);
        } else {
            this.borderMarginCombo.setSelectedItem(string);
            this.borderMarginData.setValue(string);
        }
    }

    public void setMarginUnit(String string) {
        if (string == null || string.equals("")) {
            this.borderMarginUnitCombo.setSelectedIndex(this.marginPaddingModel.getMarginUnitList().getIndexOf("px"));
        } else {
            if (this.marginPaddingModel.getMarginUnitList().getIndexOf(string) != -1) {
                this.borderMarginUnitCombo.setSelectedIndex(this.marginPaddingModel.getMarginUnitList().getIndexOf(string));
            } else {
                this.borderMarginUnitCombo.setSelectedIndex(this.marginPaddingModel.getMarginUnitList().getIndexOf("px"));
            }
            this.borderMarginData.setUnit(string);
        }
    }

    private void initComponents() {
        this.borderMarginCombo = new JComboBox();
        this.borderMarginUnitCombo = new JComboBox();
        this.setLayout(new BorderLayout(3, 0));
        this.borderMarginCombo.setEditable(true);
        this.borderMarginCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MarginWidthField.this.borderMarginComboActionPerformed(actionEvent);
            }
        });
        this.borderMarginCombo.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                MarginWidthField.this.borderMarginComboFocusLost(focusEvent);
            }
        });
        this.borderMarginCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                MarginWidthField.this.borderMarginComboItemStateChanged(itemEvent);
            }
        });
        this.add((Component)this.borderMarginCombo, "Center");
        this.borderMarginCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MarginWidthField.class, (String)"MARGIN_WIDTH_FIELD_ACCESS_NAME"));
        this.borderMarginCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MarginWidthField.class, (String)"MARGIN_WIDTH_FIELD_ACCESS_DESC"));
        this.borderMarginUnitCombo.setEnabled(false);
        this.borderMarginUnitCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                MarginWidthField.this.borderMarginUnitComboItemStateChanged(itemEvent);
            }
        });
        this.borderMarginUnitCombo.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                MarginWidthField.this.borderMarginUnitComboFocusLost(focusEvent);
            }
        });
        this.add((Component)this.borderMarginUnitCombo, "East");
        this.borderMarginUnitCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MarginWidthField.class, (String)"MARGIN_WIDTH_UNIT_ACCESS_NAME"));
        this.borderMarginUnitCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MarginWidthField.class, (String)"MARGIN_WIDTH_UNIT_ACCESS_DESC"));
    }

    private void borderMarginUnitComboFocusLost(FocusEvent focusEvent) {
        this.setBorderMargin();
    }

    private void borderMarginUnitComboItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() != 2) {
            this.setBorderMargin();
        }
    }

    public void setAccessibleName(String string, String string2) {
        this.borderMarginCombo.getAccessibleContext().setAccessibleName(string);
        this.borderMarginUnitCombo.getAccessibleContext().setAccessibleName(string2);
    }

    public void setAccessibleDescription(String string, String string2) {
        this.borderMarginCombo.getAccessibleContext().setAccessibleDescription(string);
        this.borderMarginUnitCombo.getAccessibleContext().setAccessibleDescription(string2);
    }

    private void borderMarginComboItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() != 2) {
            this.borderMarginUnitCombo.setEnabled(Utils.isInteger(this.borderMarginCombo.getSelectedItem().toString()));
            this.setBorderMargin();
        }
    }

    private void borderMarginComboFocusLost(FocusEvent focusEvent) {
        this.setBorderMargin();
    }

    private void borderMarginComboActionPerformed(ActionEvent actionEvent) {
        this.setBorderMargin();
    }

    private void setBorderMargin() {
        String string = this.borderMarginData.toString();
        this.borderMarginData.setUnit(this.borderMarginUnitCombo.getSelectedItem().toString());
        this.borderMarginData.setValue(this.borderMarginCombo.getSelectedItem().toString());
        this.firePropertyChange("margin-width", string, this.borderMarginData.toString());
    }
}

