/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual.model;

import java.awt.Color;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.DefaultComboBoxModel;
import org.netbeans.modules.css.visual.model.CssProperties;
import org.netbeans.modules.css.visual.model.Utils;

public class ColorModel {
    private Color color = Color.BLACK;
    private Map colorNameHexMap = CssProperties.getColorNameHexMap();

    public DefaultComboBoxModel getColorList() {
        return new ColorList();
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setColor(String string) {
        this.setColor(Color.BLACK);
        if (string.startsWith(Utils.NOT_SET)) {
            return;
        }
        if (string.startsWith("#")) {
            this.setHexColor(string);
        } else if (string.startsWith("rgb")) {
            try {
                String string2 = string.substring(string.indexOf("(") + 1, string.indexOf(")"));
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                int n = Integer.parseInt(stringTokenizer.nextToken().trim());
                int n2 = Integer.parseInt(stringTokenizer.nextToken().trim());
                int n3 = Integer.parseInt(stringTokenizer.nextToken().trim());
                this.color = new Color(n, n2, n3);
            }
            catch (Exception exception) {
                this.color = Color.BLACK;
            }
        } else {
            String string3 = (String)this.colorNameHexMap.get(string);
            if (string3 != null) {
                this.setHexColor(string3);
            }
        }
    }

    public void setHexColor(String string) {
        int n = 0;
        if (string.startsWith("#")) {
            n = 1;
        }
        try {
            int n2 = Integer.parseInt(string.substring(n, n + 2), 16);
            int n3 = Integer.parseInt(string.substring(n + 2, n + 4), 16);
            int n4 = Integer.parseInt(string.substring(n + 4, n + 6), 16);
            this.color = new Color(n2, n3, n4);
        }
        catch (Exception exception) {
            this.color = Color.BLACK;
        }
    }

    public String getHexColor(Color color) {
        this.color = color;
        return this.getHexColor();
    }

    public String getHexColor() {
        String string;
        String string2;
        String string3 = Integer.toHexString(this.color.getRed());
        if (string3.length() < 2) {
            string3 = "0" + string3;
        }
        if ((string2 = Integer.toHexString(this.color.getGreen())).length() < 2) {
            string2 = "0" + string2;
        }
        if ((string = Integer.toHexString(this.color.getBlue())).length() < 2) {
            string = "0" + string;
        }
        String string4 = "#" + string3 + string2 + string;
        return string4;
    }

    public class ColorList
    extends DefaultComboBoxModel {
        public ColorList() {
            this.addElement(Utils.NOT_SET);
            Iterator iterator = ColorModel.this.colorNameHexMap.keySet().iterator();
            while (iterator.hasNext()) {
                this.addElement(iterator.next());
            }
        }
    }
}

