/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.componentssupport.ui.helpers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.netbeans.modules.vmd.componentssupport.ui.helpers.BaseHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ProjectTemplateZipHelper
extends BaseHelper {
    private static final String PROJECT_XML = "nbproject/project.xml";
    private static final String BUILD_IMPL_XML = "nbproject/build-impl.xml";
    private static final String BUILD_XML = "build.xml";
    private static final String PLATFORM_PROPERTIES = "nbproject/platform.properties";
    private static final String SUITE_PROPERTIES = "nbproject/suite.properties";
    private static final String SUITE_PRIVATE_PROPERTIES = "nbproject/private/suite-private.properties";
    private static final String CODE_NAME_BASE = "code-name-base";
    private static final String DATA = "data";
    private static final String CODE_NAME_PARAM = "_CODE_NAME_";
    private static final String BUNDLE_PATH_PARAM = "_BUNDLE_PATH_";
    private static final String PROJECT_NAME_PARAM = "_PROJECT_NAME_";
    private static final String PLATFORM_ID_PARAM = "_PLATFORM_ID_";
    private static final String SUITE_PATH_PARAM = "suite.dir";
    private static final String BUNDLE_NAME = "src/Bundle.properties";
    private static final String LAYER_NAME = "src/layer.xml";
    private static final String MANIFEST = "manifest.mf";
    private static final String LAYER = "OpenIDE-Module-Layer: ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unZipFile(InputStream inputStream, FileObject fileObject, WizardDescriptor wizardDescriptor) throws IOException {
        try {
            ZipEntry zipEntry;
            ZipInputStream zipInputStream = new ZipInputStream(inputStream);
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (zipEntry.isDirectory()) {
                    FileUtil.createFolder((FileObject)fileObject, (String)zipEntry.getName());
                    continue;
                }
                FileObject fileObject2 = null;
                if (PROJECT_XML.equals(zipEntry.getName())) {
                    fileObject2 = FileUtil.createData((FileObject)fileObject, (String)zipEntry.getName());
                    ProjectTemplateZipHelper.filterProjectXML(fileObject2, zipInputStream, (String)wizardDescriptor.getProperty("codeBaseName"));
                    continue;
                }
                if (MANIFEST.equals(zipEntry.getName())) {
                    fileObject2 = FileUtil.createData((FileObject)fileObject, (String)zipEntry.getName());
                    ProjectTemplateZipHelper.filterManifest(fileObject2, zipInputStream, wizardDescriptor);
                    continue;
                }
                if (PLATFORM_PROPERTIES.equals(zipEntry.getName())) {
                    fileObject2 = FileUtil.createData((FileObject)fileObject, (String)zipEntry.getName());
                    ProjectTemplateZipHelper.filterPlatformProperties(fileObject2, zipInputStream, wizardDescriptor);
                    continue;
                }
                if (LAYER_NAME.equals(zipEntry.getName())) {
                    ProjectTemplateZipHelper.copyLayer(fileObject, zipInputStream, wizardDescriptor);
                    continue;
                }
                if (BUNDLE_NAME.equals(zipEntry.getName())) {
                    ProjectTemplateZipHelper.filterBundle(fileObject, zipInputStream, wizardDescriptor);
                    continue;
                }
                if (BUILD_XML.equals(zipEntry.getName()) || BUILD_IMPL_XML.equals(zipEntry.getName())) {
                    fileObject2 = FileUtil.createData((FileObject)fileObject, (String)zipEntry.getName());
                    ProjectTemplateZipHelper.filterBuild(fileObject2, zipInputStream, (String)wizardDescriptor.getProperty("codeBaseName"));
                    continue;
                }
                fileObject2 = FileUtil.createData((FileObject)fileObject, (String)zipEntry.getName());
                ProjectTemplateZipHelper.copyByteAfterByte(zipInputStream, fileObject2);
            }
        }
        finally {
            inputStream.close();
        }
        ProjectTemplateZipHelper.createSuiteProperties(fileObject, wizardDescriptor);
    }

    private static void createSuiteProperties(FileObject fileObject, WizardDescriptor wizardDescriptor) throws IOException {
        String string;
        String string2;
        String string3;
        File file;
        if (!ProjectTemplateZipHelper.isSuiteComponent(wizardDescriptor)) {
            return;
        }
        File file2 = FileUtil.toFile((FileObject)fileObject);
        String string4 = PropertyUtils.relativizeFile((File)file2, (File)(file = FileUtil.normalizeFile((File)new File(string3 = ProjectTemplateZipHelper.getSuiteRoot(wizardDescriptor)))));
        if (string4 != null) {
            string2 = "${basedir}/" + string4;
            string = SUITE_PROPERTIES;
        } else {
            string2 = file.getAbsolutePath();
            string = SUITE_PRIVATE_PROPERTIES;
        }
        EditableProperties editableProperties = new EditableProperties(true);
        editableProperties.setProperty(SUITE_PATH_PARAM, string2);
        FileObject fileObject2 = FileUtil.createData((FileObject)fileObject, (String)string);
        ProjectTemplateZipHelper.storeProperties(fileObject2, editableProperties);
    }

    private static void filterBuild(FileObject fileObject, ZipInputStream zipInputStream, String string) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FileUtil.copy((InputStream)zipInputStream, (OutputStream)byteArrayOutputStream);
        String string2 = byteArrayOutputStream.toString("UTF-8");
        string2 = string2.replace(CODE_NAME_PARAM, string);
        ProjectTemplateZipHelper.copyByteAfterByte(string2, fileObject);
    }

    private static void filterBundle(FileObject fileObject, ZipInputStream zipInputStream, WizardDescriptor wizardDescriptor) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FileUtil.copy((InputStream)zipInputStream, (OutputStream)byteArrayOutputStream);
        String string = byteArrayOutputStream.toString("UTF-8");
        string = string.replace(PROJECT_NAME_PARAM, (String)wizardDescriptor.getProperty("displayName"));
        FileObject fileObject2 = FileUtil.createData((FileObject)fileObject, (String)("src/" + (String)wizardDescriptor.getProperty("bundle")));
        ProjectTemplateZipHelper.copyByteAfterByte(string, fileObject2);
    }

    private static void copyLayer(FileObject fileObject, ZipInputStream zipInputStream, WizardDescriptor wizardDescriptor) throws IOException {
        String string = (String)wizardDescriptor.getProperty("layer");
        if (string == null || string.length() == 0) {
            return;
        }
        FileObject fileObject2 = FileUtil.createData((FileObject)fileObject, (String)("src/" + string));
        ProjectTemplateZipHelper.copyByteAfterByte(zipInputStream, fileObject2);
    }

    private static void filterManifest(FileObject fileObject, ZipInputStream zipInputStream, WizardDescriptor wizardDescriptor) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FileUtil.copy((InputStream)zipInputStream, (OutputStream)byteArrayOutputStream);
        String string = byteArrayOutputStream.toString("UTF-8");
        string = string.replace(CODE_NAME_PARAM, (String)wizardDescriptor.getProperty("codeBaseName"));
        string = string.replace(BUNDLE_PATH_PARAM, (String)wizardDescriptor.getProperty("bundle"));
        StringBuilder stringBuilder = new StringBuilder(string);
        String string2 = (String)wizardDescriptor.getProperty("layer");
        if (string2 != null) {
            stringBuilder.append(LAYER);
            stringBuilder.append(string2);
            stringBuilder.append("\n");
        }
        ProjectTemplateZipHelper.copyByteAfterByte(stringBuilder.toString(), fileObject);
    }

    private static void filterPlatformProperties(FileObject fileObject, ZipInputStream zipInputStream, WizardDescriptor wizardDescriptor) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FileUtil.copy((InputStream)zipInputStream, (OutputStream)byteArrayOutputStream);
        String string = byteArrayOutputStream.toString("UTF-8");
        string = string.replace(PLATFORM_ID_PARAM, ProjectTemplateZipHelper.getActivePlatform(wizardDescriptor));
        ProjectTemplateZipHelper.copyByteAfterByte(string, fileObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void filterProjectXML(FileObject fileObject, ZipInputStream zipInputStream, String string) throws IOException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            FileUtil.copy((InputStream)zipInputStream, (OutputStream)byteArrayOutputStream);
            Document document = XMLUtil.parse((InputSource)new InputSource(new ByteArrayInputStream(byteArrayOutputStream.toByteArray())), (boolean)false, (boolean)false, null, null);
            NodeList nodeList = document.getDocumentElement().getElementsByTagName(CODE_NAME_BASE);
            if (nodeList != null) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element element = (Element)nodeList.item(i);
                    if (element.getParentNode() == null || !DATA.equals(element.getParentNode().getNodeName())) continue;
                    NodeList nodeList2 = element.getChildNodes();
                    if (nodeList2.getLength() <= 0) break;
                    nodeList2.item(0).setNodeValue(string);
                    break;
                }
            }
            OutputStream outputStream = fileObject.getOutputStream();
            try {
                XMLUtil.write((Document)document, (OutputStream)outputStream, (String)"UTF-8");
            }
            finally {
                outputStream.close();
            }
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
            ProjectTemplateZipHelper.copyByteAfterByte(zipInputStream, fileObject);
        }
    }
}

