/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.ui;

import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.netbeans.modules.websvc.saas.codegen.ui.SoapClientEditorDrop;
import org.netbeans.modules.websvc.saas.codegen.ui.SoapServiceClientEditorDrop;
import org.netbeans.modules.websvc.saas.model.WsdlSaas;
import org.netbeans.modules.websvc.saas.model.WsdlSaasMethod;
import org.netbeans.modules.websvc.saas.spi.ConsumerFlavorProvider;
import org.openide.util.Exceptions;
import org.openide.util.datatransfer.ExTransferable;

public class SoapClientFlavorProvider
implements ConsumerFlavorProvider {
    public Transferable addDataFlavors(Transferable transferable) {
        try {
            Object object;
            if (transferable.isDataFlavorSupported(ConsumerFlavorProvider.WSDL_METHOD_FLAVOR)) {
                Object object2 = transferable.getTransferData(ConsumerFlavorProvider.WSDL_METHOD_FLAVOR);
                if (object2 instanceof WsdlSaasMethod) {
                    WsdlSaasMethod wsdlSaasMethod = (WsdlSaasMethod)object2;
                    ExTransferable exTransferable = ExTransferable.create((Transferable)transferable);
                    SoapClientEditorDrop soapClientEditorDrop = new SoapClientEditorDrop(wsdlSaasMethod);
                    ActiveEditorDropTransferable activeEditorDropTransferable = new ActiveEditorDropTransferable(soapClientEditorDrop);
                    exTransferable.put((ExTransferable.Single)activeEditorDropTransferable);
                    return exTransferable;
                }
            } else if (transferable.isDataFlavorSupported(ConsumerFlavorProvider.WSDL_SERVICE_FLAVOR) && (object = transferable.getTransferData(ConsumerFlavorProvider.WSDL_SERVICE_FLAVOR)) instanceof WsdlSaas) {
                WsdlSaas wsdlSaas = (WsdlSaas)object;
                URL uRL = this.getWsdlLocationURL(wsdlSaas);
                if (uRL == null) {
                    return transferable;
                }
                ExTransferable exTransferable = ExTransferable.create((Transferable)transferable);
                SoapServiceClientEditorDrop soapServiceClientEditorDrop = new SoapServiceClientEditorDrop(wsdlSaas);
                ServiceActiveEditorDropTransferable serviceActiveEditorDropTransferable = new ServiceActiveEditorDropTransferable(soapServiceClientEditorDrop);
                exTransferable.put((ExTransferable.Single)serviceActiveEditorDropTransferable);
                return exTransferable;
            }
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
        return transferable;
    }

    private URL getWsdlLocationURL(WsdlSaas wsdlSaas) {
        URL uRL = null;
        String string = wsdlSaas.getWsdlData().getWsdlFile();
        if (string == null) {
            return null;
        }
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(string);
            try {
                uRL = file.getCanonicalFile().toURI().normalize().toURL();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return uRL;
    }

    private static class ServiceActiveEditorDropTransferable
    extends ExTransferable.Single {
        private SoapServiceClientEditorDrop drop;

        ServiceActiveEditorDropTransferable(SoapServiceClientEditorDrop soapServiceClientEditorDrop) {
            super(SoapServiceClientEditorDrop.FLAVOR);
            this.drop = soapServiceClientEditorDrop;
        }

        public Object getData() {
            return this.drop;
        }
    }

    private static class ActiveEditorDropTransferable
    extends ExTransferable.Single {
        private SoapClientEditorDrop drop;

        ActiveEditorDropTransferable(SoapClientEditorDrop soapClientEditorDrop) {
            super(SoapClientEditorDrop.FLAVOR);
            this.drop = soapClientEditorDrop;
        }

        public Object getData() {
            return this.drop;
        }
    }
}

