/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.ide;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import org.netbeans.modules.j2ee.deployment.profiler.api.ProfilerSupport;
import org.netbeans.modules.j2ee.jboss4.ide.JBDeploymentStatus;
import org.netbeans.modules.j2ee.jboss4.ide.JBStartServer;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public final class JBLogWriter {
    private static final Logger LOGGER = Logger.getLogger(JBLogWriter.class.getName());
    private static final int DELAY = 500;
    private static final int START_TIMEOUT = 900000;
    private final Object READER_LOCK = new Object();
    private final Object START_LOCK = new Object();
    private LOGGER_TYPE type;
    private static final String THREAD_NAME = "JBoss Log Writer";
    private static final String STOPPER_THREAD_NAME = "JBoss Log Writer Stopper";
    private JBStartServer.ACTION_STATUS actionStatus = JBStartServer.ACTION_STATUS.UNKNOWN;
    JBStartServer startServer;
    private final OutputWriter out;
    private final OutputWriter err;
    private volatile BufferedReader reader;
    private volatile BufferedReader errorReader;
    private final String instanceName;
    private Process process;
    private File logFile;
    private LogThread logWriterThread;
    private static HashMap<String, JBLogWriter> instances = new HashMap();
    private LineReader lineReader = new LineReader();
    private LineReader errorLineReader = null;

    private JBLogWriter(InputOutput inputOutput, String string) {
        this.out = inputOutput != null ? inputOutput.getOut() : null;
        this.err = inputOutput != null ? inputOutput.getErr() : null;
        this.instanceName = string;
    }

    public static synchronized JBLogWriter createInstance(InputOutput inputOutput, String string) {
        JBLogWriter jBLogWriter = JBLogWriter.getInstance(string);
        if (jBLogWriter == null) {
            jBLogWriter = new JBLogWriter(inputOutput, string);
            instances.put(string, jBLogWriter);
        }
        return jBLogWriter;
    }

    public static synchronized JBLogWriter getInstance(String string) {
        return instances.get(string);
    }

    public void start(File file) {
        try {
            this.logFile = file;
            this.reader = new BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOGGER.log(Level.INFO, null, fileNotFoundException);
        }
        this.startWriter(new LineProcessor(){

            public void processLine(String string) {
                if (JBLogWriter.this.out != null && string != null && string.indexOf(" INFO ") != -1) {
                    JBLogWriter.this.out.println(string);
                }
            }

            public void close() {
                JBLogWriter.this.out.close();
            }
        }, null, LOGGER_TYPE.FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JBStartServer.ACTION_STATUS start(Process process, JBStartServer jBStartServer) {
        this.process = process;
        this.startServer = jBStartServer;
        this.reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        this.errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        this.errorLineReader = new LineReader();
        this.startWriter(new LineProcessor(){
            private boolean checkStartProgress = true;

            public void processLine(String string) {
                if (string != null) {
                    if (JBLogWriter.this.out != null) {
                        JBLogWriter.this.out.println(string);
                    }
                    if (this.checkStartProgress) {
                        this.checkStartProgress(string);
                    }
                }
            }

            public void close() {
                JBLogWriter.this.out.close();
            }

            private void checkStartProgress(String string) {
                if (string.indexOf("Starting JBoss (MX MicroKernel)") > -1 || string.indexOf("Starting JBoss (Microcontainer)") > -1) {
                    LOGGER.log(Level.FINER, "STARTING message fired");
                    JBLogWriter.this.fireStartProgressEvent(StateType.RUNNING, JBLogWriter.this.createProgressMessage("MSG_START_SERVER_IN_PROGRESS"));
                } else if ((string.indexOf("JBoss (MX MicroKernel)") > -1 || string.indexOf("JBoss (Microcontainer)") > -1) && string.indexOf("Started in") > -1) {
                    LOGGER.log(Level.FINER, "STARTED message fired");
                    this.checkStartProgress = false;
                    JBLogWriter.this.actionStatus = JBStartServer.ACTION_STATUS.SUCCESS;
                    JBLogWriter.this.notifyStartupThread();
                } else if (string.indexOf("Shutdown complete") > -1) {
                    this.checkStartProgress = false;
                    JBLogWriter.this.actionStatus = JBStartServer.ACTION_STATUS.FAILURE;
                    JBLogWriter.this.notifyStartupThread();
                }
            }
        }, new LineProcessor(){

            public void processLine(String string) {
                if (string != null && JBLogWriter.this.err != null) {
                    JBLogWriter.this.err.println(string);
                }
            }

            public void close() {
                JBLogWriter.this.err.close();
            }
        }, LOGGER_TYPE.PROCESS);
        try {
            Object object = this.START_LOCK;
            synchronized (object) {
                long l = System.currentTimeMillis();
                this.START_LOCK.wait(900000L);
                if (System.currentTimeMillis() - l >= 900000L) {
                    LOGGER.log(Level.FINER, "Startup thread TIMEOUT EXPIRED");
                    this.actionStatus = JBStartServer.ACTION_STATUS.UNKNOWN;
                } else {
                    LOGGER.log(Level.FINER, "Startup thread NOTIFIED");
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.actionStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyStartupThread() {
        Object object = this.START_LOCK;
        synchronized (object) {
            this.START_LOCK.notify();
        }
    }

    private void fireStartProgressEvent(StateType stateType, String string) {
        this.startServer.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.START, stateType, string));
    }

    private String createProgressMessage(String string) {
        return NbBundle.getMessage(JBLogWriter.class, (String)string, (Object)this.instanceName);
    }

    private synchronized void startWriter(LineProcessor lineProcessor, LineProcessor lineProcessor2, LOGGER_TYPE lOGGER_TYPE) {
        if (this.isRunning() || this.logWriterThread != null && this.logWriterThread.isAlive()) {
            this.logWriterThread.interrupt();
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, "INTERRUPT thread " + this.logWriterThread.getId());
            }
        }
        this.type = lOGGER_TYPE;
        this.logWriterThread = new LogThread(THREAD_NAME, lineProcessor, lineProcessor2);
        this.logWriterThread.start();
    }

    synchronized void stop() {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "Stopping " + this.logWriterThread.getId());
        }
        if (this.logWriterThread != null) {
            this.logWriterThread.finish();
        }
    }

    synchronized boolean isRunning() {
        return this.logWriterThread != null && this.logWriterThread.isRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        if (this.type == LOGGER_TYPE.PROCESS || this.logFile == null) {
            return;
        }
        Object object = this.READER_LOCK;
        synchronized (object) {
            if (this.reader != null) {
                try {
                    this.reader.close();
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.INFO, null, iOException);
                }
            }
            try {
                if (this.out != null) {
                    this.out.reset();
                }
                LOGGER.log(Level.FINER, "REFRESHING the output pane");
                this.reader = new BufferedReader(new FileReader(this.logFile));
            }
            catch (IOException iOException) {
                LOGGER.log(Level.INFO, null, iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processInput(LineProcessor lineProcessor, LineProcessor lineProcessor2, LOGGER_TYPE lOGGER_TYPE) {
        Object object = this.READER_LOCK;
        synchronized (object) {
            boolean bl = false;
            try {
                if (lOGGER_TYPE == LOGGER_TYPE.PROCESS) {
                    while (this.reader.ready()) {
                        bl = this.lineReader.readLine(this.reader, lineProcessor);
                    }
                    if (this.errorReader != null && this.errorLineReader != null) {
                        while (this.errorReader.ready()) {
                            this.errorLineReader.readLine(this.errorReader, lineProcessor2);
                        }
                    }
                } else {
                    while (this.reader.ready()) {
                        String string = this.reader.readLine();
                        lineProcessor.processLine(string);
                        bl = true;
                    }
                }
            }
            catch (IOException iOException) {
                LOGGER.log(Level.INFO, null, iOException);
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForServerProcessFinished(long l) {
        RequestProcessor.Task task = new RequestProcessor(STOPPER_THREAD_NAME, 1, true).post(new Runnable(){

            public void run() {
                try {
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.log(Level.FINER, "JBoss Log Writer Stopper: WAITING for the server process to stop");
                    }
                    if (JBLogWriter.this.type == LOGGER_TYPE.PROCESS) {
                        JBLogWriter.this.process.waitFor();
                    } else {
                        Thread.sleep(2000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        try {
            task.waitFinished(l);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            task.cancel();
        }
    }

    private class LogThread
    extends Thread {
        private final LineProcessor lineProcessor;
        private final LineProcessor errorLineProcessor;
        private volatile boolean read;

        public LogThread(String string, LineProcessor lineProcessor, LineProcessor lineProcessor2) {
            super(string);
            this.read = true;
            this.lineProcessor = lineProcessor;
            this.errorLineProcessor = lineProcessor2;
        }

        public boolean isRunning() {
            return this.read;
        }

        public void finish() {
            this.read = false;
        }

        public void run() {
            boolean bl;
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, "START thread " + Thread.currentThread().getId());
            }
            boolean bl2 = false;
            long l = -1L;
            boolean bl3 = bl = JBLogWriter.this.startServer != null && JBLogWriter.this.startServer.getMode() == JBStartServer.MODE.PROFILE;
            while (this.read) {
                int n;
                if (bl) {
                    n = ProfilerSupport.getState();
                    if (n == 2 || n == 3 || n == 4) {
                        JBLogWriter.this.fireStartProgressEvent(StateType.COMPLETED, JBLogWriter.this.createProgressMessage("MSG_PROFILED_SERVER_STARTED"));
                        bl = false;
                        JBLogWriter.this.notifyStartupThread();
                    } else if (n == 0) {
                        JBLogWriter.this.fireStartProgressEvent(StateType.FAILED, JBLogWriter.this.createProgressMessage("MSG_START_PROFILED_SERVER_FAILED"));
                        JBLogWriter.this.process.destroy();
                        JBLogWriter.this.notifyStartupThread();
                        break;
                    }
                }
                n = JBLogWriter.this.processInput(this.lineProcessor, this.errorLineProcessor, JBLogWriter.this.type) ? 1 : 0;
                if (JBLogWriter.this.type == LOGGER_TYPE.FILE) {
                    if (n != 0) {
                        l = JBLogWriter.this.logFile.length();
                    } else if (l != JBLogWriter.this.logFile.length()) {
                        LOGGER.log(Level.FINER, "DIFFERENCE found");
                        JBLogWriter.this.refresh();
                    }
                } else {
                    try {
                        JBLogWriter.this.process.exitValue();
                        break;
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        // empty catch block
                    }
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                if (!Thread.currentThread().isInterrupted()) continue;
                bl2 = true;
                break;
            }
            this.lineProcessor.processLine(JBLogWriter.this.lineReader.getTrailingLine());
            if (this.errorLineProcessor != null && JBLogWriter.this.errorLineReader != null) {
                this.errorLineProcessor.processLine(JBLogWriter.this.errorLineReader.getTrailingLine());
            }
            this.lineProcessor.close();
            if (this.errorLineProcessor != null) {
                this.errorLineProcessor.close();
            } else {
                JBLogWriter.this.err.close();
            }
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, "FINISH thread " + Thread.currentThread().getId());
            }
            if (!bl2) {
                this.read = false;
                instances.remove(JBLogWriter.this.instanceName);
            }
        }
    }

    private static class LineReader {
        private String trailingLine = "";

        private LineReader() {
        }

        public String getTrailingLine() {
            return this.trailingLine;
        }

        private boolean readLine(BufferedReader bufferedReader, LineProcessor lineProcessor) throws IOException {
            char[] cArray = new char[128];
            int n = -1;
            n = bufferedReader.read(cArray);
            if (n != -1) {
                String string = this.trailingLine != null ? this.trailingLine : "";
                string = string + new String(cArray, 0, n);
                int n2 = this.trailingLine != null ? this.trailingLine.length() : 0;
                int n3 = 0;
                for (int i = 0; i < n; ++i) {
                    String string2;
                    if (cArray[i] == '\r' && (i + 1 == n || cArray[i + 1] != '\n') || cArray[i] == '\n') {
                        string2 = string.substring(n3, n2 + i);
                        n3 = n2 + (i + 1);
                        if (lineProcessor == null) continue;
                        lineProcessor.processLine(string2);
                        continue;
                    }
                    if (cArray[i] != '\r' || i + 1 >= n || cArray[i + 1] != '\n') continue;
                    string2 = string.substring(n3, n2 + i);
                    n3 = n2 + (++i + 1);
                    if (lineProcessor == null) continue;
                    lineProcessor.processLine(string2);
                }
                this.trailingLine = n3 < string.length() ? string.substring(n3) : null;
                return true;
            }
            return false;
        }
    }

    private static interface LineProcessor {
        public void processLine(String var1);

        public void close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum LOGGER_TYPE {
        PROCESS,
        FILE;

    }
}

