/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.ide;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.modules.j2ee.common.DatasourceHelper;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.plugins.spi.JDBCDriverDeployer;
import org.netbeans.modules.j2ee.jboss4.JBDeploymentManager;
import org.netbeans.modules.j2ee.jboss4.ide.JBDeploymentStatus;
import org.netbeans.modules.j2ee.jboss4.util.JBProperties;
import org.netbeans.modules.j2ee.jboss4.util.ProgressEventSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBDriverDeployer
implements JDBCDriverDeployer {
    private static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.j2ee.jboss4");
    private final JBDeploymentManager manager;

    public JBDriverDeployer(JBDeploymentManager jBDeploymentManager) {
        this.manager = jBDeploymentManager;
    }

    public boolean supportsDeployJDBCDrivers(Target target) {
        return true;
    }

    public ProgressObject deployJDBCDrivers(Target target, Set<Datasource> set) {
        return new DriverDeploymentProgressObject(set);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DriverDeploymentProgressObject
    implements ProgressObject,
    Runnable {
        private final ProgressEventSupport eventSupport;
        private final Set<Datasource> datasources;

        public DriverDeploymentProgressObject(Set<Datasource> set) {
            this.eventSupport = new ProgressEventSupport(JBDriverDeployer.this);
            this.datasources = set;
            String string = NbBundle.getMessage(JBDriverDeployer.class, (String)"MSG_CheckingMissingDrivers");
            this.eventSupport.fireProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.RUNNING, string));
            RequestProcessor.getDefault().post((Runnable)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            List<FileObject> list = this.jdbcDriversToDeploy();
            if (!list.isEmpty()) {
                JBProperties jBProperties = JBDriverDeployer.this.manager.getProperties();
                for (FileObject fileObject : list) {
                    String string;
                    File file = jBProperties.getLibsDir();
                    File file2 = new File(file, fileObject.getNameExt());
                    try {
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileObject.getInputStream());
                        try {
                            string = NbBundle.getMessage(JBDriverDeployer.class, (String)"MSG_DeployingJDBCDrivers", (Object)file2.getPath());
                            this.eventSupport.fireProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.RUNNING, string));
                            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
                            try {
                                FileUtil.copy((InputStream)bufferedInputStream, (OutputStream)bufferedOutputStream);
                            }
                            finally {
                                bufferedOutputStream.close();
                            }
                        }
                        finally {
                            bufferedInputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        LOGGER.log(Level.INFO, null, iOException);
                        string = NbBundle.getMessage(JBDriverDeployer.class, (String)"MSG_DeployingJDBCDriversFailed", (Object)file2.getPath(), (Object)file.getPath());
                        this.eventSupport.fireProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, string));
                        return;
                    }
                }
                JBDriverDeployer.this.manager.setNeedsRestart(true);
            }
            this.eventSupport.fireProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.COMPLETED, ""));
        }

        private List<FileObject> jdbcDriversToDeploy() {
            ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
            Collection<File> collection = this.getJDBCDriverClasspath();
            for (Datasource datasource : this.datasources) {
                String string = datasource.getDriverClassName();
                boolean bl = false;
                try {
                    bl = Util.containsClass(collection, (String)string);
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.INFO, null, iOException);
                }
                if (bl) continue;
                for (DatabaseConnection databaseConnection : DatasourceHelper.findDatabaseConnections((Datasource)datasource)) {
                    JDBCDriver[] jDBCDriverArray;
                    JDBCDriver jDBCDriver = databaseConnection.getJDBCDriver();
                    if (jDBCDriver != null) {
                        jDBCDriverArray = new JDBCDriver[]{jDBCDriver};
                    } else {
                        JDBCDriver[] jDBCDriverArray2 = databaseConnection.getDriverClass();
                        jDBCDriverArray = JDBCDriverManager.getDefault().getDrivers((String)jDBCDriverArray2);
                    }
                    for (JDBCDriver jDBCDriver2 : jDBCDriverArray) {
                        for (URL uRL : jDBCDriver2.getURLs()) {
                            FileObject fileObject = URLMapper.findFileObject((URL)uRL);
                            if (fileObject == null) continue;
                            arrayList.add(fileObject);
                        }
                    }
                }
            }
            return arrayList;
        }

        private Collection<File> getJDBCDriverClasspath() {
            JBProperties jBProperties = JBDriverDeployer.this.manager.getProperties();
            return Arrays.asList(jBProperties.getLibsDir().listFiles());
        }

        public DeploymentStatus getDeploymentStatus() {
            return this.eventSupport.getDeploymentStatus();
        }

        public TargetModuleID[] getResultTargetModuleIDs() {
            return null;
        }

        public ClientConfiguration getClientConfiguration(TargetModuleID targetModuleID) {
            return null;
        }

        public boolean isCancelSupported() {
            return false;
        }

        public void cancel() throws OperationUnsupportedException {
            throw new OperationUnsupportedException("Cancel is not supported");
        }

        public boolean isStopSupported() {
            return false;
        }

        public void stop() throws OperationUnsupportedException {
            throw new OperationUnsupportedException("Stop is not supported");
        }

        public void addProgressListener(ProgressListener progressListener) {
            this.eventSupport.addProgressListener(progressListener);
        }

        public void removeProgressListener(ProgressListener progressListener) {
            this.eventSupport.removeProgressListener(progressListener);
        }
    }
}

