/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.dirchooser;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FileChooserUI;
import javax.swing.plaf.metal.MetalFileChooserUI;
import org.netbeans.swing.dirchooser.DirectoryChooserUI;
import org.netbeans.swing.dirchooser.Module;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingChooserUI
extends ComponentUI {
    static final String USE_SHELL_FOLDER = "FileChooser.useShellFolder";
    static final String NB_USE_SHELL_FOLDER = "nb.FileChooser.useShellFolder";
    static final String START_TIME = "start.time";
    private static boolean firstTime = true;

    public static ComponentUI createUI(JComponent jComponent) {
        ComponentUI componentUI;
        Object object;
        JFileChooser jFileChooser = (JFileChooser)jComponent;
        if (Utilities.isWindows()) {
            if (System.getProperty(NB_USE_SHELL_FOLDER) != null) {
                jFileChooser.putClientProperty(USE_SHELL_FOLDER, Boolean.getBoolean(NB_USE_SHELL_FOLDER));
            } else {
                object = System.getProperty("java.version");
                if ("1.6.0_02".compareToIgnoreCase((String)(object = ((String)object).split("-", 2)[0])) <= 0 && "1.6.0_10".compareToIgnoreCase((String)object) >= 0 && !Boolean.TRUE.equals(jFileChooser.getClientProperty(USE_SHELL_FOLDER))) {
                    jFileChooser.putClientProperty(USE_SHELL_FOLDER, Boolean.FALSE);
                }
            }
        }
        if (jFileChooser.getClientProperty(START_TIME) == null) {
            jFileChooser.putClientProperty(START_TIME, System.currentTimeMillis());
        }
        object = DelegatingChooserUI.getCurChooser(jFileChooser);
        try {
            Method method = ((Class)object).getMethod("createUI", JComponent.class);
            componentUI = (ComponentUI)method.invoke(null, jFileChooser);
        }
        catch (Exception exception) {
            Logger.getLogger(DelegatingChooserUI.class.getName()).log(Level.FINE, "Could not instantiate custom chooser, fallbacking to Metal", exception);
            componentUI = MetalFileChooserUI.createUI(jComponent);
        }
        if (firstTime) {
            jFileChooser.addPropertyChangeListener("fileSelectionChanged", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    JFileChooser jFileChooser = (JFileChooser)propertyChangeEvent.getSource();
                    jFileChooser.updateUI();
                }
            });
        }
        return componentUI;
    }

    private static Class<? extends FileChooserUI> getCurChooser(JFileChooser jFileChooser) {
        if (jFileChooser.getFileSelectionMode() == 1) {
            return DirectoryChooserUI.class;
        }
        return Module.getOrigChooser();
    }
}

