/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.spi.project.SourceGroupModifierImplementation;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.SourcesHelper;
import org.openide.util.ChangeSupport;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public class WebSources
implements Sources,
PropertyChangeListener,
ChangeListener {
    private static final String BUILD_DIR_PROP = "${build.dir}";
    private static final String DIST_DIR_PROP = "${dist.dir}";
    private final Project project;
    private final AntProjectHelper helper;
    private final PropertyEvaluator evaluator;
    private final SourceRoots sourceRoots;
    private final SourceRoots testRoots;
    private Sources delegate;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private boolean dirty;
    private volatile Map<String, SourceGroup[]> cachedGroups = new HashMap<String, SourceGroup[]>();
    private long eventId;
    SourceGroupModifierImplementation sgmi;

    WebSources(Project project, AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator, SourceRoots sourceRoots, SourceRoots sourceRoots2) {
        this.project = project;
        this.helper = antProjectHelper;
        this.evaluator = propertyEvaluator;
        this.sourceRoots = sourceRoots;
        this.testRoots = sourceRoots2;
        this.sourceRoots.addPropertyChangeListener((PropertyChangeListener)this);
        this.testRoots.addPropertyChangeListener((PropertyChangeListener)this);
        this.evaluator.addPropertyChangeListener((PropertyChangeListener)this);
        this.delegate = this.initSources();
    }

    public SourceGroup[] getSourceGroups(final String string) {
        SourceGroup[] sourceGroupArray = this.cachedGroups.get(string);
        if (sourceGroupArray != null) {
            return sourceGroupArray;
        }
        return (SourceGroup[])ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<SourceGroup[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public SourceGroup[] run() {
                SourceGroup[] sourceGroupArray = WebSources.this;
                synchronized (WebSources.this) {
                    if (WebSources.this.dirty) {
                        WebSources.this.delegate.removeChangeListener((ChangeListener)WebSources.this);
                        WebSources.this.delegate = WebSources.this.initSources();
                        WebSources.this.delegate.addChangeListener((ChangeListener)WebSources.this);
                        WebSources.this.dirty = false;
                    }
                    Sources sources = WebSources.this.delegate;
                    long l = ++WebSources.this.eventId;
                    // ** MonitorExit[var4_1] (shouldn't be in output)
                    sourceGroupArray = sources.getSourceGroups(string);
                    WebSources webSources = WebSources.this;
                    synchronized (webSources) {
                        if (l == WebSources.this.eventId) {
                            WebSources.this.cachedGroups.put(string, sourceGroupArray);
                        }
                    }
                    return sourceGroupArray;
                }
            }
        });
    }

    SourceGroupModifierImplementation getSourceGroupModifierImplementation() {
        return this.sgmi;
    }

    private Sources initSources() {
        SourcesHelper sourcesHelper = new SourcesHelper(this.project, this.helper, this.evaluator);
        this.register(sourcesHelper, this.sourceRoots, "main");
        this.register(sourcesHelper, this.testRoots, "test");
        String string = NbBundle.getMessage(WebSources.class, (String)"LBL_Node_WebModule");
        String string2 = NbBundle.getMessage(WebSources.class, (String)"LBL_Node_DocBase");
        String string3 = NbBundle.getMessage(WebSources.class, (String)"LBL_Node_WebInf");
        String string4 = "${includes}";
        String string5 = "${excludes}";
        sourcesHelper.sourceRoot("${source.root}").displayName(string).add();
        sourcesHelper.sourceRoot("${web.docbase.dir}").includes(string4).excludes(string5).displayName(string2).add().type("doc_root").add();
        sourcesHelper.sourceRoot("${webinf.dir}").type("web_inf").displayName(string3).add();
        sourcesHelper.addNonSourceRoot(BUILD_DIR_PROP);
        sourcesHelper.addNonSourceRoot(DIST_DIR_PROP);
        sourcesHelper.registerExternalRoots(0);
        this.sgmi = sourcesHelper.createSourceGroupModifierImplementation();
        return sourcesHelper.createSources();
    }

    private void register(SourcesHelper sourcesHelper, SourceRoots sourceRoots, String string) {
        String[] stringArray = sourceRoots.getRootProperties();
        String[] stringArray2 = sourceRoots.getRootNames();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            String string3 = sourceRoots.getRootDisplayName(stringArray2[i], string2);
            String string4 = "${" + string2 + "}";
            String string5 = "${includes}";
            String string6 = "${excludes}";
            sourcesHelper.sourceRoot(string4).includes(string5).excludes(string6).hint(string).displayName(string3).add().type("java").add();
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        WebSources webSources = this;
        synchronized (webSources) {
            this.cachedGroups.clear();
            this.dirty = true;
        }
        this.changeSupport.fireChange();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (SourceRoots.PROP_ROOTS.equals(string) || "build.dir".equals(string) || "dist.dir".equals(string)) {
            this.fireChange();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.fireChange();
    }
}

