/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.layers;

import java.beans.PropertyVetoException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.Stamps;
import org.netbeans.core.startup.Main;
import org.netbeans.core.startup.StartLog;
import org.netbeans.core.startup.layers.BinaryCacheManager;
import org.netbeans.core.startup.layers.ModuleLayeredFileSystem;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.XMLFileSystem;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LayerCacheManager {
    static final Logger err = Logger.getLogger("org.netbeans.core.projects.cache");
    private static final LayerCacheManager mgr = new BinaryCacheManager();
    private static final LayerCacheManager non = new NonCacheManager();

    public static LayerCacheManager manager(boolean bl) {
        return bl ? mgr : non;
    }

    public static LayerCacheManager create(String string) {
        return new BinaryCacheManager(string);
    }

    public final FileSystem loadCache() throws IOException {
        FileSystem fileSystem;
        block4: {
            String string = this.cacheLocation();
            fileSystem = null;
            if (string != null) {
                Main.setStatusText(NbBundle.getMessage(ModuleLayeredFileSystem.class, (String)"MSG_start_load_cache"));
                MappedByteBuffer mappedByteBuffer = Stamps.getModulesJARs().asMappedByteBuffer(string);
                if (mappedByteBuffer != null) {
                    try {
                        StartLog.logStart("Loading layers");
                        fileSystem = this.load(this.createEmptyFileSystem(), mappedByteBuffer);
                        Main.setStatusText(NbBundle.getMessage(ModuleLayeredFileSystem.class, (String)"MSG_end_load_cache"));
                        StartLog.logEnd("Loading layers");
                    }
                    catch (IOException iOException) {
                        err.log(Level.WARNING, "Ignoring cache of layers");
                        if (!err.isLoggable(Level.FINE)) break block4;
                        err.log(Level.WARNING, "Ignoring cache of layers", iOException);
                    }
                }
            }
        }
        return fileSystem;
    }

    public final FileSystem store(final FileSystem fileSystem, final List<URL> list) throws IOException {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Updater
        implements FileSystem.AtomicAction,
        Stamps.Updater {
            private FileSystem toRet;
            private byte[] data;

            Updater() {
            }

            public void flushCaches(DataOutputStream dataOutputStream) throws IOException {
                err.log(Level.FINEST, "flushing layers");
                dataOutputStream.write(this.data);
                err.log(Level.FINEST, "layers flushed");
            }

            public void cacheReady() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                LayerCacheManager layerCacheManager = LayerCacheManager.this;
                synchronized (layerCacheManager) {
                    try {
                        err.log(Level.FINEST, "storing to memory {0}", list);
                        LayerCacheManager.this.store(fileSystem, list, byteArrayOutputStream);
                        this.data = byteArrayOutputStream.toByteArray();
                        ByteBuffer byteBuffer = ByteBuffer.wrap(this.data);
                        err.log(Level.FINEST, "reading from memory, size {0}", byteBuffer.limit());
                        this.toRet = LayerCacheManager.this.load(fileSystem, byteBuffer.order(ByteOrder.LITTLE_ENDIAN));
                    }
                    catch (IOException iOException) {
                        err.log(Level.WARNING, null, iOException);
                        XMLFileSystem xMLFileSystem = new XMLFileSystem();
                        try {
                            xMLFileSystem.setXmlUrls(list.toArray(new URL[0]));
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            err.log(Level.WARNING, null, propertyVetoException);
                        }
                        this.toRet = xMLFileSystem;
                    }
                }
                Stamps.getModulesJARs().scheduleSave((Stamps.Updater)this, LayerCacheManager.this.cacheLocation(), false);
            }
        }
        Updater updater = new Updater();
        FileUtil.runAtomicAction((FileSystem.AtomicAction)updater);
        return updater.toRet;
    }

    LayerCacheManager() {
    }

    public abstract FileSystem createEmptyFileSystem() throws IOException;

    public abstract FileSystem load(FileSystem var1, ByteBuffer var2) throws IOException;

    public abstract void store(FileSystem var1, List<URL> var2, OutputStream var3) throws IOException;

    abstract String cacheLocation();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NonCacheManager
    extends LayerCacheManager {
        private NonCacheManager() {
        }

        @Override
        public FileSystem createEmptyFileSystem() throws IOException {
            return new XMLFileSystem();
        }

        @Override
        public FileSystem load(FileSystem fileSystem, ByteBuffer byteBuffer) throws IOException {
            String string;
            byte[] byArray = new byte[byteBuffer.limit()];
            byteBuffer.get(byArray);
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            ArrayList<URL> arrayList = new ArrayList<URL>();
            while (dataInputStream.available() > 0) {
                string = dataInputStream.readUTF();
                arrayList.add(new URL(string));
            }
            try {
                string = (XMLFileSystem)fileSystem;
                string.setXmlUrls(arrayList.toArray(new URL[arrayList.size()]));
                return string;
            }
            catch (PropertyVetoException propertyVetoException) {
                throw (IOException)new IOException(propertyVetoException.toString()).initCause(propertyVetoException);
            }
        }

        @Override
        public void store(FileSystem fileSystem, List<URL> list, OutputStream outputStream) throws IOException {
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            for (URL uRL : list) {
                dataOutputStream.writeUTF(uRL.toExternalForm());
            }
            dataOutputStream.close();
        }

        @Override
        public String cacheLocation() {
            return "all-local-layers.dat";
        }
    }
}

