/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dbschema.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.dbschema.jdbcimpl.DBschemaDataObject;
import org.netbeans.modules.dbschema.nodes.DBElementNodeFactory;
import org.netbeans.modules.dbschema.nodes.SchemaElementFilter;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class SchemaRootChildren
extends Children.Keys {
    static final Object NOT_KEY = new Object();
    static final Object ERROR_KEY = new Object();
    protected SchemaElement element;
    protected DBElementNodeFactory factory;
    private PropertyChangeListener wPropL;
    private DBElementListener propL;
    private boolean nodesInited = false;
    private boolean parseStatus = false;
    private Object parseLock = new Object();
    private DBschemaDataObject obj;

    public SchemaRootChildren(DBElementNodeFactory dBElementNodeFactory, DBschemaDataObject dBschemaDataObject) {
        this.factory = dBElementNodeFactory;
        this.obj = dBschemaDataObject;
    }

    protected void addNotify() {
        SchemaElement schemaElement = this.getElement();
        if (schemaElement != null) {
            if (this.wPropL == null) {
                this.propL = new DBElementListener();
                this.wPropL = WeakListeners.propertyChange((PropertyChangeListener)this.propL, (Object)schemaElement);
            }
            schemaElement.addPropertyChangeListener(this.wPropL);
        }
        this.refreshKeys();
    }

    protected void removeNotify() {
        this.setKeys(Collections.EMPTY_SET);
        this.nodesInited = false;
    }

    protected Node[] createNodes(Object object) {
        if (object instanceof SchemaElement) {
            return new Node[]{this.factory.createSchemaNode((SchemaElement)object)};
        }
        if (NOT_KEY.equals(object)) {
            return new Node[]{this.factory.createWaitNode()};
        }
        Logger.getLogger("global").log(Level.INFO, null, new Exception("DbSchema: Error node created for object " + object + " (class " + (object == null ? "null" : object.getClass().getName()) + ")"));
        return new Node[]{this.factory.createErrorNode()};
    }

    public SchemaElement getElement() {
        if (this.element == null && !this.parseStatus) {
            this.refreshKeys2();
            RequestProcessor.getDefault().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object = SchemaRootChildren.this.parseLock;
                    synchronized (object) {
                        if (!SchemaRootChildren.this.parseStatus) {
                            SchemaRootChildren.this.nodesInited = true;
                            SchemaRootChildren.this.setElement(SchemaRootChildren.this.obj.getSchema());
                            SchemaRootChildren.this.parseStatus = true;
                        }
                    }
                }
            }, 0);
        }
        return this.element;
    }

    public void setElement(SchemaElement schemaElement) {
        if (this.element != null) {
            this.element.removePropertyChangeListener(this.wPropL);
        }
        this.element = schemaElement;
        if (this.element != null) {
            if (this.wPropL == null) {
                this.propL = new DBElementListener();
                this.wPropL = WeakListeners.propertyChange((PropertyChangeListener)this.propL, (Object)this.element);
            } else {
                this.wPropL = WeakListeners.propertyChange((PropertyChangeListener)this.propL, (Object)this.element);
            }
            this.element.addPropertyChangeListener(this.wPropL);
        }
        if (this.nodesInited) {
            this.refreshKeys();
        }
    }

    public void refreshKeys() {
        SchemaElement schemaElement = this.getElement();
        int n = this.parseStatus ? (schemaElement == null ? 1 : schemaElement.getStatus()) : (schemaElement == null ? 0 : schemaElement.getStatus());
        switch (n) {
            case 0: {
                this.setKeys(new Object[]{NOT_KEY});
                break;
            }
            case 1: {
                this.setKeys(new Object[]{ERROR_KEY});
                break;
            }
            case 2: 
            case 3: {
                this.refreshAllKeys();
            }
        }
    }

    private void refreshKeys2() {
        this.setKeys(new Object[]{NOT_KEY});
    }

    private void refreshAllKeys() {
        int[] nArray = SchemaElementFilter.DEFAULT_ORDER;
        final LinkedList linkedList = new LinkedList();
        for (int i = 0; i < nArray.length; ++i) {
            this.addKeysOfType(linkedList, nArray[i]);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SchemaRootChildren.this.setKeys2(Collections.EMPTY_SET);
                SchemaRootChildren.this.setKeys2(linkedList);
            }
        });
    }

    private void addKeysOfType(Collection collection, int n) {
        SchemaElement schemaElement = this.getElement();
        if (n != 0) {
            collection.add(schemaElement);
        }
    }

    private void setKeys2(Collection collection) {
        this.setKeys(collection);
    }

    private final class DBElementListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            boolean bl = "schema".equals(propertyChangeEvent.getPropertyName());
            if (!bl && "status".equals(propertyChangeEvent.getPropertyName())) {
                Integer n = (Integer)propertyChangeEvent.getNewValue();
                boolean bl2 = bl = n == null || n != 0;
            }
            if (bl) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SchemaRootChildren.this.refreshKeys();
                    }
                });
            }
        }
    }
}

