/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dbschema.jdbcimpl.wizard;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.modules.dbschema.ColumnElement;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.dbschema.TableElement;
import org.netbeans.modules.dbschema.jdbcimpl.ConnectionProvider;
import org.netbeans.modules.dbschema.jdbcimpl.DBschemaDataObject;
import org.netbeans.modules.dbschema.jdbcimpl.SchemaElementImpl;
import org.netbeans.modules.dbschema.jdbcimpl.wizard.ChooseConnectionPanel;
import org.netbeans.modules.dbschema.jdbcimpl.wizard.DBSchemaTablesPanel;
import org.netbeans.modules.dbschema.jdbcimpl.wizard.DBSchemaWizardData;
import org.netbeans.modules.dbschema.jdbcimpl.wizard.ProgressFrame;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class RecaptureSchema {
    private static final Logger LOGGER = Logger.getLogger(RecaptureSchema.class.getName());
    private static final boolean debug = Boolean.getBoolean("org.netbeans.modules.dbschema.recapture.debug");
    ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.modules.dbschema.jdbcimpl.resources.Bundle");
    private DBSchemaWizardData data;
    private Node dbSchemaNode;

    public RecaptureSchema(Node node) {
        this.dbSchemaNode = node;
        this.data = new DBSchemaWizardData();
        this.data.setExistingConn(true);
    }

    public void start() throws ClassNotFoundException, SQLException {
        boolean bl;
        final DBschemaDataObject dBschemaDataObject = (DBschemaDataObject)this.dbSchemaNode.getCookie(DBschemaDataObject.class);
        final SchemaElement schemaElement = dBschemaDataObject.getSchema();
        if (debug) {
            System.out.println("[dbschema] url='" + schemaElement.getUrl() + "'");
        }
        final FileObject fileObject = dBschemaDataObject.getPrimaryFile();
        try {
            SchemaElement.removeFromCache(schemaElement.getName().getFullName() + "#" + fileObject.getURL().toString());
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            Logger.getLogger("global").log(Level.INFO, null, fileStateInvalidException);
        }
        TableElement[] tableElementArray = schemaElement.getTables();
        final LinkedList<String> linkedList = new LinkedList<String>();
        final LinkedList<String> linkedList2 = new LinkedList<String>();
        for (bl = false; bl < tableElementArray.length; bl += 1) {
            TableElement tableElement = tableElementArray[bl];
            if (tableElement.isTable()) {
                if (debug) {
                    System.out.println("[dbschema] adding table='" + tableElement.getName() + "'");
                }
                linkedList.add(tableElement.getName().getName());
                continue;
            }
            if (debug) {
                System.out.println("[dbschema] adding view='" + tableElement.getName() + "'");
            }
            linkedList2.add(tableElement.getName().getName());
        }
        bl = this.data.isConnected();
        final boolean bl2 = this.data.isExistingConn();
        final DatabaseConnection databaseConnection = this.data.getDatabaseConnection();
        String string = schemaElement.getUrl();
        if (debug) {
            System.out.println("[dbschema] conned='" + bl + "'");
            System.out.println("[dbschema] ec='" + bl2 + "'");
            System.out.println("[dbschema] NEW dbIdentName='" + string + "'");
        }
        ConnectionProvider connectionProvider = this.createConnectionProvider(this.data, schemaElement);
        try {
            final ConnectionProvider connectionProvider2 = connectionProvider;
            if (connectionProvider2 == null) {
                String string2 = MessageFormat.format(this.bundle.getString("EXC_CouldNotCreateConnection"), schemaElement.getUrl());
                throw new SQLException(string2);
            }
            if (debug) {
                System.out.println("[dbschema] c.getConnection()='" + connectionProvider2.getConnection() + "'");
            }
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    try {
                        StatusDisplayer.getDefault().setStatusText(RecaptureSchema.this.bundle.getString("CreatingDatabaseSchema"));
                        final ProgressFrame progressFrame = new ProgressFrame();
                        final SchemaElementImpl schemaElementImpl = new SchemaElementImpl(connectionProvider2);
                        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                                if (propertyChangeEvent.getPropertyName().equals("totalCount")) {
                                    progressFrame.setMaximum((Integer)propertyChangeEvent.getNewValue());
                                    return;
                                }
                                if (propertyChangeEvent.getPropertyName().equals("progress")) {
                                    progressFrame.setValue((Integer)propertyChangeEvent.getNewValue());
                                    return;
                                }
                                if (propertyChangeEvent.getPropertyName().equals("tableName")) {
                                    String string = MessageFormat.format(RecaptureSchema.this.bundle.getString("CapturingTable"), ((String)propertyChangeEvent.getNewValue()).toUpperCase());
                                    progressFrame.setMessage(string);
                                    return;
                                }
                                if (propertyChangeEvent.getPropertyName().equals("FKt")) {
                                    String string = MessageFormat.format(RecaptureSchema.this.bundle.getString("CaptureFK"), ((String)propertyChangeEvent.getNewValue()).toUpperCase(), RecaptureSchema.this.bundle.getString("CaptureFKtable"));
                                    progressFrame.setMessage(string);
                                    return;
                                }
                                if (propertyChangeEvent.getPropertyName().equals("FKv")) {
                                    String string = MessageFormat.format(RecaptureSchema.this.bundle.getString("CaptureFK"), ((String)propertyChangeEvent.getNewValue()).toUpperCase(), RecaptureSchema.this.bundle.getString("CaptureFKview"));
                                    progressFrame.setMessage(string);
                                    return;
                                }
                                if (propertyChangeEvent.getPropertyName().equals("viewName")) {
                                    String string = MessageFormat.format(RecaptureSchema.this.bundle.getString("CapturingView"), ((String)propertyChangeEvent.getNewValue()).toUpperCase());
                                    progressFrame.setMessage(string);
                                    return;
                                }
                                if (propertyChangeEvent.getPropertyName().equals("cancel")) {
                                    schemaElementImpl.setStop(true);
                                    StatusDisplayer.getDefault().setStatusText("");
                                    return;
                                }
                            }
                        };
                        progressFrame.propertySupport.addPropertyChangeListener(propertyChangeListener);
                        progressFrame.setVisible(true);
                        schemaElementImpl.propertySupport.addPropertyChangeListener(propertyChangeListener);
                        final SchemaElement schemaElement2 = new SchemaElement(schemaElementImpl);
                        schemaElement2.setName(schemaElement.getName());
                        schemaElementImpl.initTables(connectionProvider2, linkedList, linkedList2, false);
                        progressFrame.finishProgress();
                        if (!schemaElementImpl.isStop()) {
                            fileObject.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                                public void run() throws IOException {
                                    FileLock fileLock;
                                    OutputStream outputStream;
                                    if (debug) {
                                        System.out.println("SchemaElement: " + RecaptureSchema.this.dumpSe(schemaElement2));
                                    }
                                    if ((outputStream = fileObject.getOutputStream(fileLock = fileObject.lock())) == null) {
                                        throw new IOException("Unable to open output stream");
                                    }
                                    progressFrame.setMessage(RecaptureSchema.this.bundle.getString("SavingDatabaseSchema"));
                                    StatusDisplayer.getDefault().setStatusText(RecaptureSchema.this.bundle.getString("SavingDatabaseSchema"));
                                    schemaElement2.save(outputStream);
                                    fileLock.releaseLock();
                                }
                            });
                            SchemaElement.addToCache(schemaElement2);
                            dBschemaDataObject.setSchemaElementImpl(schemaElementImpl);
                            dBschemaDataObject.setSchema(schemaElement2);
                            progressFrame.setMessage(RecaptureSchema.this.bundle.getString("SchemaSaved"));
                            StatusDisplayer.getDefault().setStatusText(RecaptureSchema.this.bundle.getString("SchemaSaved"));
                            progressFrame.setVisible(false);
                            progressFrame.dispose();
                        }
                        if (bl) {
                            if (bl2) {
                                ConnectionManager.getDefault().disconnect(databaseConnection);
                            } else {
                                connectionProvider2.closeConnection();
                            }
                        }
                    }
                    catch (Exception exception) {
                        Exceptions.printStackTrace((Throwable)exception);
                    }
                }
            }, 0);
        }
        catch (Exception exception) {
            String string3 = MessageFormat.format(this.bundle.getString("UnableToCreateSchema"), exception.getMessage());
            StatusDisplayer.getDefault().setStatusText(string3);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Exception((Throwable)exception, (Object)exception.getMessage()));
            LOGGER.log(Level.INFO, null, exception);
            try {
                if (connectionProvider != null) {
                    connectionProvider.closeConnection();
                }
                if (this.data.isConnected()) {
                    if (this.data.isExistingConn()) {
                        ConnectionManager.getDefault().disconnect(this.data.getDatabaseConnection());
                    } else {
                        connectionProvider.closeConnection();
                    }
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    private String dumpSe(SchemaElement schemaElement) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("name " + schemaElement.getName());
        stringBuffer.append("\n");
        stringBuffer.append("driver " + schemaElement.getDriverName());
        stringBuffer.append("\n");
        stringBuffer.append("username " + schemaElement.getUsername());
        stringBuffer.append("\n");
        TableElement[] tableElementArray = schemaElement.getTables();
        stringBuffer.append("tables count " + tableElementArray.length);
        stringBuffer.append("\n");
        for (int i = 0; i < tableElementArray.length; ++i) {
            stringBuffer.append("    table " + tableElementArray[i].getName());
            stringBuffer.append("\n");
            ColumnElement[] columnElementArray = tableElementArray[i].getColumns();
            for (int j = 0; j < columnElementArray.length; ++j) {
                stringBuffer.append("        column " + columnElementArray[j].getName());
                stringBuffer.append("\n");
            }
        }
        return stringBuffer.toString();
    }

    public ConnectionProvider createConnectionProvider(DBSchemaWizardData dBSchemaWizardData, SchemaElement schemaElement) throws SQLException {
        DatabaseConnection databaseConnection = this.findDatabaseConnection(schemaElement);
        if (databaseConnection == null) {
            if (debug) {
                System.out.println("[dbschema-ccp] not found dbconn='" + databaseConnection + "'");
            }
            String string = MessageFormat.format(this.bundle.getString("EXC_CouldNotCreateConnection"), schemaElement.getUrl());
            throw new SQLException(string);
        }
        if (debug) {
            System.out.println("[dbschema-ccp] found dbconn='" + databaseConnection.getDatabaseURL() + "'");
        }
        dBSchemaWizardData.setDatabaseConnection(databaseConnection);
        ConnectionHandler connectionHandler = new ConnectionHandler(dBSchemaWizardData);
        if (connectionHandler.ensureConnection()) {
            databaseConnection = dBSchemaWizardData.getDatabaseConnection();
            if (debug) {
                System.out.println("[dbschema-ccp] connection ensured ='" + databaseConnection.getDatabaseURL() + "'");
            }
            ConnectionProvider connectionProvider = new ConnectionProvider(databaseConnection.getJDBCConnection(), databaseConnection.getDriverClass());
            connectionProvider.setSchema(databaseConnection.getSchema());
            return connectionProvider;
        }
        if (debug) {
            System.out.println("[dbschema-ccp] connection not ensured, returning null");
        }
        String string = MessageFormat.format(this.bundle.getString("EXC_UnableToConnect"), schemaElement.getUrl());
        throw new SQLException(string);
    }

    private DatabaseConnection findDatabaseConnection(final SchemaElement schemaElement) {
        DatabaseConnection[] databaseConnectionArray = ConnectionManager.getDefault().getConnections();
        String string = RecaptureSchema.trimUrl(schemaElement.getUrl());
        for (int i = 0; i < databaseConnectionArray.length; ++i) {
            String string2 = databaseConnectionArray[i].getDatabaseURL();
            if (string2 == null || !string2.startsWith(string)) continue;
            return databaseConnectionArray[i];
        }
        DatabaseConnection databaseConnection = (DatabaseConnection)Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<DatabaseConnection>(){

            public DatabaseConnection run() {
                return ChooseConnectionPanel.showChooseConnectionDialog(schemaElement.getUrl());
            }
        });
        return databaseConnection;
    }

    private static String trimUrl(String string) {
        assert (string != null);
        string = string.split("[\\?\\&;]")[0];
        return string;
    }

    private DatabaseConnection createDatabaseConnection(SchemaElement schemaElement) throws SQLException {
        final String string = schemaElement.getUrl();
        final String string2 = schemaElement.getUsername();
        String string3 = schemaElement.getDriver();
        JDBCDriver[] jDBCDriverArray = JDBCDriverManager.getDefault().getDrivers(string3);
        if (jDBCDriverArray.length == 0) {
            String string4 = MessageFormat.format(this.bundle.getString("EXC_NoDriverFound"), string3);
            throw new SQLException(string4);
        }
        final JDBCDriver jDBCDriver = jDBCDriverArray[0];
        DatabaseConnection databaseConnection = (DatabaseConnection)Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<DatabaseConnection>(){

            public DatabaseConnection run() {
                return ConnectionManager.getDefault().showAddConnectionDialogFromEventThread(jDBCDriver, string, string2, null);
            }
        });
        return databaseConnection;
    }

    private static class ConnectionHandler
    extends DBSchemaTablesPanel {
        public ConnectionHandler(DBSchemaWizardData dBSchemaWizardData) {
            super(dBSchemaWizardData, new ArrayList());
        }

        public boolean ensureConnection() {
            return this.init();
        }
    }
}

