/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dbschema.jdbcimpl.wizard;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.ResourceBundle;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.dbschema.DBIdentifier;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.dbschema.jdbcimpl.ConnectionProvider;
import org.netbeans.modules.dbschema.jdbcimpl.SchemaElementImpl;
import org.netbeans.modules.dbschema.jdbcimpl.wizard.DBSchemaWizardData;
import org.netbeans.modules.dbschema.jdbcimpl.wizard.ProgressFrame;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class CaptureSchema {
    ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.modules.dbschema.jdbcimpl.resources.Bundle");
    private final String defaultName = this.bundle.getString("DefaultSchemaName");
    private DBSchemaWizardData data;

    public CaptureSchema(DBSchemaWizardData dBSchemaWizardData) {
        this.data = dBSchemaWizardData;
    }

    protected void start() {
        String string = this.data.getName();
        DataFolder dataFolder = this.data.getDestinationPackage();
        final LinkedList linkedList = this.data.getTables();
        final LinkedList linkedList2 = this.data.getViews();
        final boolean bl = this.data.isAllTables();
        ConnectionProvider connectionProvider = this.data.getConnectionProvider();
        try {
            final ConnectionProvider connectionProvider2 = connectionProvider;
            final FileObject fileObject = dataFolder.getPrimaryFile();
            if (string == null || string.equals("")) {
                string = FileUtil.findFreeFileName((FileObject)fileObject, (String)this.defaultName, (String)"dbschema");
            }
            final boolean bl2 = this.data.isConnected();
            final boolean bl3 = this.data.isExistingConn();
            final DatabaseConnection databaseConnection = this.data.getDatabaseConnection();
            final String string2 = string;
            this.data = null;
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    try {
                        StatusDisplayer.getDefault().setStatusText(CaptureSchema.this.bundle.getString("CreatingDatabaseSchema"));
                        final ProgressFrame progressFrame = new ProgressFrame();
                        final SchemaElementImpl schemaElementImpl = new SchemaElementImpl(connectionProvider2);
                        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                                if (propertyChangeEvent.getPropertyName().equals("totalCount")) {
                                    progressFrame.setMaximum((Integer)propertyChangeEvent.getNewValue());
                                    return;
                                }
                                if (propertyChangeEvent.getPropertyName().equals("progress")) {
                                    progressFrame.setValue((Integer)propertyChangeEvent.getNewValue());
                                    return;
                                }
                                if (propertyChangeEvent.getPropertyName().equals("tableName")) {
                                    String string = MessageFormat.format(CaptureSchema.this.bundle.getString("CapturingTable"), ((String)propertyChangeEvent.getNewValue()).toUpperCase());
                                    progressFrame.setMessage(string);
                                    return;
                                }
                                if (propertyChangeEvent.getPropertyName().equals("FKt")) {
                                    String string = MessageFormat.format(CaptureSchema.this.bundle.getString("CaptureFK"), ((String)propertyChangeEvent.getNewValue()).toUpperCase(), CaptureSchema.this.bundle.getString("CaptureFKtable"));
                                    progressFrame.setMessage(string);
                                    return;
                                }
                                if (propertyChangeEvent.getPropertyName().equals("FKv")) {
                                    String string = MessageFormat.format(CaptureSchema.this.bundle.getString("CaptureFK"), ((String)propertyChangeEvent.getNewValue()).toUpperCase(), CaptureSchema.this.bundle.getString("CaptureFKview"));
                                    progressFrame.setMessage(string);
                                    return;
                                }
                                if (propertyChangeEvent.getPropertyName().equals("viewName")) {
                                    String string = MessageFormat.format(CaptureSchema.this.bundle.getString("CapturingView"), ((String)propertyChangeEvent.getNewValue()).toUpperCase());
                                    progressFrame.setMessage(string);
                                    return;
                                }
                                if (propertyChangeEvent.getPropertyName().equals("cancel")) {
                                    schemaElementImpl.setStop(true);
                                    StatusDisplayer.getDefault().setStatusText("");
                                    return;
                                }
                            }
                        };
                        progressFrame.propertySupport.addPropertyChangeListener(propertyChangeListener);
                        progressFrame.setVisible(true);
                        schemaElementImpl.propertySupport.addPropertyChangeListener(propertyChangeListener);
                        final SchemaElement schemaElement = new SchemaElement(schemaElementImpl);
                        schemaElement.setName(DBIdentifier.create(string2));
                        if (bl) {
                            schemaElementImpl.initTables(connectionProvider2, linkedList, linkedList2, true);
                        } else {
                            schemaElementImpl.initTables(connectionProvider2, linkedList, linkedList2, false);
                        }
                        progressFrame.finishProgress();
                        if (!schemaElementImpl.isStop()) {
                            fileObject.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                                public void run() throws IOException {
                                    FileLock fileLock;
                                    FileObject fileObject = fileObject.createData(string2, "dbschema");
                                    OutputStream outputStream = fileObject.getOutputStream(fileLock = fileObject.lock());
                                    if (outputStream == null) {
                                        throw new IOException("Unable to open output stream");
                                    }
                                    progressFrame.setMessage(CaptureSchema.this.bundle.getString("SavingDatabaseSchema"));
                                    StatusDisplayer.getDefault().setStatusText(CaptureSchema.this.bundle.getString("SavingDatabaseSchema"));
                                    schemaElement.save(outputStream);
                                    fileLock.releaseLock();
                                }
                            });
                            progressFrame.setMessage(CaptureSchema.this.bundle.getString("SchemaSaved"));
                            StatusDisplayer.getDefault().setStatusText(CaptureSchema.this.bundle.getString("SchemaSaved"));
                            progressFrame.setVisible(false);
                            progressFrame.dispose();
                        }
                        if (bl2) {
                            if (bl3) {
                                ConnectionManager.getDefault().disconnect(databaseConnection);
                            } else {
                                connectionProvider2.closeConnection();
                            }
                        }
                    }
                    catch (Exception exception) {
                        Exceptions.printStackTrace((Throwable)exception);
                    }
                }
            }, 0);
        }
        catch (Exception exception) {
            String string3 = MessageFormat.format(this.bundle.getString("UnableToCreateSchema"), exception.getMessage());
            StatusDisplayer.getDefault().setStatusText(string3);
            try {
                if (connectionProvider != null && this.data.isConnected()) {
                    if (this.data.isExistingConn()) {
                        ConnectionManager.getDefault().disconnect(this.data.getDatabaseConnection());
                    } else {
                        connectionProvider.closeConnection();
                    }
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }
}

