/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.spi.indexing.support;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.parsing.impl.indexing.DeletedIndexable;
import org.netbeans.modules.parsing.impl.indexing.FileObjectIndexable;
import org.netbeans.modules.parsing.impl.indexing.IndexDocumentImpl;
import org.netbeans.modules.parsing.impl.indexing.SPIAccessor;
import org.netbeans.modules.parsing.impl.indexing.Util;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Parameters;

public final class IndexResult {
    private static final Logger LOG = Logger.getLogger(IndexResult.class.getName());
    private final IndexDocumentImpl spi;
    private final URL root;
    private volatile URL cachedUrl;
    private volatile FileObject cachedFile;

    IndexResult(IndexDocumentImpl indexDocumentImpl, URL uRL) {
        assert (indexDocumentImpl != null);
        assert (uRL != null);
        this.spi = indexDocumentImpl;
        this.root = uRL;
    }

    public String getValue(String string) {
        Parameters.notEmpty((CharSequence)"key", (CharSequence)string);
        return this.spi.getValue(string);
    }

    public String[] getValues(String string) {
        Parameters.notEmpty((CharSequence)"key", (CharSequence)string);
        return this.spi.getValues(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getUrl() {
        if (this.cachedUrl == null) {
            URL uRL = null;
            try {
                uRL = Util.resolveUrl(this.root, this.spi.getSourceName());
            }
            catch (MalformedURLException malformedURLException) {
                LOG.log(Level.WARNING, null, malformedURLException);
            }
            IndexResult indexResult = this;
            synchronized (indexResult) {
                if (this.cachedUrl == null) {
                    this.cachedUrl = uRL;
                }
            }
        }
        return this.cachedUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject getFile() {
        if (this.cachedFile == null) {
            FileObject fileObject = null;
            URL uRL = this.getUrl();
            if (uRL != null) {
                fileObject = URLMapper.findFileObject((URL)uRL);
            }
            IndexResult indexResult = this;
            synchronized (indexResult) {
                if (this.cachedFile == null) {
                    this.cachedFile = fileObject;
                }
            }
        }
        return this.cachedFile;
    }

    public String getRelativePath() {
        return this.spi.getSourceName();
    }

    public URL getRoot() {
        return this.root;
    }

    public Indexable getIndexable() {
        FileObject fileObject;
        FileObject fileObject2 = this.getFile();
        if (fileObject2 != null && (fileObject = URLMapper.findFileObject((URL)this.root)) != null) {
            return SPIAccessor.getInstance().create(new FileObjectIndexable(fileObject, fileObject2));
        }
        return SPIAccessor.getInstance().create(new DeletedIndexable(this.root, this.getRelativePath()));
    }
}

