/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing.lucene;

import java.net.URL;
import java.util.logging.Logger;
import org.netbeans.modules.parsing.impl.indexing.lucene.util.Evictable;
import org.netbeans.modules.parsing.impl.indexing.lucene.util.EvictionPolicy;
import org.netbeans.modules.parsing.impl.indexing.lucene.util.LRUCache;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexCacheFactory {
    private static final Logger LOG = Logger.getLogger(IndexCacheFactory.class.getName());
    private static final IndexCacheFactory instance = new IndexCacheFactory();
    private final LRUCache<URL, Evictable> cache = new LRUCache<URL, Evictable>(new DefaultPolicy());

    private IndexCacheFactory() {
    }

    public LRUCache<URL, Evictable> getCache() {
        return this.cache;
    }

    public static IndexCacheFactory getDefault() {
        return instance;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultPolicy
    implements EvictionPolicy<URL, Evictable> {
        private static final int DEFAULT_SIZE = 400;
        private static final boolean NEEDS_REMOVE = Boolean.getBoolean("IndexCache.force") || Utilities.isUnix() && !Utilities.isMac();
        private static final int MAX_SIZE;

        private DefaultPolicy() {
        }

        @Override
        public boolean shouldEvict(int n, URL uRL, Evictable evictable) {
            return NEEDS_REMOVE && n > MAX_SIZE;
        }

        static {
            int n = 400;
            String string = System.getProperty("IndexCache.size");
            if (string != null) {
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    LOG.warning("Wrong (non integer) cache size: " + string);
                }
            }
            MAX_SIZE = n;
            LOG.fine("NEEDS_REMOVE: " + NEEDS_REMOVE + " MAX_SIZE: " + MAX_SIZE);
        }
    }
}

