/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Embedding {
    private Snapshot snapshot;
    private MimePath mimePath;
    private static final Comparator<int[]> TMS_VCLV = new Comparator<int[]>(){

        @Override
        public int compare(int[] nArray, int[] nArray2) {
            return nArray[0] - nArray2[0];
        }
    };

    public static Embedding create(List<Embedding> list) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException();
        }
        MimePath mimePath = null;
        Source source = null;
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        ArrayList<int[]> arrayList2 = new ArrayList<int[]>();
        int n = 0;
        for (Embedding embedding : list) {
            Snapshot snapshot = embedding.getSnapshot();
            if (mimePath != null) {
                if (!mimePath.equals(embedding.mimePath)) {
                    throw new IllegalArgumentException();
                }
                if (source != snapshot.getSource()) {
                    throw new IllegalArgumentException();
                }
            } else {
                mimePath = embedding.mimePath;
                source = snapshot.getSource();
            }
            stringBuilder.append(snapshot.getText());
            int[][] nArray = snapshot.currentToOriginal;
            for (int i = 0; i < nArray.length; ++i) {
                if (arrayList.isEmpty() || ((int[])arrayList.get(arrayList.size() - 1))[1] != -1 || nArray[i][1] != -1) {
                    arrayList.add(new int[]{nArray[i][0] + n, nArray[i][1]});
                }
                if (nArray[i][1] >= 0) {
                    if (!arrayList2.isEmpty() && ((int[])arrayList2.get(arrayList2.size() - 1))[1] >= 0) {
                        arrayList2.add(new int[]{((int[])arrayList2.get(arrayList2.size() - 1))[0] + nArray[i][0] + n - ((int[])arrayList2.get(arrayList2.size() - 1))[1], -1});
                    }
                    arrayList2.add(new int[]{nArray[i][1], nArray[i][0] + n});
                    continue;
                }
                if (arrayList2.isEmpty() || ((int[])arrayList2.get(arrayList2.size() - 1))[1] < 0) continue;
                arrayList2.add(new int[]{((int[])arrayList2.get(arrayList2.size() - 1))[0] + nArray[i][0] + n - ((int[])arrayList2.get(arrayList2.size() - 1))[1], -1});
            }
            n += snapshot.getText().length();
        }
        if (arrayList2.size() > 0 && ((int[])arrayList2.get(arrayList2.size() - 1))[1] >= 0) {
            arrayList2.add(new int[]{((int[])arrayList2.get(arrayList2.size() - 1))[0] + stringBuilder.length() - ((int[])arrayList2.get(arrayList2.size() - 1))[1], -1});
        }
        Collections.sort(arrayList2, TMS_VCLV);
        Snapshot snapshot = new Snapshot(stringBuilder, source, mimePath, (int[][])arrayList.toArray((T[])new int[arrayList.size()][]), (int[][])arrayList2.toArray((T[])new int[arrayList2.size()][]));
        return new Embedding(snapshot, mimePath);
    }

    Embedding(Snapshot snapshot, MimePath mimePath) {
        this.snapshot = snapshot;
        this.mimePath = mimePath;
    }

    public final Snapshot getSnapshot() {
        return this.snapshot;
    }

    public final String getMimeType() {
        return this.mimePath.getMimeType(this.mimePath.size() - 1);
    }

    public final boolean containsOriginalOffset(int n) {
        return this.snapshot.getEmbeddedOffset(n) >= 0;
    }

    public String toString() {
        return "Embedding (" + this.getMimeType() + ", " + this.getSnapshot() + ")";
    }
}

