/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entries;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.api.ejbjar.EnterpriseReferenceContainer;
import org.netbeans.modules.j2ee.common.DatasourceUIHelper;
import org.netbeans.modules.j2ee.core.api.support.progress.ProgressSupport;
import org.netbeans.modules.j2ee.dd.api.common.ResourceRef;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.web.WebAppMetadata;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.ejbcore.action.UseDatabaseGenerator;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entries.SelectDatabasePanel;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entries.SendEmailCodeGenerator;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class UseDatabaseCodeGenerator
implements CodeGenerator {
    private FileObject fileObject;
    private TypeElement beanClass;

    static UseDatabaseCodeGenerator createUseDatabaseAction(JTextComponent jTextComponent, CompilationController compilationController, Element element) throws IOException {
        if (element.getKind() != ElementKind.CLASS) {
            return null;
        }
        TypeElement typeElement = (TypeElement)element;
        if (!UseDatabaseCodeGenerator.isEnable(compilationController.getFileObject(), typeElement)) {
            return null;
        }
        return new UseDatabaseCodeGenerator(compilationController.getFileObject(), typeElement);
    }

    public UseDatabaseCodeGenerator(FileObject fileObject, TypeElement typeElement) {
        this.fileObject = fileObject;
        this.beanClass = typeElement;
    }

    public void invoke() {
        Project project = FileOwnerQuery.getOwner((FileObject)this.fileObject);
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        j2eeModuleProvider.getConfigSupport().ensureConfigurationReady();
        EnterpriseReferenceContainer enterpriseReferenceContainer = (EnterpriseReferenceContainer)project.getLookup().lookup(EnterpriseReferenceContainer.class);
        ResourcesHolder resourcesHolder = this.getResources(j2eeModuleProvider, this.fileObject);
        final SelectDatabasePanel selectDatabasePanel = new SelectDatabasePanel(j2eeModuleProvider, enterpriseReferenceContainer.getServiceLocatorName(), resourcesHolder.getReferences(), resourcesHolder.getModuleDataSources(), resourcesHolder.getServerDataSources(), ClasspathInfo.create((FileObject)this.fileObject));
        final DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)selectDatabasePanel, NbBundle.getMessage(UseDatabaseCodeGenerator.class, (String)"LBL_ChooseDatabase"), true, 2, DialogDescriptor.OK_OPTION, 0, new HelpCtx(SelectDatabasePanel.class), null);
        dialogDescriptor.setValid(this.checkConnections(selectDatabasePanel));
        selectDatabasePanel.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Object object;
                if (propertyChangeEvent.getPropertyName().equals("SelectDatabasePanel_isValid") && (object = propertyChangeEvent.getNewValue()) != null && object instanceof Boolean) {
                    dialogDescriptor.setValid((Boolean)object != false && UseDatabaseCodeGenerator.this.checkConnections(selectDatabasePanel));
                }
            }
        });
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (object == NotifyDescriptor.OK_OPTION) {
            String string = selectDatabasePanel.getDatasourceReference();
            UseDatabaseGenerator useDatabaseGenerator = new UseDatabaseGenerator();
            try {
                useDatabaseGenerator.generate(this.fileObject, this.beanClass.getQualifiedName().toString(), j2eeModuleProvider, string, selectDatabasePanel.getDatasource(), selectDatabasePanel.createServerResources(), selectDatabasePanel.getServiceLocator());
            }
            catch (ConfigurationException configurationException) {
                configurationException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private ResourcesHolder getResources(final J2eeModuleProvider j2eeModuleProvider, final FileObject fileObject) {
        final ResourcesHolder resourcesHolder = new ResourcesHolder();
        ArrayList<2> arrayList = new ArrayList<2>(1);
        arrayList.add(new ProgressSupport.BackgroundAction(){

            public void run(ProgressSupport.Context context) {
                String string = NbBundle.getMessage(DatasourceUIHelper.class, (String)"MSG_retrievingDS");
                context.progress(string);
                try {
                    UseDatabaseCodeGenerator.this.populateDataSourceReferences(resourcesHolder, j2eeModuleProvider, fileObject);
                }
                catch (ConfigurationException configurationException) {
                    Exceptions.printStackTrace((Throwable)configurationException);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        });
        ProgressSupport.invoke(arrayList);
        return resourcesHolder;
    }

    private void populateDataSourceReferences(final ResourcesHolder resourcesHolder, final J2eeModuleProvider j2eeModuleProvider, FileObject fileObject) throws ConfigurationException, IOException {
        final HashMap<String, Datasource> hashMap = new HashMap<String, Datasource>();
        resourcesHolder.setReferences(hashMap);
        resourcesHolder.setModuleDataSources(j2eeModuleProvider.getModuleDatasources());
        resourcesHolder.setServerDataSources(j2eeModuleProvider.getServerDatasources());
        if (j2eeModuleProvider.getJ2eeModule().getType().equals(J2eeModule.Type.EJB)) {
            MetadataModel metadataModel = EjbJar.getEjbJar((FileObject)fileObject).getMetadataModel();
            metadataModel.runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, Void>(){

                public Void run(EjbJarMetadata ejbJarMetadata) throws Exception {
                    Ejb[] ejbArray;
                    EnterpriseBeans enterpriseBeans = ejbJarMetadata.getRoot().getEnterpriseBeans();
                    if (enterpriseBeans == null) {
                        return null;
                    }
                    for (Ejb ejb : ejbArray = enterpriseBeans.getEjbs()) {
                        ResourceRef[] resourceRefArray;
                        for (ResourceRef resourceRef : resourceRefArray = ejb.getResourceRef()) {
                            String string = resourceRef.getResRefName();
                            Datasource datasource = UseDatabaseCodeGenerator.this.findDatasourceForReferenceForEjb(resourcesHolder, j2eeModuleProvider, string, ejb.getEjbName());
                            if (datasource == null) continue;
                            hashMap.put(string, datasource);
                        }
                    }
                    return null;
                }
            });
        } else if (j2eeModuleProvider.getJ2eeModule().getType().equals(J2eeModule.Type.WAR)) {
            MetadataModel metadataModel = WebModule.getWebModule((FileObject)fileObject).getMetadataModel();
            metadataModel.runReadAction((MetadataModelAction)new MetadataModelAction<WebAppMetadata, Void>(){

                public Void run(WebAppMetadata webAppMetadata) throws Exception {
                    List list = webAppMetadata.getResourceRefs();
                    for (ResourceRef resourceRef : list) {
                        String string = resourceRef.getResRefName();
                        Datasource datasource = UseDatabaseCodeGenerator.this.findDatasourceForReference(resourcesHolder, j2eeModuleProvider, string);
                        if (datasource == null) continue;
                        hashMap.put(string, datasource);
                    }
                    return null;
                }
            });
        }
    }

    private Datasource findDatasourceForReference(ResourcesHolder resourcesHolder, J2eeModuleProvider j2eeModuleProvider, String string) throws ConfigurationException {
        String string2 = j2eeModuleProvider.getConfigSupport().findDatasourceJndiName(string);
        if (string2 == null) {
            return null;
        }
        return this.findDataSource(resourcesHolder, string2);
    }

    public Datasource findDatasourceForReferenceForEjb(ResourcesHolder resourcesHolder, J2eeModuleProvider j2eeModuleProvider, String string, String string2) throws ConfigurationException {
        String string3 = j2eeModuleProvider.getConfigSupport().findDatasourceJndiNameForEjb(string2, string);
        if (string3 == null) {
            return null;
        }
        return this.findDataSource(resourcesHolder, string3);
    }

    private Datasource findDataSource(ResourcesHolder resourcesHolder, String string) {
        assert (resourcesHolder != null);
        assert (string != null);
        for (Datasource datasource : resourcesHolder.getModuleDataSources()) {
            if (!string.equals(datasource.getJndiName())) continue;
            return datasource;
        }
        for (Datasource datasource : resourcesHolder.getServerDataSources()) {
            if (!string.equals(datasource.getJndiName())) continue;
            return datasource;
        }
        return null;
    }

    private static boolean isEnable(FileObject fileObject, TypeElement typeElement) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return false;
        }
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider == null) {
            return false;
        }
        if (project.getLookup().lookup(EnterpriseReferenceContainer.class) == null) {
            return false;
        }
        return ElementKind.INTERFACE != typeElement.getKind();
    }

    private boolean checkConnections(SelectDatabasePanel selectDatabasePanel) {
        return selectDatabasePanel.getDatasource() != null;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(UseDatabaseCodeGenerator.class, (String)"LBL_UseDbAction");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ResourcesHolder {
        private Map<String, Datasource> references;
        private Set<Datasource> moduleDataSources;
        private Set<Datasource> serverDataSources;

        public void setReferences(Map<String, Datasource> map) {
            this.references = map;
        }

        public void setModuleDataSources(Set<Datasource> set) {
            this.moduleDataSources = set;
        }

        public void setServerDataSources(Set<Datasource> set) {
            this.serverDataSources = set;
        }

        public Map<String, Datasource> getReferences() {
            if (this.references == null) {
                this.references = new HashMap<String, Datasource>();
            }
            return this.references;
        }

        public Set<Datasource> getModuleDataSources() {
            if (this.moduleDataSources == null) {
                this.moduleDataSources = new HashSet<Datasource>();
            }
            return this.moduleDataSources;
        }

        public Set<Datasource> getServerDataSources() {
            if (this.serverDataSources == null) {
                this.serverDataSources = new HashSet<Datasource>();
            }
            return this.serverDataSources;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements CodeGenerator.Factory {
        public List<? extends CodeGenerator> create(Lookup lookup) {
            ArrayList<UseDatabaseCodeGenerator> arrayList = new ArrayList<UseDatabaseCodeGenerator>();
            JTextComponent jTextComponent = (JTextComponent)lookup.lookup(JTextComponent.class);
            CompilationController compilationController = (CompilationController)lookup.lookup(CompilationController.class);
            TreePath treePath = (TreePath)lookup.lookup(TreePath.class);
            TreePath treePath2 = treePath = treePath != null ? SendEmailCodeGenerator.getPathElementOfKind(Tree.Kind.CLASS, treePath) : null;
            if (jTextComponent == null || compilationController == null || treePath == null) {
                return arrayList;
            }
            try {
                UseDatabaseCodeGenerator useDatabaseCodeGenerator;
                compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                Element element = compilationController.getTrees().getElement(treePath);
                if (element != null && (useDatabaseCodeGenerator = UseDatabaseCodeGenerator.createUseDatabaseAction(jTextComponent, compilationController, element)) != null) {
                    arrayList.add(useDatabaseCodeGenerator);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return arrayList;
        }
    }
}

