/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.session;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.dd.api.ejb.Session;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.SessionMethodController;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.session.MethodChildren;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.shared.EjbViewController;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.shared.MethodsNode;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SessionChildren
extends Children.Keys<Key>
implements PropertyChangeListener {
    private static final int REMOTE = 0;
    private static final int LOCAL = 1;
    private static final int BEAN = 2;
    private final ClasspathInfo cpInfo;
    private final String ejbClass;
    private final EjbJar ejbModule;
    private final SessionMethodController controller;

    public SessionChildren(EjbViewController ejbViewController) {
        this.cpInfo = ejbViewController.getClasspathInfo();
        this.ejbClass = ejbViewController.getEjbClass();
        this.ejbModule = ejbViewController.getEjbModule();
        this.controller = new SessionMethodController(this.ejbClass, (MetadataModel<EjbJarMetadata>)this.ejbModule.getMetadataModel());
    }

    protected void addNotify() {
        super.addNotify();
        try {
            this.updateKeys();
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private void updateKeys() throws IOException {
        final boolean[] blArray = new boolean[]{false, false, true};
        this.ejbModule.getMetadataModel().runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, Void>(){

            public Void run(EjbJarMetadata ejbJarMetadata) throws Exception {
                Session session = (Session)ejbJarMetadata.findByEjbClass(SessionChildren.this.ejbClass);
                if (session != null) {
                    blArray[0] = session.getRemote() != null;
                    blArray[1] = session.getLocal() != null;
                    session.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)SessionChildren.this, (Object)session));
                }
                return null;
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ArrayList<Key> arrayList = new ArrayList<Key>();
                if (blArray[0]) {
                    arrayList.add(Key.REMOTE);
                }
                if (blArray[1]) {
                    arrayList.add(Key.LOCAL);
                }
                if (blArray[2]) {
                    arrayList.add(Key.BEAN);
                }
                SessionChildren.this.setKeys(arrayList);
            }
        });
    }

    protected void removeNotify() {
        this.setKeys(Collections.emptyList());
        super.removeNotify();
    }

    protected Node[] createNodes(Key key) {
        if (Key.LOCAL.equals((Object)key)) {
            MethodChildren methodChildren = new MethodChildren(this.cpInfo, this.controller, (Collection<String>)this.controller.getLocalInterfaces(), MethodsNode.ViewType.LOCAL);
            MethodsNode methodsNode = new MethodsNode(this.ejbClass, this.ejbModule, (Children)methodChildren, MethodsNode.ViewType.LOCAL);
            methodsNode.setIconBaseWithExtension("org/netbeans/modules/j2ee/ejbcore/resources/LocalMethodContainerIcon.gif");
            methodsNode.setDisplayName(NbBundle.getMessage(EjbViewController.class, (String)"LBL_LocalMethods"));
            return new Node[]{methodsNode};
        }
        if (Key.REMOTE.equals((Object)key)) {
            MethodChildren methodChildren = new MethodChildren(this.cpInfo, this.controller, (Collection<String>)this.controller.getRemoteInterfaces(), MethodsNode.ViewType.REMOTE);
            MethodsNode methodsNode = new MethodsNode(this.ejbClass, this.ejbModule, (Children)methodChildren, MethodsNode.ViewType.REMOTE);
            methodsNode.setIconBaseWithExtension("org/netbeans/modules/j2ee/ejbcore/resources/RemoteMethodContainerIcon.gif");
            methodsNode.setDisplayName(NbBundle.getMessage(EjbViewController.class, (String)"LBL_RemoteMethods"));
            return new Node[]{methodsNode};
        }
        if (Key.BEAN.equals((Object)key)) {
            MethodChildren methodChildren = new MethodChildren(this.cpInfo, this.controller, Arrays.asList(this.controller.getBeanClass()), MethodsNode.ViewType.NO_INTERFACE);
            MethodsNode methodsNode = new MethodsNode(this.ejbClass, this.ejbModule, (Children)methodChildren, MethodsNode.ViewType.NO_INTERFACE);
            methodsNode.setIconBaseWithExtension("org/netbeans/modules/j2ee/ejbcore/resources/MethodContainerIcon.gif");
            methodsNode.setDisplayName(NbBundle.getMessage(EjbViewController.class, (String)"LBL_BeanMethods"));
            return new Node[]{methodsNode};
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    SessionChildren.this.updateKeys();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Key {
        REMOTE,
        LOCAL,
        BEAN;

    }
}

